/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.dmn;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricCaseActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInstanceEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.history.DecisionServiceDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceTest
extends PluggableProcessEngineTest {
    public static final String DECISION_CASE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE_INSIDE_RULE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testManualActivationRuleEvaluatesDecision.cmmn";
    public static final String DECISION_CASE_WITH_DECISION_SERVICE_INSIDE_IF_PART = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testIfPartEvaluatesDecision.cmmn";
    public static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    public static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    public static final String DECISION_MULTIPLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleOutput.dmn11.xml";
    public static final String DECISION_COMPOUND_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCompoundOutput.dmn11.xml";
    public static final String DECISION_MULTIPLE_INPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleInput.dmn11.xml";
    public static final String DECISION_COLLECT_SUM_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCollectSum.dmn11.xml";
    public static final String DECISION_RETURNS_TRUE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml";
    public static final String DECISION_LITERAL_EXPRESSION_DMN = "org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn";
    public static final String DRG_DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    public static final String DECISION_DEFINITION_KEY = "testDecision";

    @Before
    public void setUp() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void tearDown() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionId()).isEqualTo((Object)decisionDefinitionId);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionKey()).isEqualTo((Object)DECISION_DEFINITION_KEY);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionName()).isEqualTo((Object)"sample decision");
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionKey()).isEqualTo((Object)processDefinition.getKey());
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionId()).isEqualTo((Object)processDefinition.getId());
        Assertions.assertThat((String)historicDecisionInstance.getProcessInstanceId()).isEqualTo((Object)processInstance.getId());
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionKey()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getCaseInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getActivityId()).isEqualTo((Object)"task");
        Assertions.assertThat((String)historicDecisionInstance.getActivityInstanceId()).isEqualTo((Object)activityInstanceId);
        Assertions.assertThat((String)historicDecisionInstance.getRootDecisionInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionRequirementsDefinitionId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionRequirementsDefinitionKey()).isNull();
        Assertions.assertThat((Date)historicDecisionInstance.getEvaluationTime()).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testCaseDecisionInstanceProperties() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_DecisionTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionId()).isEqualTo((Object)decisionDefinitionId);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionKey()).isEqualTo((Object)DECISION_DEFINITION_KEY);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionName()).isEqualTo((Object)"sample decision");
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionKey()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionKey()).isEqualTo((Object)caseDefinition.getKey());
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionId()).isEqualTo((Object)caseDefinition.getId());
        Assertions.assertThat((String)historicDecisionInstance.getCaseInstanceId()).isEqualTo((Object)caseInstance.getId());
        Assertions.assertThat((String)historicDecisionInstance.getActivityId()).isEqualTo((Object)"PI_DecisionTask_1");
        Assertions.assertThat((String)historicDecisionInstance.getActivityInstanceId()).isEqualTo((Object)activityInstanceId);
        Assertions.assertThat((Date)historicDecisionInstance.getEvaluationTime()).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionInputInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assertions.assertThat((List)inputs).isNotNull();
        Assertions.assertThat((int)inputs.size()).isEqualTo(1);
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assertions.assertThat((String)input.getDecisionInstanceId()).isEqualTo((Object)historicDecisionInstance.getId());
        Assertions.assertThat((String)input.getClauseId()).isEqualTo((Object)"in");
        Assertions.assertThat((String)input.getClauseName()).isEqualTo((Object)"input");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testMultipleDecisionInstances() {
        this.startProcessInstanceAndEvaluateDecision("a");
        this.waitASignificantAmountOfTime();
        this.startProcessInstanceAndEvaluateDecision("b");
        List historicDecisionInstances = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().orderByEvaluationTime().asc()).list();
        Assertions.assertThat((int)historicDecisionInstances.size()).isEqualTo(2);
        List inputsOfFirstDecision = ((HistoricDecisionInstance)historicDecisionInstances.get(0)).getInputs();
        Assertions.assertThat((int)inputsOfFirstDecision.size()).isEqualTo(1);
        Assertions.assertThat((Object)((HistoricDecisionInputInstance)inputsOfFirstDecision.get(0)).getValue()).isEqualTo((Object)"a");
        List inputsOfSecondDecision = ((HistoricDecisionInstance)historicDecisionInstances.get(1)).getInputs();
        Assertions.assertThat((int)inputsOfSecondDecision.size()).isEqualTo(1);
        Assertions.assertThat((Object)((HistoricDecisionInputInstance)inputsOfSecondDecision.get(0)).getValue()).isEqualTo((Object)"b");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleInput.dmn11.xml"})
    @Test
    public void testMultipleDecisionInputInstances() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("input1", "a");
        variables.put("input2", 1);
        this.runtimeService.startProcessInstanceByKey("testProcess", variables);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assertions.assertThat((int)inputs.size()).isEqualTo(2);
        Assertions.assertThat((Object)((HistoricDecisionInputInstance)inputs.get(0)).getValue()).isEqualTo((Object)"a");
        Assertions.assertThat((Object)((HistoricDecisionInputInstance)inputs.get(1)).getValue()).isEqualTo((Object)1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDisableDecisionInputInstanceByteValue() {
        byte[] bytes = "object".getBytes();
        this.startProcessInstanceAndEvaluateDecision(bytes);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeInputs().disableBinaryFetching().singleResult();
        List inputs = historicDecisionInstance.getInputs();
        Assertions.assertThat((int)inputs.size()).isEqualTo(1);
        HistoricDecisionInputInstance input = (HistoricDecisionInputInstance)inputs.get(0);
        Assertions.assertThat((String)input.getTypeName()).isEqualTo((Object)"bytes");
        Assertions.assertThat((Object)input.getValue()).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionOutputInstanceProperties() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assertions.assertThat((List)outputs).isNotNull();
        Assertions.assertThat((int)outputs.size()).isEqualTo(1);
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assertions.assertThat((String)output.getDecisionInstanceId()).isEqualTo((Object)historicDecisionInstance.getId());
        Assertions.assertThat((String)output.getClauseId()).isEqualTo((Object)"out");
        Assertions.assertThat((String)output.getClauseName()).isEqualTo((Object)"output");
        Assertions.assertThat((String)output.getRuleId()).isEqualTo((Object)"rule");
        Assertions.assertThat((Integer)output.getRuleOrder()).isEqualTo(1);
        Assertions.assertThat((String)output.getVariableName()).isEqualTo((Object)"result");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionMultipleOutput.dmn11.xml"})
    @Test
    public void testMultipleDecisionOutputInstances() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assertions.assertThat((int)outputs.size()).isEqualTo(2);
        HistoricDecisionOutputInstance firstOutput = (HistoricDecisionOutputInstance)outputs.get(0);
        Assertions.assertThat((String)firstOutput.getClauseId()).isEqualTo((Object)"out1");
        Assertions.assertThat((String)firstOutput.getRuleId()).isEqualTo((Object)"rule1");
        Assertions.assertThat((Integer)firstOutput.getRuleOrder()).isEqualTo(1);
        Assertions.assertThat((String)firstOutput.getVariableName()).isEqualTo((Object)"result1");
        Assertions.assertThat((Object)firstOutput.getValue()).isEqualTo((Object)"okay");
        HistoricDecisionOutputInstance secondOutput = (HistoricDecisionOutputInstance)outputs.get(1);
        Assertions.assertThat((String)secondOutput.getClauseId()).isEqualTo((Object)"out1");
        Assertions.assertThat((String)secondOutput.getRuleId()).isEqualTo((Object)"rule2");
        Assertions.assertThat((Integer)secondOutput.getRuleOrder()).isEqualTo(2);
        Assertions.assertThat((String)secondOutput.getVariableName()).isEqualTo((Object)"result1");
        Assertions.assertThat((Object)secondOutput.getValue()).isEqualTo((Object)"not okay");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCompoundOutput.dmn11.xml"})
    @Test
    public void testCompoundDecisionOutputInstances() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().singleResult();
        List outputs = historicDecisionInstance.getOutputs();
        Assertions.assertThat((int)outputs.size()).isEqualTo(2);
        HistoricDecisionOutputInstance firstOutput = (HistoricDecisionOutputInstance)outputs.get(0);
        Assertions.assertThat((String)firstOutput.getClauseId()).isEqualTo((Object)"out1");
        Assertions.assertThat((String)firstOutput.getRuleId()).isEqualTo((Object)"rule1");
        Assertions.assertThat((Integer)firstOutput.getRuleOrder()).isEqualTo(1);
        Assertions.assertThat((String)firstOutput.getVariableName()).isEqualTo((Object)"result1");
        Assertions.assertThat((Object)firstOutput.getValue()).isEqualTo((Object)"okay");
        HistoricDecisionOutputInstance secondOutput = (HistoricDecisionOutputInstance)outputs.get(1);
        Assertions.assertThat((String)secondOutput.getClauseId()).isEqualTo((Object)"out2");
        Assertions.assertThat((String)secondOutput.getRuleId()).isEqualTo((Object)"rule1");
        Assertions.assertThat((Integer)secondOutput.getRuleOrder()).isEqualTo(1);
        Assertions.assertThat((String)secondOutput.getVariableName()).isEqualTo((Object)"result2");
        Assertions.assertThat((Object)secondOutput.getValue()).isEqualTo((Object)"not okay");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionCollectSum.dmn11.xml"})
    @Test
    public void testCollectResultValue() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Double)historicDecisionInstance.getCollectResultValue()).isNotNull();
        Assertions.assertThat((Double)historicDecisionInstance.getCollectResultValue()).isEqualTo(3.0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/dmn/DecisionWithLiteralExpression.dmn"})
    @Test
    public void testDecisionInstancePropertiesOfDecisionLiteralExpression() {
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.decisionService.evaluateDecisionByKey("decision").variables((Map)Variables.createVariables().putValue("sum", (Object)2205)).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().includeOutputs();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.singleResult();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionId()).isEqualTo((Object)decisionDefinition.getId());
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionKey()).isEqualTo((Object)"decision");
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionName()).isEqualTo((Object)"Decision with Literal Expression");
        Assertions.assertThat((Date)historicDecisionInstance.getEvaluationTime()).isNotNull();
        Assertions.assertThat((int)historicDecisionInstance.getInputs().size()).isEqualTo(0);
        List outputs = historicDecisionInstance.getOutputs();
        Assertions.assertThat((int)outputs.size()).isEqualTo(1);
        HistoricDecisionOutputInstance output = (HistoricDecisionOutputInstance)outputs.get(0);
        Assertions.assertThat((String)output.getVariableName()).isEqualTo((Object)"result");
        Assertions.assertThat((String)output.getTypeName()).isEqualTo((Object)"string");
        Assertions.assertThat((String)((String)output.getValue())).isEqualTo((Object)"ok");
        Assertions.assertThat((String)output.getClauseId()).isNull();
        Assertions.assertThat((String)output.getClauseName()).isNull();
        Assertions.assertThat((String)output.getRuleId()).isNull();
        Assertions.assertThat((Integer)output.getRuleOrder()).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testDecisionInstancePropertiesOfDrdDecision() {
        this.decisionService.evaluateDecisionTableByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        HistoricDecisionInstance rootHistoricDecisionInstance = (HistoricDecisionInstance)query.decisionDefinitionKey("dish-decision").singleResult();
        HistoricDecisionInstance requiredHistoricDecisionInstance1 = (HistoricDecisionInstance)query.decisionDefinitionKey("season").singleResult();
        HistoricDecisionInstance requiredHistoricDecisionInstance2 = (HistoricDecisionInstance)query.decisionDefinitionKey("guestCount").singleResult();
        Assertions.assertThat((String)rootHistoricDecisionInstance.getRootDecisionInstanceId()).isNull();
        Assertions.assertThat((String)rootHistoricDecisionInstance.getDecisionRequirementsDefinitionId()).isEqualTo((Object)decisionRequirementsDefinition.getId());
        Assertions.assertThat((String)rootHistoricDecisionInstance.getDecisionRequirementsDefinitionKey()).isEqualTo((Object)decisionRequirementsDefinition.getKey());
        Assertions.assertThat((String)requiredHistoricDecisionInstance1.getRootDecisionInstanceId()).isEqualTo((Object)rootHistoricDecisionInstance.getId());
        Assertions.assertThat((String)requiredHistoricDecisionInstance1.getDecisionRequirementsDefinitionId()).isEqualTo((Object)decisionRequirementsDefinition.getId());
        Assertions.assertThat((String)requiredHistoricDecisionInstance1.getDecisionRequirementsDefinitionKey()).isEqualTo((Object)decisionRequirementsDefinition.getKey());
        Assertions.assertThat((String)requiredHistoricDecisionInstance2.getRootDecisionInstanceId()).isEqualTo((Object)rootHistoricDecisionInstance.getId());
        Assertions.assertThat((String)requiredHistoricDecisionInstance2.getDecisionRequirementsDefinitionId()).isEqualTo((Object)decisionRequirementsDefinition.getId());
        Assertions.assertThat((String)requiredHistoricDecisionInstance2.getDecisionRequirementsDefinitionKey()).isEqualTo((Object)decisionRequirementsDefinition.getKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDeleteHistoricDecisionInstances() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        this.startProcessInstanceAndEvaluateDecision();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinition.getId());
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDeleteHistoricDecisionInstanceByInstanceId() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)query.includeInputs().includeOutputs().singleResult();
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testDeleteHistoricDecisionInstanceByUndeployment() {
        String firstDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_PROCESS).addClasspathResource(DECISION_SINGLE_OUTPUT_DMN).deploy().getId();
        this.startProcessInstanceAndEvaluateDecision();
        String secondDeploymentId = this.repositoryService.createDeployment().addClasspathResource(DECISION_PROCESS).addClasspathResource(DECISION_MULTIPLE_OUTPUT_DMN).deploy().getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.repositoryService.deleteDeployment(secondDeploymentId, true);
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        this.repositoryService.deleteDeployment(firstDeploymentId, true);
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionEvaluatedWithDecisionService() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("input1", "test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, variables);
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionId()).isEqualTo((Object)decisionDefinitionId);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionKey()).isEqualTo((Object)DECISION_DEFINITION_KEY);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionName()).isEqualTo((Object)"sample decision");
        Assertions.assertThat((Date)historicDecisionInstance.getEvaluationTime()).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionKey()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getActivityId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getActivityInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getUserId()).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionEvaluatedWithAuthenticatedUser() {
        this.identityService.setAuthenticatedUserId("demo");
        VariableMap variables = Variables.putValue((String)"input1", (Object)"test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)variables);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getUserId()).isEqualTo((Object)"demo");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionEvaluatedWithAuthenticatedUserFromProcess() {
        this.identityService.setAuthenticatedUserId("demo");
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getUserId()).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDecisionEvaluatedWithAuthenticatedUserFromCase() {
        this.identityService.setAuthenticatedUserId("demo");
        this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getUserId()).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testCaseDecisionEvaluatedWithDecisionServiceInsideDelegate() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionId()).isEqualTo((Object)decisionDefinitionId);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionKey()).isEqualTo((Object)DECISION_DEFINITION_KEY);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionName()).isEqualTo((Object)"sample decision");
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionKey()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionKey()).isEqualTo((Object)caseDefinition.getKey());
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionId()).isEqualTo((Object)caseDefinition.getId());
        Assertions.assertThat((String)historicDecisionInstance.getCaseInstanceId()).isEqualTo((Object)caseInstance.getId());
        Assertions.assertThat((String)historicDecisionInstance.getActivityId()).isEqualTo((Object)"PI_HumanTask_1");
        Assertions.assertThat((String)historicDecisionInstance.getActivityInstanceId()).isEqualTo((Object)activityInstanceId);
        Assertions.assertThat((Date)historicDecisionInstance.getEvaluationTime()).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testManualActivationRuleEvaluatesDecision.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml"})
    @Test
    public void testManualActivationRuleEvaluatesDecision() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").setVariable("input1", null).setVariable("myBean", (Object)new DecisionServiceDelegate()).create();
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionId()).isEqualTo((Object)decisionDefinitionId);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionKey()).isEqualTo((Object)DECISION_DEFINITION_KEY);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionName()).isEqualTo((Object)"sample decision");
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionKey()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionKey()).isEqualTo((Object)caseDefinition.getKey());
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionId()).isEqualTo((Object)caseDefinition.getId());
        Assertions.assertThat((String)historicDecisionInstance.getCaseInstanceId()).isEqualTo((Object)caseInstance.getId());
        Assertions.assertThat((String)historicDecisionInstance.getActivityId()).isEqualTo((Object)"PI_HumanTask_1");
        Assertions.assertThat((String)historicDecisionInstance.getActivityInstanceId()).isEqualTo((Object)activityInstanceId);
        Assertions.assertThat((Date)historicDecisionInstance.getEvaluationTime()).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.testIfPartEvaluatesDecision.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.returnsTrue.dmn11.xml"})
    @Test
    public void testIfPartEvaluatesDecision() {
        CaseInstance caseInstance = this.caseService.withCaseDefinitionByKey("case").setVariable("input1", null).setVariable("myBean", (Object)new DecisionServiceDelegate()).create();
        String humanTask1 = ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        this.caseService.completeCaseExecution(humanTask1);
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().caseDefinitionId(caseInstance.getCaseDefinitionId()).singleResult();
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String activityInstanceId = ((HistoricCaseActivityInstance)this.historyService.createHistoricCaseActivityInstanceQuery().caseActivityId("PI_HumanTask_1").singleResult()).getId();
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        Assertions.assertThat((Object)historicDecisionInstance).isNotNull();
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionId()).isEqualTo((Object)decisionDefinitionId);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionKey()).isEqualTo((Object)DECISION_DEFINITION_KEY);
        Assertions.assertThat((String)historicDecisionInstance.getDecisionDefinitionName()).isEqualTo((Object)"sample decision");
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionKey()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessDefinitionId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getProcessInstanceId()).isNull();
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionKey()).isEqualTo((Object)caseDefinition.getKey());
        Assertions.assertThat((String)historicDecisionInstance.getCaseDefinitionId()).isEqualTo((Object)caseDefinition.getId());
        Assertions.assertThat((String)historicDecisionInstance.getCaseInstanceId()).isEqualTo((Object)caseInstance.getId());
        Assertions.assertThat((String)historicDecisionInstance.getActivityId()).isEqualTo((Object)"PI_HumanTask_1");
        Assertions.assertThat((String)historicDecisionInstance.getActivityInstanceId()).isEqualTo((Object)activityInstanceId);
        Assertions.assertThat((Date)historicDecisionInstance.getEvaluationTime()).isNotNull();
    }

    @Test
    public void testTableNames() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        Assertions.assertThat((String)this.managementService.getTableName(HistoricDecisionInstance.class)).isEqualTo((Object)(tablePrefix + "ACT_HI_DECINST"));
        Assertions.assertThat((String)this.managementService.getTableName(HistoricDecisionInstanceEntity.class)).isEqualTo((Object)(tablePrefix + "ACT_HI_DECINST"));
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision() {
        return this.startProcessInstanceAndEvaluateDecision(null);
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision(Object input) {
        return this.runtimeService.startProcessInstanceByKey("testProcess", (Map)this.getVariables(input));
    }

    protected CaseInstance createCaseInstanceAndEvaluateDecision() {
        return this.caseService.withCaseDefinitionByKey("case").setVariables((Map)this.getVariables("test")).create();
    }

    protected VariableMap getVariables(Object input) {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", input);
        return variables;
    }

    protected void waitASignificantAmountOfTime() {
        DateTime now = new DateTime((Object)ClockUtil.getCurrentTime());
        ClockUtil.setCurrentTime((Date)now.plusSeconds(10).toDate());
    }
}

