/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.jobexecutor;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.JobDefinitionQuery;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.jobexecutor.JobDefinitionCreationWithParseListenerTest;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class JobDefinitionCreationBothAsyncWithParseListenerTest {
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(configuration -> {
        ArrayList<1> listeners = new ArrayList<1>();
        listeners.add(new AbstractBpmnParseListener(){

            public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
                activity.setAsyncBefore(true);
                activity.setAsyncAfter(true);
            }
        });
        configuration.setCustomPreBPMNParseListeners(listeners);
    });
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);

    @Test
    public void testCreateBothAsyncJobDefinitionWithParseListener() {
        String modelFileName = "jobCreationWithinParseListener.bpmn20.xml";
        InputStream in = JobDefinitionCreationWithParseListenerTest.class.getResourceAsStream(modelFileName);
        DeploymentBuilder builder = this.engineRule.getRepositoryService().createDeployment().addInputStream(modelFileName, in);
        Deployment deployment = builder.deploy();
        this.engineRule.manageDeployment(deployment);
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        List definitions = ((JobDefinitionQuery)query.orderByJobConfiguration().asc()).list();
        TestCase.assertEquals((int)definitions.size(), (int)2);
        JobDefinition asyncAfterAfter = (JobDefinition)definitions.get(0);
        TestCase.assertEquals((String)asyncAfterAfter.getProcessDefinitionKey(), (String)"oneTaskProcess");
        TestCase.assertEquals((String)asyncAfterAfter.getActivityId(), (String)"servicetask1");
        TestCase.assertEquals((String)asyncAfterAfter.getJobConfiguration(), (String)"async-after");
        JobDefinition asyncAfterBefore = (JobDefinition)definitions.get(1);
        TestCase.assertEquals((String)asyncAfterBefore.getProcessDefinitionKey(), (String)"oneTaskProcess");
        TestCase.assertEquals((String)asyncAfterBefore.getActivityId(), (String)"servicetask1");
        TestCase.assertEquals((String)asyncAfterBefore.getJobConfiguration(), (String)"async-before");
    }

    @Test
    public void testCreateBothJobDefinitionWithParseListenerAndAsyncBeforeInXml() {
        String modelFileName = "jobAsyncBeforeCreationWithinParseListener.bpmn20.xml";
        InputStream in = JobDefinitionCreationWithParseListenerTest.class.getResourceAsStream(modelFileName);
        DeploymentBuilder builder = this.engineRule.getRepositoryService().createDeployment().addInputStream(modelFileName, in);
        Deployment deployment = builder.deploy();
        this.engineRule.manageDeployment(deployment);
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        List definitions = ((JobDefinitionQuery)query.orderByJobConfiguration().asc()).list();
        TestCase.assertEquals((int)definitions.size(), (int)2);
        JobDefinition asyncAfterAfter = (JobDefinition)definitions.get(0);
        TestCase.assertEquals((String)asyncAfterAfter.getProcessDefinitionKey(), (String)"oneTaskProcess");
        TestCase.assertEquals((String)asyncAfterAfter.getActivityId(), (String)"servicetask1");
        TestCase.assertEquals((String)asyncAfterAfter.getJobConfiguration(), (String)"async-after");
        JobDefinition asyncAfterBefore = (JobDefinition)definitions.get(1);
        TestCase.assertEquals((String)asyncAfterBefore.getProcessDefinitionKey(), (String)"oneTaskProcess");
        TestCase.assertEquals((String)asyncAfterBefore.getActivityId(), (String)"servicetask1");
        TestCase.assertEquals((String)asyncAfterBefore.getJobConfiguration(), (String)"async-before");
    }

    @Test
    public void testCreateBothJobDefinitionWithParseListenerAndAsynBothInXml() {
        String modelFileName = "jobAsyncBothCreationWithinParseListener.bpmn20.xml";
        InputStream in = JobDefinitionCreationWithParseListenerTest.class.getResourceAsStream(modelFileName);
        DeploymentBuilder builder = this.engineRule.getRepositoryService().createDeployment().addInputStream(modelFileName, in);
        Deployment deployment = builder.deploy();
        this.engineRule.manageDeployment(deployment);
        JobDefinitionQuery query = this.engineRule.getManagementService().createJobDefinitionQuery();
        List definitions = ((JobDefinitionQuery)query.orderByJobConfiguration().asc()).list();
        TestCase.assertEquals((int)definitions.size(), (int)2);
        JobDefinition asyncAfterAfter = (JobDefinition)definitions.get(0);
        TestCase.assertEquals((String)asyncAfterAfter.getProcessDefinitionKey(), (String)"oneTaskProcess");
        TestCase.assertEquals((String)asyncAfterAfter.getActivityId(), (String)"servicetask1");
        TestCase.assertEquals((String)asyncAfterAfter.getJobConfiguration(), (String)"async-after");
        JobDefinition asyncAfterBefore = (JobDefinition)definitions.get(1);
        TestCase.assertEquals((String)asyncAfterBefore.getProcessDefinitionKey(), (String)"oneTaskProcess");
        TestCase.assertEquals((String)asyncAfterBefore.getActivityId(), (String)"servicetask1");
        TestCase.assertEquals((String)asyncAfterBefore.getJobConfiguration(), (String)"async-before");
    }
}

