/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.queries;

import java.lang.invoke.CallSite;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.impl.HistoricActivityInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryImpl;
import org.camunda.bpm.engine.impl.HistoricProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricTaskInstanceQueryImpl;
import org.camunda.bpm.engine.impl.HistoricVariableInstanceQueryImpl;
import org.camunda.bpm.engine.impl.ProcessDefinitionQueryImpl;
import org.camunda.bpm.engine.impl.ProcessInstanceQueryImpl;
import org.camunda.bpm.engine.impl.cfg.IdGenerator;
import org.camunda.bpm.engine.impl.persistence.StrongUuidGenerator;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class QueryByIdAfterTest {
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(config -> config.setIdGenerator((IdGenerator)new StrongUuidGenerator()));
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RepositoryService repositoryService;
    private HistoryService historyService;
    private RuntimeService runtimeService;

    @Before
    public void init() {
        this.repositoryService = this.engineRule.getProcessEngine().getRepositoryService();
        this.historyService = this.engineRule.getProcessEngine().getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneFailingServiceProcess.bpmn20.xml"})
    public void shouldHistoricIncidentApiReturnOnlyAfterGivenId() {
        this.startProcessInstancesByKey("oneFailingServiceTaskProcess", 10);
        HistoricIncidentQueryImpl historicIncidentQuery = (HistoricIncidentQueryImpl)this.historyService.createHistoricIncidentQuery();
        List historicIncidents = ((HistoricIncidentQuery)historicIncidentQuery.orderByIncidentId().asc()).list();
        String firstId = ((HistoricIncident)historicIncidents.get(0)).getId();
        String middleId = ((HistoricIncident)historicIncidents.get(4)).getId();
        String lastId = ((HistoricIncident)historicIncidents.get(historicIncidents.size() - 1)).getId();
        Assert.assertEquals((long)10L, (long)historicIncidents.size());
        Assert.assertEquals((long)9L, (long)historicIncidentQuery.idAfter(firstId).list().size());
        Assert.assertEquals((long)0L, (long)historicIncidentQuery.idAfter(lastId).list().size());
        List secondHalf = historicIncidentQuery.idAfter(middleId).list();
        Assert.assertEquals((long)5L, (long)secondHalf.size());
        Assert.assertTrue((boolean)secondHalf.stream().allMatch(incident -> QueryByIdAfterTest.isIdGreaterThan(incident.getId(), middleId)));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldHistoricProcessInstanceApiReturnOnlyAfterGivenId() {
        this.startProcessInstancesByKey("oneTaskProcess", 10);
        HistoricProcessInstanceQueryImpl historicProcessInstanceQuery = (HistoricProcessInstanceQueryImpl)this.historyService.createHistoricProcessInstanceQuery();
        List historicProcessInstances = ((HistoricProcessInstanceQuery)historicProcessInstanceQuery.orderByProcessInstanceId().asc()).list();
        String firstId = ((HistoricProcessInstance)historicProcessInstances.get(0)).getId();
        String middleId = ((HistoricProcessInstance)historicProcessInstances.get(4)).getId();
        String lastId = ((HistoricProcessInstance)historicProcessInstances.get(historicProcessInstances.size() - 1)).getId();
        Assert.assertEquals((long)10L, (long)historicProcessInstances.size());
        Assert.assertEquals((long)9L, (long)historicProcessInstanceQuery.idAfter(firstId).list().size());
        Assert.assertEquals((long)0L, (long)historicProcessInstanceQuery.idAfter(lastId).list().size());
        List secondHalf = historicProcessInstanceQuery.idAfter(middleId).list();
        Assert.assertEquals((long)5L, (long)secondHalf.size());
        Assert.assertTrue((boolean)secondHalf.stream().allMatch(processInstance -> QueryByIdAfterTest.isIdGreaterThan(processInstance.getId(), middleId)));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldHistoricTaskInstanceApiReturnOnlyAfterGivenId() {
        this.startProcessInstancesByKey("oneTaskProcess", 10);
        HistoricTaskInstanceQueryImpl historicTaskInstanceQuery = (HistoricTaskInstanceQueryImpl)this.historyService.createHistoricTaskInstanceQuery();
        List historicTaskInstances = ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.orderByTaskId().asc()).list();
        String firstId = ((HistoricTaskInstance)historicTaskInstances.get(0)).getId();
        String middleId = ((HistoricTaskInstance)historicTaskInstances.get(4)).getId();
        String lastId = ((HistoricTaskInstance)historicTaskInstances.get(historicTaskInstances.size() - 1)).getId();
        Assert.assertEquals((long)10L, (long)historicTaskInstances.size());
        Assert.assertEquals((long)9L, (long)historicTaskInstanceQuery.idAfter(firstId).list().size());
        Assert.assertEquals((long)0L, (long)historicTaskInstanceQuery.idAfter(lastId).list().size());
        List secondHalf = historicTaskInstanceQuery.idAfter(middleId).list();
        Assert.assertEquals((long)5L, (long)secondHalf.size());
        Assert.assertTrue((boolean)secondHalf.stream().allMatch(taskInstance -> QueryByIdAfterTest.isIdGreaterThan(taskInstance.getId(), middleId)));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricActivityInstanceTest.testHistoricActivityInstanceNoop.bpmn20.xml"})
    @Ignore
    public void shouldHistoricActivityInstanceApiReturnOnlyAfterGivenId() {
        this.startProcessInstancesByKey("noopProcess", 10);
        HistoricActivityInstanceQueryImpl historicActivityInstanceQuery = (HistoricActivityInstanceQueryImpl)this.historyService.createHistoricActivityInstanceQuery();
        List historicActivityInstances = ((HistoricActivityInstanceQuery)historicActivityInstanceQuery.orderByHistoricActivityInstanceId().asc()).list();
        String firstId = ((HistoricActivityInstance)historicActivityInstances.get(0)).getId();
        String middleId = ((HistoricActivityInstance)historicActivityInstances.get(14)).getId();
        String lastId = ((HistoricActivityInstance)historicActivityInstances.get(historicActivityInstances.size() - 1)).getId();
        Assert.assertEquals((long)30L, (long)historicActivityInstances.size());
        Assert.assertEquals((long)29L, (long)historicActivityInstanceQuery.idAfter(firstId).list().size());
        Assert.assertEquals((long)0L, (long)historicActivityInstanceQuery.idAfter(lastId).list().size());
        List secondHalf = historicActivityInstanceQuery.idAfter(middleId).list();
        Assert.assertEquals((long)15L, (long)secondHalf.size());
        Assert.assertTrue((boolean)secondHalf.stream().allMatch(activityInstance -> QueryByIdAfterTest.isIdGreaterThan(activityInstance.getId(), middleId)));
    }

    @Test
    @Ignore
    public void shouldProcessDefinitionApiReturnOnlyAfterGivenId() {
        this.deployProcessDefinitions("org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml", 10);
        ProcessDefinitionQueryImpl processDefinitionQuery = (ProcessDefinitionQueryImpl)this.repositoryService.createProcessDefinitionQuery();
        List processDefinitions = ((ProcessDefinitionQuery)processDefinitionQuery.processDefinitionKey("oneTaskProcess").orderByProcessDefinitionId().asc()).list();
        String firstId = ((ProcessDefinition)processDefinitions.get(0)).getId();
        String middleId = ((ProcessDefinition)processDefinitions.get(4)).getId();
        String lastId = ((ProcessDefinition)processDefinitions.get(processDefinitions.size() - 1)).getId();
        Assert.assertEquals((long)10L, (long)processDefinitions.size());
        Assert.assertEquals((long)9L, (long)processDefinitionQuery.idAfter(firstId).list().size());
        Assert.assertEquals((long)0L, (long)processDefinitionQuery.idAfter(lastId).list().size());
        List secondHalf = processDefinitionQuery.idAfter(middleId).list();
        Assert.assertEquals((long)5L, (long)secondHalf.size());
        Assert.assertTrue((boolean)secondHalf.stream().allMatch(processDefinition -> QueryByIdAfterTest.isIdGreaterThan(processDefinition.getId(), middleId)));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void shouldProcessInstanceApiReturnOnlyAfterGivenId() {
        this.startProcessInstancesByKey("oneTaskProcess", 10);
        ProcessInstanceQueryImpl processInstanceQuery = (ProcessInstanceQueryImpl)this.runtimeService.createProcessInstanceQuery();
        List processInstances = ((ProcessInstanceQuery)processInstanceQuery.orderByProcessInstanceId().asc()).list();
        String firstId = ((ProcessInstance)processInstances.get(0)).getProcessInstanceId();
        String middleId = ((ProcessInstance)processInstances.get(4)).getProcessInstanceId();
        String lastId = ((ProcessInstance)processInstances.get(processInstances.size() - 1)).getProcessInstanceId();
        Assert.assertEquals((long)10L, (long)processInstances.size());
        Assert.assertEquals((long)9L, (long)processInstanceQuery.idAfter(firstId).list().size());
        Assert.assertEquals((long)0L, (long)processInstanceQuery.idAfter(lastId).list().size());
        List secondHalf = processInstanceQuery.idAfter(middleId).list();
        Assert.assertEquals((long)5L, (long)secondHalf.size());
        Assert.assertTrue((boolean)secondHalf.stream().allMatch(processInstance -> QueryByIdAfterTest.isIdGreaterThan(processInstance.getProcessInstanceId(), middleId)));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricVariableInstanceTest.testSimple.bpmn20.xml"})
    public void shouldVariableInstanceApiReturnOnlyAfterGivenId() {
        this.startProcessInstancesByKey("myProc", 10);
        HistoricVariableInstanceQueryImpl historicVariableInstanceQuery = (HistoricVariableInstanceQueryImpl)this.historyService.createHistoricVariableInstanceQuery();
        List historicVariableInstances = ((HistoricVariableInstanceQuery)historicVariableInstanceQuery.orderByVariableId().asc()).list();
        String firstId = ((HistoricVariableInstance)historicVariableInstances.get(0)).getId();
        String middleId = ((HistoricVariableInstance)historicVariableInstances.get(9)).getId();
        String lastId = ((HistoricVariableInstance)historicVariableInstances.get(historicVariableInstances.size() - 1)).getId();
        Assert.assertEquals((long)20L, (long)historicVariableInstances.size());
        Assert.assertEquals((long)19L, (long)historicVariableInstanceQuery.idAfter(firstId).list().size());
        Assert.assertEquals((long)0L, (long)historicVariableInstanceQuery.idAfter(lastId).list().size());
        List secondHalf = historicVariableInstanceQuery.idAfter(middleId).list();
        Assert.assertEquals((long)10L, (long)secondHalf.size());
        Assert.assertTrue((boolean)secondHalf.stream().allMatch(variable -> QueryByIdAfterTest.isIdGreaterThan(variable.getId(), middleId)));
    }

    private void deployProcessDefinitions(String resource, int numberOfDeployments) {
        for (int i = 0; i < numberOfDeployments; ++i) {
            this.testRule.deploy(resource);
        }
    }

    private void startProcessInstancesByKey(String key, int numberOfInstances) {
        for (int i = 0; i < numberOfInstances; ++i) {
            Map<String, CallSite> variables = Collections.singletonMap("message", "exception" + i);
            this.runtimeService.startProcessInstanceByKey(key, "" + i, variables);
        }
        this.testRule.executeAvailableJobs();
    }

    private static boolean isIdGreaterThan(String id1, String id2) {
        return id1.compareTo(id2) > 0;
    }
}

