/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ModificationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.BatchModificationHelper;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ModificationExecutionSyncTest {
    protected ProcessEngineRule rule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.rule);
    protected BatchModificationHelper helper = new BatchModificationHelper(this.rule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.rule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected HistoryService historyService;
    protected BpmnModelInstance instance;

    @Before
    public void createBpmnModelInstance() {
        this.instance = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").userTask("user1").sequenceFlowId("seq")).userTask("user2").userTask("user3").endEvent("end").done();
    }

    @Before
    public void initServices() {
        this.runtimeService = this.rule.getRuntimeService();
        this.historyService = this.rule.getHistoryService();
    }

    @After
    public void removeInstanceIds() {
        this.helper.currentProcessInstances = new ArrayList<String>();
    }

    @Test
    public void createSimpleModificationPlan() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> instances = this.helper.startInstances("process1", 2);
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user2")).cancelAllForActivity("user1").processInstanceIds(instances).execute();
        for (String instanceId : instances) {
            List activeActivityIds = this.runtimeService.getActiveActivityIds(instanceId);
            Assert.assertEquals((long)1L, (long)activeActivityIds.size());
            Assert.assertEquals(activeActivityIds.iterator().next(), (Object)"user2");
        }
    }

    @Test
    public void createSimpleModificationPlanWithHistoricQuery() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> instances = this.helper.startInstances("process1", 2);
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        historicProcessInstanceQuery.processDefinitionId(processDefinition.getId());
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user2")).cancelAllForActivity("user1").historicProcessInstanceQuery(historicProcessInstanceQuery).execute();
        for (String instanceId : instances) {
            List activeActivityIds = this.runtimeService.getActiveActivityIds(instanceId);
            Assert.assertEquals((long)1L, (long)activeActivityIds.size());
            Assert.assertEquals(activeActivityIds.iterator().next(), (Object)"user2");
        }
    }

    @Test
    public void createSimpleModificationPlanWithIdenticalRuntimeAndHistoryQuery() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> instances = this.helper.startInstances("process1", 2);
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        historicProcessInstanceQuery.processDefinitionId(processDefinition.getId());
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        processInstanceQuery.processDefinitionId(processDefinition.getId());
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user2")).cancelAllForActivity("user1").historicProcessInstanceQuery(historicProcessInstanceQuery).processInstanceQuery(processInstanceQuery).execute();
        for (String instanceId : instances) {
            List activeActivityIds = this.runtimeService.getActiveActivityIds(instanceId);
            Assert.assertEquals((long)1L, (long)activeActivityIds.size());
            Assert.assertEquals(activeActivityIds.iterator().next(), (Object)"user2");
        }
    }

    @Test
    public void createSimpleModificationPlanWithComplementaryRuntimeAndHistoryQueries() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> instances = this.helper.startInstances("process1", 2);
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        historicProcessInstanceQuery.processInstanceId(instances.get(0));
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        processInstanceQuery.processInstanceId(instances.get(1));
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user2")).cancelAllForActivity("user1").historicProcessInstanceQuery(historicProcessInstanceQuery).processInstanceQuery(processInstanceQuery).execute();
        for (String instanceId : instances) {
            List activeActivityIds = this.runtimeService.getActiveActivityIds(instanceId);
            Assert.assertEquals((long)1L, (long)activeActivityIds.size());
            Assert.assertEquals(activeActivityIds.iterator().next(), (Object)"user2");
        }
    }

    @Test
    public void createSimpleModificationPlanWithHistoricQueryUnfinished() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> instances = this.helper.startInstances("process1", 2);
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        historicProcessInstanceQuery.processDefinitionId(processDefinition.getId()).unfinished();
        this.runtimeService.deleteProcessInstance(instances.get(0), "test");
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("user2")).cancelAllForActivity("user1").historicProcessInstanceQuery(historicProcessInstanceQuery).execute();
        List activeActivityIds = this.runtimeService.getActiveActivityIds(instances.get(1));
        Assert.assertEquals((long)1L, (long)activeActivityIds.size());
        Assert.assertEquals(activeActivityIds.iterator().next(), (Object)"user2");
    }

    @Test
    public void createModificationWithNullProcessInstanceIdsList() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceIds((List)null).execute();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Process instance ids is empty"});
        }
    }

    @Test
    public void createModificationUsingProcessInstanceIdsListWithNullValue() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceIds(Arrays.asList("foo", null, "bar")).execute();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Process instance ids contains null value"});
        }
    }

    @Test
    public void createModificationWithEmptyProcessInstanceIdsList() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceIds(Collections.emptyList()).execute();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Process instance ids is empty"});
        }
    }

    @Test
    public void createModificationWithNullProcessDefinitionId() {
        try {
            this.runtimeService.createModification(null).cancelAllForActivity("activityId").processInstanceIds(Arrays.asList("20", "1--0")).execute();
            Assert.fail((String)"Should not succed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"processDefinitionId is null"});
        }
    }

    @Test
    public void createModificationWithNullProcessInstanceIdsArray() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceIds((String[])null).execute();
            Assert.fail((String)"Should not be able to modify");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Process instance ids is empty"});
        }
    }

    @Test
    public void createModificationUsingProcessInstanceIdsArrayWithNullValue() {
        try {
            this.runtimeService.createModification("processDefinitionId").cancelAllForActivity("user1").processInstanceIds(new String[]{"foo", null, "bar"}).execute();
            Assert.fail((String)"Should not be able to modify");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Process instance ids contains null value"});
        }
    }

    @Test
    public void testNullProcessInstanceQuery() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).processInstanceQuery(null).execute();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Process instance ids is empty"});
        }
    }

    @Test
    public void testNullHistoricProcessInstanceQuery() {
        try {
            ((ModificationBuilder)this.runtimeService.createModification("processDefinitionId").startAfterActivity("user1")).historicProcessInstanceQuery(null).execute();
            Assert.fail((String)"Should not succeed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Process instance ids is empty"});
        }
    }

    @Test
    public void createModificationWithNotMatchingProcessDefinitionId() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        try {
            this.runtimeService.createModification("foo").cancelAllForActivity("activityId").processInstanceIds(processInstanceIds).execute();
            Assert.fail((String)"Should not succed");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"processDefinition is null"});
        }
    }

    @Test
    public void testStartBefore() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition definition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        ((ModificationBuilder)this.runtimeService.createModification(definition.getId()).startBeforeActivity("user2")).processInstanceIds(processInstanceIds).execute();
        for (String processInstanceId : processInstanceIds) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(definition.getId()).activity("user1").activity("user2").done());
        }
    }

    @Test
    public void testStartAfter() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition definition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        ((ModificationBuilder)this.runtimeService.createModification(definition.getId()).startAfterActivity("user2")).processInstanceIds(processInstanceIds).execute();
        for (String processInstanceId : processInstanceIds) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(definition.getId()).activity("user1").activity("user3").done());
        }
    }

    @Test
    public void testStartTransition() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition definition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        ((ModificationBuilder)this.runtimeService.createModification(definition.getId()).startTransition("seq")).processInstanceIds(processInstanceIds).execute();
        for (String processInstanceId : processInstanceIds) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(definition.getId()).activity("user1").activity("user2").done());
        }
    }

    @Test
    public void testCancelAll() {
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        this.runtimeService.createModification(processDefinition.getId()).cancelAllForActivity("user1").processInstanceIds(processInstanceIds).execute();
        for (String processInstanceId : processInstanceIds) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNull((Object)updatedTree);
        }
    }

    @Test
    public void testStartBeforeAndCancelAll() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition definition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 2);
        ((ModificationBuilder)this.runtimeService.createModification(definition.getId()).cancelAllForActivity("user1").startBeforeActivity("user2")).processInstanceIds(processInstanceIds).execute();
        for (String processInstanceId : processInstanceIds) {
            ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
            Assert.assertNotNull((Object)updatedTree);
            Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
            ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(definition.getId()).activity("user2").done());
        }
    }

    @Test
    public void testDifferentStates() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.instance);
        ProcessDefinition definition = (ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0);
        List<String> processInstanceIds = this.helper.startInstances("process1", 1);
        Task task = (Task)this.rule.getTaskService().createTaskQuery().singleResult();
        this.rule.getTaskService().complete(task.getId());
        List<String> anotherProcessInstanceIds = this.helper.startInstances("process1", 1);
        processInstanceIds.addAll(anotherProcessInstanceIds);
        ((ModificationBuilder)this.runtimeService.createModification(definition.getId()).startBeforeActivity("user3")).processInstanceIds(processInstanceIds).execute();
        ActivityInstance updatedTree = null;
        String processInstanceId = processInstanceIds.get(0);
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(definition.getId()).activity("user2").activity("user3").done());
        processInstanceId = processInstanceIds.get(1);
        updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(definition.getId()).activity("user1").activity("user3").done());
    }

    @Test
    public void testCancelWithoutFlag() {
        this.instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("ser").camundaExpression("${true}")).userTask("user").endEvent("end").done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 1);
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("ser")).cancelAllForActivity("user").processInstanceIds(processInstanceIds).execute();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().list().size());
    }

    @Test
    public void testCancelWithoutFlag2() {
        this.instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("ser").camundaExpression("${true}")).userTask("user").endEvent("end").done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 1);
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("ser")).cancelAllForActivity("user", false).processInstanceIds(processInstanceIds).execute();
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().list().size());
    }

    @Test
    public void testCancelWithFlag() {
        this.instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("ser").camundaExpression("${true}")).userTask("user").endEvent("end").done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 1);
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("ser")).cancelAllForActivity("user", true).processInstanceIds(processInstanceIds).execute();
        ExecutionEntity execution = (ExecutionEntity)this.runtimeService.createExecutionQuery().singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((Object)"user", (Object)execution.getActivityId());
    }

    @Test
    public void testCancelWithFlagForManyInstances() {
        this.instance = ((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent("start").serviceTask("ser").camundaExpression("${true}")).userTask("user").endEvent("end").done();
        ProcessDefinition processDefinition = this.testRule.deployAndGetDefinition(this.instance);
        List<String> processInstanceIds = this.helper.startInstances("process1", 10);
        ((ModificationBuilder)this.runtimeService.createModification(processDefinition.getId()).startBeforeActivity("ser")).cancelAllForActivity("user", true).processInstanceIds(processInstanceIds).execute();
        for (String processInstanceId : processInstanceIds) {
            Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).singleResult();
            Assert.assertNotNull((Object)execution);
            Assert.assertEquals((Object)"user", (Object)((ExecutionEntity)execution).getActivityId());
        }
    }
}

