/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProcessInstantiationAtStartEventTest
extends PluggableProcessEngineTest {
    protected static final String PROCESS_DEFINITION_KEY = "testProcess";

    @Before
    public void setUp() throws Exception {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)PROCESS_DEFINITION_KEY).startEvent().userTask().endEvent().done());
    }

    @Test
    public void testStartProcessInstanceById() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.runtimeService.createProcessInstanceById(processDefinition.getId()).execute();
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceByKey() {
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).execute();
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testStartProcessInstanceAndSetBusinessKey() {
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).businessKey("businessKey").execute();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getBusinessKey()).isEqualTo((Object)"businessKey");
    }

    @Test
    public void testStartProcessInstanceAndSetCaseInstanceId() {
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).caseInstanceId("caseInstanceId").execute();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
        Assertions.assertThat((Object)processInstance).isNotNull();
        Assertions.assertThat((String)processInstance.getCaseInstanceId()).isEqualTo((Object)"caseInstanceId");
    }

    @Test
    public void testStartProcessInstanceAndSetVariable() {
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).setVariable("var", (Object)"value")).execute();
        Object variable = this.runtimeService.getVariable(processInstance.getId(), "var");
        Assertions.assertThat((Object)variable).isNotNull();
        Assertions.assertThat((Object)variable).isEqualTo((Object)"value");
    }

    @Test
    public void testStartProcessInstanceAndSetVariables() {
        VariableMap variables = Variables.createVariables().putValue("var1", (Object)"v1").putValue("var2", (Object)"v2");
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).setVariables((Map)variables)).execute();
        Assertions.assertThat((Map)this.runtimeService.getVariables(processInstance.getId())).isEqualTo((Object)variables);
    }

    @Test
    public void testStartProcessInstanceNoSkipping() {
        this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).execute(false, false);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testFailToStartProcessInstanceSkipListeners() {
        try {
            this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).execute(true, false);
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot skip"});
        }
    }

    @Test
    public void testFailToStartProcessInstanceSkipInputOutputMapping() {
        try {
            this.runtimeService.createProcessInstanceByKey(PROCESS_DEFINITION_KEY).execute(false, true);
            Assert.fail((String)"expected exception");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot skip"});
        }
    }
}

