/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.tasklistener;

import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.tasklistener.AbstractTaskListenerTest;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.RecorderTaskListener;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TaskListenerErrorThrowTest
extends AbstractTaskListenerTest {
    public static final String ERROR_CODE = "208";

    @Before
    public void resetListenerCounters() {
        ThrowBPMNErrorListener.reset();
    }

    @Test
    public void testThrowErrorOnCreateAndCatchOnUserTask() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnUserTask("create");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnAssignmentAndCatchOnUserTask() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnUserTask("assignment");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task firstTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)firstTask);
        firstTask.setAssignee("elmo");
        this.engineRule.getTaskService().saveTask(firstTask);
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnCompleteAndCatchOnUserTask() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnUserTask("complete");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task firstTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)firstTask);
        this.taskService.complete(firstTask.getId());
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnCreateAndCatchOnSubprocess() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnSubprocess("create");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnAssignmentAndCatchOnSubprocess() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnSubprocess("assignment");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task firstTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)firstTask);
        firstTask.setAssignee("elmo");
        this.engineRule.getTaskService().saveTask(firstTask);
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnCompleteAndCatchOnSubprocess() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnSubprocess("complete");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task firstTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)firstTask);
        this.taskService.complete(firstTask.getId());
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnCreateAndCatchOnEventSubprocess() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnEventSubprocess("create");
        System.out.println(Bpmn.convertToString((BpmnModelInstance)model));
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnAssignmentAndCatchOnEventSubprocess() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnEventSubprocess("assignment");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task firstTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)firstTask);
        firstTask.setAssignee("elmo");
        this.engineRule.getTaskService().saveTask(firstTask);
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnCompleteAndCatchOnEventSubprocess() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnEventSubprocess("complete");
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task firstTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)firstTask);
        this.taskService.complete(firstTask.getId());
        this.verifyErrorGotCaught();
    }

    @Test
    @Deployment
    public void testThrowErrorOnCreateScriptListenerAndCatchOnUserTask() {
        this.runtimeService.startProcessInstanceByKey("process");
        Task resultTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)resultTask);
        Assert.assertEquals((Object)"afterCatch", (Object)resultTask.getName());
    }

    @Test
    public void testThrowErrorOnAssignmentExpressionListenerAndCatchOnUserTask() {
        this.processEngineConfiguration.getBeans().put("myListener", new ThrowBPMNErrorListener());
        BpmnModelInstance model = ((BoundaryEventBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("mainTask").camundaTaskListenerExpression("assignment", "${myListener.notify(task)}")).camundaTaskListenerClass("delete", RecorderTaskListener.class.getName())).boundaryEvent("throw").error(ERROR_CODE)).userTask("afterCatch").moveToActivity("mainTask").userTask("afterThrow").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task firstTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)firstTask);
        firstTask.setAssignee("elmo");
        this.engineRule.getTaskService().saveTask(firstTask);
        this.verifyErrorGotCaught();
    }

    @Test
    public void testThrowErrorOnDeleteAndCatchOnUserTaskShouldNotTriggerPropagation() {
        BpmnModelInstance model = this.createModelThrowErrorInListenerAndCatchOnUserTask("delete");
        DeploymentWithDefinitions deployment = this.testRule.deploy(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        try {
            this.runtimeService.deleteProcessInstance(processInstance.getId(), "invoke delete listener");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("business error"));
            Assert.assertEquals((long)1L, (long)ThrowBPMNErrorListener.INVOCATIONS);
            Assert.assertEquals((long)0L, (long)RecorderTaskListener.getEventCount("delete"));
        }
        this.engineRule.getRepositoryService().deleteDeployment(deployment.getId(), true, true);
    }

    @Test
    public void testThrowUncaughtErrorOnCompleteAndCatchOnUserTask() {
        this.processEngineConfiguration.setEnableExceptionsAfterUnhandledBpmnError(true);
        BpmnModelInstance model = ((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("mainTask").camundaTaskListenerClass("complete", ThrowBPMNErrorListener.class.getName())).camundaTaskListenerClass("delete", RecorderTaskListener.class.getName())).userTask("afterThrow").endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey("process");
        Task firstTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)firstTask);
        try {
            this.taskService.complete(firstTask.getId());
        }
        catch (ProcessEngineException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("There was an exception while invoking the TaskListener"));
            Assert.assertTrue((boolean)e.getMessage().contains("Execution with id 'mainTask' throws an error event with errorCode '208' and errorMessage 'business error 208', but no error handler was defined."));
        }
        Task resultTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)resultTask);
        Assert.assertEquals((Object)"mainTask", (Object)resultTask.getName());
        Assert.assertEquals((long)1L, (long)ThrowBPMNErrorListener.INVOCATIONS);
        Assert.assertEquals((long)0L, (long)RecorderTaskListener.getEventCount("delete"));
        this.processEngineConfiguration.setEnableExceptionsAfterUnhandledBpmnError(false);
    }

    protected void verifyErrorGotCaught() {
        Task resultTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)resultTask);
        Assert.assertEquals((Object)"afterCatch", (Object)resultTask.getName());
        Assert.assertEquals((long)1L, (long)ThrowBPMNErrorListener.INVOCATIONS);
        Assert.assertEquals((long)1L, (long)RecorderTaskListener.getEventCount("delete"));
    }

    protected BpmnModelInstance createModelThrowErrorInListenerAndCatchOnUserTask(String eventName) {
        return ((BoundaryEventBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("mainTask").camundaTaskListenerClass(eventName, ThrowBPMNErrorListener.class.getName())).camundaTaskListenerClass("delete", RecorderTaskListener.class.getName())).boundaryEvent("throw").error(ERROR_CODE)).userTask("afterCatch").moveToActivity("mainTask").userTask("afterThrow").endEvent().done();
    }

    protected BpmnModelInstance createModelThrowErrorInListenerAndCatchOnSubprocess(String eventName) {
        return ((BoundaryEventBuilder)((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().subProcess("sub").embeddedSubProcess().startEvent("inSub").userTask("mainTask").camundaTaskListenerClass(eventName, ThrowBPMNErrorListener.class.getName())).camundaTaskListenerClass("delete", RecorderTaskListener.class.getName())).userTask("afterThrow").endEvent().moveToActivity("sub").boundaryEvent("throw").error(ERROR_CODE)).userTask("afterCatch").endEvent().done();
    }

    protected BpmnModelInstance createModelThrowErrorInListenerAndCatchOnEventSubprocess(String eventName) {
        ProcessBuilder processBuilder = Bpmn.createExecutableProcess((String)"process");
        BpmnModelInstance model = ((UserTaskBuilder)((UserTaskBuilder)processBuilder.startEvent().userTask("mainTask").camundaTaskListenerClass(eventName, ThrowBPMNErrorListener.class.getName())).camundaTaskListenerClass("delete", RecorderTaskListener.class.getName())).userTask("afterThrow").endEvent().done();
        ((StartEventBuilder)processBuilder.eventSubProcess().startEvent("errorEvent").error(ERROR_CODE)).userTask("afterCatch").endEvent();
        return model;
    }

    public static class ThrowBPMNErrorListener
    implements TaskListener {
        public static int INVOCATIONS = 0;

        public void notify(DelegateTask delegateTask) {
            ++INVOCATIONS;
            throw new BpmnError(TaskListenerErrorThrowTest.ERROR_CODE, "business error 208");
        }

        public static void reset() {
            INVOCATIONS = 0;
        }
    }
}

