/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.errorcode.BuiltinExceptionCode;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.Test;

public class BuiltinExceptionCodeForeignKeyConstraintViolationTest
extends ConcurrencyTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void shouldReturnForeignKeyConstraintErrorCode() {
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableStartProcessInstanceCommand("oneTaskProcess"));
        thread1.reportInterrupts();
        thread1.waitForSync();
        String processDefinitionKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult()).getId();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableDeleteProcessDefinitionCommand(processDefinitionKey));
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitUntilDone();
        thread2.makeContinue();
        thread2.waitUntilDone();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thread2.exception).isInstanceOf(ProcessEngineException.class)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FOREIGN_KEY_CONSTRAINT_VIOLATION.getCode()});
    }

    public static class ControllableStartProcessInstanceCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String processDefinitionKey;

        public ControllableStartProcessInstanceCommand(String processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            commandContext.getProcessEngineConfiguration().getRuntimeService().startProcessInstanceByKey(this.processDefinitionKey);
            this.monitor.sync();
            return null;
        }
    }

    protected static class ControllableDeleteProcessDefinitionCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String processDefinitionId;
        protected Exception exception;

        public ControllableDeleteProcessDefinitionCommand(String processDefinitionId) {
            this.processDefinitionId = processDefinitionId;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            commandContext.getProcessEngineConfiguration().getRepositoryService().deleteProcessDefinition(this.processDefinitionId);
            this.monitor.sync();
            return null;
        }
    }
}

