/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.errorcode;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class DeadlockTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected SQLException sqlException;

    @Before
    public void createTestTables() throws SQLException {
        Connection conn = this.engineRule.getProcessEngineConfiguration().getDataSource().getConnection();
        conn.setAutoCommit(false);
        Statement statement = conn.createStatement();
        statement.execute("CREATE TABLE deadlock_test1 (FOO INTEGER)");
        statement.execute("CREATE TABLE deadlock_test2 (FOO INTEGER)");
        statement.executeUpdate("INSERT INTO deadlock_test1 VALUES (0)");
        statement.executeUpdate("INSERT INTO deadlock_test2 VALUES (0)");
        conn.commit();
        this.sqlException = null;
    }

    @After
    public void cleanTables() throws SQLException {
        Connection conn = this.engineRule.getProcessEngineConfiguration().getDataSource().getConnection();
        conn.setAutoCommit(false);
        Statement statement = conn.createStatement();
        statement.execute("DROP TABLE deadlock_test1");
        statement.execute("DROP TABLE deadlock_test2");
        conn.commit();
    }

    @Test
    public void shouldProvokeDeadlock() throws InterruptedException {
        String databaseType;
        switch (databaseType = this.engineRule.getProcessEngineConfiguration().getDatabaseType()) {
            case "mysql": {
                this.provokeDeadlock();
                Assertions.assertThat((String)this.sqlException.getSQLState()).isEqualTo((Object)ExceptionUtil.DEADLOCK_CODES.MYSQL.getSqlState());
                Assertions.assertThat((int)this.sqlException.getErrorCode()).isEqualTo(ExceptionUtil.DEADLOCK_CODES.MYSQL.getErrorCode());
                break;
            }
            case "mssql": {
                this.provokeDeadlock();
                Assertions.assertThat((String)this.sqlException.getSQLState()).isEqualTo((Object)ExceptionUtil.DEADLOCK_CODES.MSSQL.getSqlState());
                Assertions.assertThat((int)this.sqlException.getErrorCode()).isEqualTo(ExceptionUtil.DEADLOCK_CODES.MSSQL.getErrorCode());
                break;
            }
            case "db2": {
                this.provokeDeadlock();
                Assertions.assertThat((String)this.sqlException.getSQLState()).isEqualTo((Object)ExceptionUtil.DEADLOCK_CODES.DB2.getSqlState());
                Assertions.assertThat((int)this.sqlException.getErrorCode()).isEqualTo(ExceptionUtil.DEADLOCK_CODES.DB2.getErrorCode());
                break;
            }
            case "oracle": {
                this.provokeDeadlock();
                Assertions.assertThat((String)this.sqlException.getSQLState()).isEqualTo((Object)ExceptionUtil.DEADLOCK_CODES.ORACLE.getSqlState());
                Assertions.assertThat((int)this.sqlException.getErrorCode()).isEqualTo(ExceptionUtil.DEADLOCK_CODES.ORACLE.getErrorCode());
                break;
            }
            case "postgres": {
                this.provokeDeadlock();
                Assertions.assertThat((String)this.sqlException.getSQLState()).isEqualTo((Object)ExceptionUtil.DEADLOCK_CODES.POSTGRES.getSqlState());
                Assertions.assertThat((int)this.sqlException.getErrorCode()).isEqualTo(ExceptionUtil.DEADLOCK_CODES.POSTGRES.getErrorCode());
                break;
            }
            case "h2": {
                this.provokeDeadlock();
                Assertions.assertThat((String)this.sqlException.getSQLState()).isEqualTo((Object)ExceptionUtil.DEADLOCK_CODES.H2.getSqlState());
                Assertions.assertThat((int)this.sqlException.getErrorCode()).isEqualTo(ExceptionUtil.DEADLOCK_CODES.H2.getErrorCode());
                break;
            }
            default: {
                Assertions.fail((String)"database unknown");
            }
        }
    }

    public void provokeDeadlock() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(2);
        DataSource dataSource = this.engineRule.getProcessEngineConfiguration().getDataSource();
        Thread t1 = new Thread(() -> {
            try (Connection conn = dataSource.getConnection();){
                try {
                    conn.setAutoCommit(false);
                    Statement statement = conn.createStatement();
                    statement.executeUpdate("UPDATE deadlock_test1 SET FOO=1");
                    latch.countDown();
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    statement.executeUpdate("UPDATE deadlock_test2 SET FOO=1");
                    conn.commit();
                }
                catch (SQLException e) {
                    this.sqlException = e;
                    try {
                        conn.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
        Thread t2 = new Thread(() -> {
            try (Connection conn = dataSource.getConnection();){
                try {
                    conn.setAutoCommit(false);
                    Statement statement = conn.createStatement();
                    statement.executeUpdate("UPDATE deadlock_test2 SET FOO=1");
                    latch.countDown();
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    statement.executeUpdate("UPDATE deadlock_test1 SET FOO=1");
                    conn.commit();
                }
                catch (SQLException e) {
                    this.sqlException = e;
                    try {
                        conn.rollback();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        });
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }
}

