/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.IncidentState;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.HistoricIncidentQueryProperty;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class HistoricIncidentQueryImpl
extends AbstractVariableQueryImpl<HistoricIncidentQuery, HistoricIncident>
implements HistoricIncidentQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String incidentType;
    protected String incidentMessage;
    protected String incidentMessageLike;
    protected String executionId;
    protected String activityId;
    protected Date createTimeBefore;
    protected Date createTimeAfter;
    protected Date endTimeBefore;
    protected Date endTimeAfter;
    protected String failedActivityId;
    protected String processInstanceId;
    protected String processDefinitionId;
    protected String processDefinitionKey;
    protected String[] processDefinitionKeys;
    protected String causeIncidentId;
    protected String rootCauseIncidentId;
    protected String configuration;
    protected String historyConfiguration;
    protected IncidentState incidentState;
    protected String[] tenantIds;
    protected boolean isTenantIdSet;
    protected String[] jobDefinitionIds;
    protected String incidentIdAfter;

    public HistoricIncidentQueryImpl() {
    }

    public HistoricIncidentQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    public HistoricIncidentQuery idAfter(String id) {
        this.incidentIdAfter = id;
        return this;
    }

    public String getIncidentIdAfter() {
        return this.incidentIdAfter;
    }

    @Override
    public HistoricIncidentQuery incidentId(String incidentId) {
        EnsureUtil.ensureNotNull("incidentId", (Object)incidentId);
        this.id = incidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery incidentType(String incidentType) {
        EnsureUtil.ensureNotNull("incidentType", (Object)incidentType);
        this.incidentType = incidentType;
        return this;
    }

    @Override
    public HistoricIncidentQuery incidentMessage(String incidentMessage) {
        EnsureUtil.ensureNotNull("incidentMessage", (Object)incidentMessage);
        this.incidentMessage = incidentMessage;
        return this;
    }

    @Override
    public HistoricIncidentQuery incidentMessageLike(String incidentMessageLike) {
        EnsureUtil.ensureNotNull("incidentMessageLike", (Object)incidentMessageLike);
        this.incidentMessageLike = incidentMessageLike;
        return this;
    }

    @Override
    public HistoricIncidentQuery executionId(String executionId) {
        EnsureUtil.ensureNotNull("executionId", (Object)executionId);
        this.executionId = executionId;
        return this;
    }

    @Override
    public HistoricIncidentQuery createTimeBefore(Date createTimeBefore) {
        EnsureUtil.ensureNotNull("createTimeBefore", (Object)createTimeBefore);
        this.createTimeBefore = createTimeBefore;
        return this;
    }

    @Override
    public HistoricIncidentQuery createTimeAfter(Date createTimeAfter) {
        EnsureUtil.ensureNotNull("createTimeAfter", (Object)createTimeAfter);
        this.createTimeAfter = createTimeAfter;
        return this;
    }

    @Override
    public HistoricIncidentQuery endTimeBefore(Date endTimeBefore) {
        EnsureUtil.ensureNotNull("endTimeBefore", (Object)endTimeBefore);
        this.endTimeBefore = endTimeBefore;
        return this;
    }

    @Override
    public HistoricIncidentQuery endTimeAfter(Date endTimeAfter) {
        EnsureUtil.ensureNotNull("endTimeAfter", (Object)endTimeAfter);
        this.endTimeAfter = endTimeAfter;
        return this;
    }

    @Override
    public HistoricIncidentQuery activityId(String activityId) {
        EnsureUtil.ensureNotNull("activityId", (Object)activityId);
        this.activityId = activityId;
        return this;
    }

    @Override
    public HistoricIncidentQuery failedActivityId(String activityId) {
        EnsureUtil.ensureNotNull("failedActivityId", (Object)activityId);
        this.failedActivityId = activityId;
        return this;
    }

    @Override
    public HistoricIncidentQuery processInstanceId(String processInstanceId) {
        EnsureUtil.ensureNotNull("processInstanceId", (Object)processInstanceId);
        this.processInstanceId = processInstanceId;
        return this;
    }

    @Override
    public HistoricIncidentQuery processDefinitionId(String processDefinitionId) {
        EnsureUtil.ensureNotNull("processDefinitionId", (Object)processDefinitionId);
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    @Override
    public HistoricIncidentQuery processDefinitionKey(String processDefinitionKey) {
        EnsureUtil.ensureNotNull("processDefinitionKey", (Object)processDefinitionKey);
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @Override
    public HistoricIncidentQuery processDefinitionKeyIn(String ... processDefinitionKeys) {
        EnsureUtil.ensureNotNull("processDefinitionKeys", processDefinitionKeys);
        this.processDefinitionKeys = processDefinitionKeys;
        return this;
    }

    @Override
    public HistoricIncidentQuery causeIncidentId(String causeIncidentId) {
        EnsureUtil.ensureNotNull("causeIncidentId", (Object)causeIncidentId);
        this.causeIncidentId = causeIncidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery rootCauseIncidentId(String rootCauseIncidentId) {
        EnsureUtil.ensureNotNull("rootCauseIncidentId", (Object)rootCauseIncidentId);
        this.rootCauseIncidentId = rootCauseIncidentId;
        return this;
    }

    @Override
    public HistoricIncidentQuery tenantIdIn(String ... tenantIds) {
        EnsureUtil.ensureNotNull("tenantIds", tenantIds);
        this.tenantIds = tenantIds;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public HistoricIncidentQuery withoutTenantId() {
        this.tenantIds = null;
        this.isTenantIdSet = true;
        return this;
    }

    @Override
    public HistoricIncidentQuery configuration(String configuration) {
        EnsureUtil.ensureNotNull("configuration", (Object)configuration);
        this.configuration = configuration;
        return this;
    }

    @Override
    public HistoricIncidentQuery historyConfiguration(String historyConfiguration) {
        EnsureUtil.ensureNotNull("historyConfiguration", (Object)historyConfiguration);
        this.historyConfiguration = historyConfiguration;
        return this;
    }

    @Override
    public HistoricIncidentQuery jobDefinitionIdIn(String ... jobDefinitionIds) {
        EnsureUtil.ensureNotNull("jobDefinitionIds", jobDefinitionIds);
        this.jobDefinitionIds = jobDefinitionIds;
        return this;
    }

    @Override
    public HistoricIncidentQuery open() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.DEFAULT;
        return this;
    }

    @Override
    public HistoricIncidentQuery resolved() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.RESOLVED;
        return this;
    }

    @Override
    public HistoricIncidentQuery deleted() {
        if (this.incidentState != null) {
            throw new ProcessEngineException("Already querying for incident state <" + this.incidentState + ">");
        }
        this.incidentState = IncidentState.DELETED;
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentId() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentMessage() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_MESSAGE);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByCreateTime() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_CREATE_TIME);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByEndTime() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_END_TIME);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentType() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_TYPE);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByExecutionId() {
        this.orderBy(HistoricIncidentQueryProperty.EXECUTION_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByActivityId() {
        this.orderBy(HistoricIncidentQueryProperty.ACTIVITY_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByProcessInstanceId() {
        this.orderBy(HistoricIncidentQueryProperty.PROCESS_INSTANCE_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByProcessDefinitionKey() {
        this.orderBy(HistoricIncidentQueryProperty.PROCESS_DEFINITION_KEY);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByProcessDefinitionId() {
        this.orderBy(HistoricIncidentQueryProperty.PROCESS_DEFINITION_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByCauseIncidentId() {
        this.orderBy(HistoricIncidentQueryProperty.CAUSE_INCIDENT_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByRootCauseIncidentId() {
        this.orderBy(HistoricIncidentQueryProperty.ROOT_CAUSE_INCIDENT_ID);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByConfiguration() {
        this.orderBy(HistoricIncidentQueryProperty.CONFIGURATION);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByHistoryConfiguration() {
        this.orderBy(HistoricIncidentQueryProperty.HISTORY_CONFIGURATION);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByIncidentState() {
        this.orderBy(HistoricIncidentQueryProperty.INCIDENT_STATE);
        return this;
    }

    @Override
    public HistoricIncidentQuery orderByTenantId() {
        return (HistoricIncidentQuery)this.orderBy(HistoricIncidentQueryProperty.TENANT_ID);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getHistoricIncidentManager().findHistoricIncidentCountByQueryCriteria(this);
    }

    @Override
    public List<HistoricIncident> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getHistoricIncidentManager().findHistoricIncidentByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public String getIncidentType() {
        return this.incidentType;
    }

    public String getIncidentMessage() {
        return this.incidentMessage;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getFailedActivityId() {
        return this.failedActivityId;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String[] getProcessDefinitionKeys() {
        return this.processDefinitionKeys;
    }

    public String getCauseIncidentId() {
        return this.causeIncidentId;
    }

    public String getRootCauseIncidentId() {
        return this.rootCauseIncidentId;
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public String getHistoryConfiguration() {
        return this.historyConfiguration;
    }

    public IncidentState getIncidentState() {
        return this.incidentState;
    }

    public boolean isTenantIdSet() {
        return this.isTenantIdSet;
    }
}

