/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg;

import org.apache.ibatis.datasource.pooled.PooledDataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ConfigurationLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ProcessEngineConfigurationTest {
    private ProcessEngineConfigurationImpl engineConfiguration;
    private ConfigurationLogger logger;
    private static final int SERIALIZABLE_VALUE = 8;
    private static final String SERIALIZABLE_NAME = "SERIALIZABLE";
    public static final ProcessEngineException EXPECTED_EXCEPTION = ProcessEngineLogger.CONFIG_LOGGER.invalidTransactionIsolationLevel("SERIALIZABLE");

    @Before
    public void setUp() {
        this.engineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResourceDefault();
        this.logger = (ConfigurationLogger)Mockito.mock(ConfigurationLogger.class);
        Mockito.when((Object)((Object)this.logger.invalidTransactionIsolationLevel(SERIALIZABLE_NAME))).thenReturn((Object)EXPECTED_EXCEPTION);
        this.engineConfiguration.initDataSource();
        ProcessEngineConfigurationImpl.LOG = this.logger;
    }

    @AfterClass
    public static void cleanUp() {
        ProcessEngineConfigurationImpl.LOG = ProcessEngineLogger.CONFIG_LOGGER;
    }

    @Test
    public void shouldEnableStandaloneTasksByDefault() {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneProcessEngineConfiguration();
        Assertions.assertThat((boolean)engineConfiguration.isStandaloneTasksEnabled()).isTrue();
    }

    @Test
    public void shouldEnableImplicitUpdatesDetectionByDefault() {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneProcessEngineConfiguration();
        Assertions.assertThat((boolean)engineConfiguration.isImplicitVariableUpdateDetectionEnabled()).isTrue();
    }

    @Test
    public void validIsolationLevel() {
        ((PooledDataSource)this.engineConfiguration.getDataSource()).setDefaultTransactionIsolationLevel(Integer.valueOf(2));
        this.engineConfiguration.initDataSource();
    }

    @Test
    public void invalidIsolationLevelWithSkipFlagDisabled() {
        ((PooledDataSource)this.engineConfiguration.getDataSource()).setDefaultTransactionIsolationLevel(Integer.valueOf(8));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineConfiguration.initDataSource()).isInstanceOf(ProcessEngineException.class)).hasMessage(EXPECTED_EXCEPTION.getMessage());
    }

    @Test
    public void invalidIsolationLevelWithSkipFlagEnabled() {
        ((PooledDataSource)this.engineConfiguration.getDataSource()).setDefaultTransactionIsolationLevel(Integer.valueOf(8));
        this.engineConfiguration.setSkipIsolationLevelCheck(true);
        this.engineConfiguration.initDataSource();
        ((ConfigurationLogger)Mockito.verify((Object)this.logger)).logSkippedIsolationLevelCheck(SERIALIZABLE_NAME);
    }

    @Test
    public void validIsolationLevelPropertyFromFileIsSetCorrectly() {
        ProcessEngineConfigurationImpl engineConfiguration = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.skipIsolationLevelCheckEnabled.xml");
        Assert.assertTrue((boolean)engineConfiguration.skipIsolationLevelCheck);
    }
}

