/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.Collections;
import java.util.List;
import org.camunda.bpm.engine.AuthorizationException;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Test;

public class TaskCommentAuthorizationTest
extends AuthorizationTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";

    @Test
    public void testDeleteTaskCommentWithoutAuthorization() {
        this.createTask("myTask");
        Comment createdComment = this.createComment("myTask", null, "aComment");
        try {
            this.taskService.deleteTaskComment("myTask", createdComment.getId());
            Assert.fail((String)"Exception expected: It should not be possible to delete a comment.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK' permission on resource 'myTask' of type 'Task' or 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask("myTask", true);
    }

    @Test
    public void testDeleteTaskComment() {
        this.createTask("myTask");
        Comment createdComment = this.taskService.createComment("myTask", null, "aComment");
        this.createGrantAuthorization((Resource)Resources.TASK, "myTask", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteTaskComment("myTask", createdComment.getId());
        Comment shouldBeDeleletedComment = this.taskService.getTaskComment("myTask", createdComment.getId());
        Assert.assertNull((Object)shouldBeDeleletedComment);
        this.deleteTask("myTask", true);
    }

    @Test
    public void testDeleteTaskCommentsWithoutAuthorization() {
        this.createTask("myTask");
        this.createComment("myTask", null, "aComment");
        try {
            this.taskService.deleteTaskComments("myTask");
            Assert.fail((String)"Exception expected: It should not be possible to delete a comment.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK' permission on resource 'myTask' of type 'Task' or 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask("myTask", true);
    }

    @Test
    public void testDeleteTaskComments() {
        this.createTask("myTask");
        this.taskService.createComment("myTask", null, "aCommentOne");
        this.taskService.createComment("myTask", null, "aCommentTwo");
        this.createGrantAuthorization((Resource)Resources.TASK, "myTask", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteTaskComments("myTask");
        List comments = this.taskService.getTaskComments("myTask");
        Assert.assertEquals((String)"The comments list should be empty", Collections.emptyList(), (Object)comments);
        this.deleteTask("myTask", true);
    }

    @Test
    public void testUpdateTaskCommentWithoutAuthorization() {
        this.createTask("myTask");
        Comment createdComment = this.createComment("myTask", null, "originalComment");
        try {
            this.taskService.updateTaskComment("myTask", createdComment.getId(), "updateMessage");
            Assert.fail((String)"Exception expected: It should not be possible to delete a comment.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK' permission on resource 'myTask' of type 'Task' or 'UPDATE' permission on resource 'myTask' of type 'Task'", e.getMessage());
        }
        this.deleteTask("myTask", true);
    }

    @Test
    public void testUpdateTaskComment() {
        this.createTask("myTask");
        String commentMessage = "OriginalCommentMessage";
        String updatedMessage = "UpdatedCommentMessage";
        Comment comment = this.taskService.createComment("myTask", null, commentMessage);
        this.createGrantAuthorization((Resource)Resources.TASK, "myTask", this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.updateTaskComment("myTask", comment.getId(), updatedMessage);
        List comments = this.taskService.getTaskComments("myTask");
        Assert.assertFalse((String)"The comments list should not be empty", (boolean)comments.isEmpty());
        Assert.assertEquals((Object)updatedMessage, (Object)((Comment)comments.get(0)).getFullMessage());
        this.deleteTask("myTask", true);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessTaskCommentWithoutAuthorization() {
        ProcessInstance processInstance = this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        Comment createdComment = this.createComment(task.getId(), processInstance.getId(), "aComment");
        try {
            this.taskService.deleteTaskComment(task.getId(), createdComment.getId());
            Assert.fail((String)"Exception expected: It should not be possible to delete a comment.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK' permission on resource", e.getMessage());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessTaskComment() {
        ProcessInstance processInstance = this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        Comment createdComment = this.taskService.createComment(task.getId(), processInstance.getId(), "aComment");
        this.createGrantAuthorization((Resource)Resources.TASK, task.getId(), this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteTaskComment(task.getId(), createdComment.getId());
        Comment shouldBeDeleletedComment = this.taskService.getTaskComment(task.getId(), createdComment.getId());
        Assert.assertNull((Object)shouldBeDeleletedComment);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessTaskCommentsWithoutAuthorization() {
        ProcessInstance processInstance = this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        this.createComment(task.getId(), processInstance.getId(), "aComment");
        try {
            this.taskService.deleteTaskComments(task.getId());
            Assert.fail((String)"Exception expected: It should not be possible to delete a comment.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK' permission on resource", e.getMessage());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDeleteProcessTaskComments() {
        ProcessInstance processInstance = this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        this.taskService.createComment(task.getId(), processInstance.getId(), "aCommentOne");
        this.taskService.createComment(task.getId(), processInstance.getId(), "aCommentTwo");
        this.createGrantAuthorization((Resource)Resources.TASK, task.getId(), this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.deleteTaskComments(task.getId());
        List comments = this.taskService.getTaskComments(task.getId());
        Assert.assertEquals((String)"The comments list should be empty", Collections.emptyList(), (Object)comments);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testUpdateProcessTaskCommentWithoutAuthorization() {
        ProcessInstance processInstance = this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        Comment createdComment = this.createComment(task.getId(), processInstance.getId(), "originalComment");
        try {
            this.taskService.updateTaskComment(task.getId(), createdComment.getId(), "updateMessage");
            Assert.fail((String)"Exception expected: It should not be possible to delete a comment.");
        }
        catch (AuthorizationException e) {
            this.testRule.assertTextPresent("The user with id 'test' does not have one of the following permissions: 'TASK_WORK' permission on resource", e.getMessage());
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testUpdateProcessTaskComment() {
        ProcessInstance processInstance = this.startProcessInstanceByKey(PROCESS_KEY);
        Task task = this.selectSingleTask();
        task.setAssignee("demo");
        String commentMessage = "OriginalCommentMessage";
        String updatedMessage = "UpdatedCommentMessage";
        Comment comment = this.taskService.createComment(task.getId(), processInstance.getId(), commentMessage);
        this.createGrantAuthorization((Resource)Resources.TASK, task.getId(), this.userId, new Permission[]{Permissions.UPDATE});
        this.taskService.updateTaskComment(task.getId(), comment.getId(), updatedMessage);
        List comments = this.taskService.getTaskComments(task.getId());
        Assert.assertFalse((String)"The comments list should not be empty", (boolean)comments.isEmpty());
        Assert.assertEquals((Object)updatedMessage, (Object)((Comment)comments.get(0)).getFullMessage());
    }
}

