/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import java.lang.reflect.Method;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.el.ExpressionManager;
import org.camunda.bpm.engine.test.api.cfg.CustomExpressionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CustomExpressionManagerTest {
    protected ProcessEngine engine;

    @Test
    public void testBuiltinFunctionMapperRegistration() {
        ProcessEngineConfigurationImpl config = (ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createStandaloneInMemProcessEngineConfiguration().setJdbcUrl("jdbc:h2:mem:camunda" + this.getClass().getSimpleName());
        CustomExpressionManager customExpressionManager = new CustomExpressionManager();
        Assert.assertTrue((boolean)customExpressionManager.getFunctions().isEmpty());
        config.setExpressionManager((ExpressionManager)customExpressionManager);
        this.engine = config.buildProcessEngine();
        Assert.assertSame((Object)((Object)customExpressionManager), (Object)config.getExpressionManager());
        Assert.assertEquals((long)4L, (long)customExpressionManager.getFunctions().size());
        Map<String, Method> functions = customExpressionManager.getFunctions();
        Assert.assertTrue((boolean)functions.containsKey("currentUser"));
        Assert.assertTrue((boolean)functions.containsKey("currentUserGroups"));
        Assert.assertTrue((boolean)functions.containsKey("now"));
        Assert.assertTrue((boolean)functions.containsKey("dateTime"));
    }

    @After
    public void tearDown() {
        if (this.engine != null) {
            this.engine.close();
            this.engine = null;
        }
    }
}

