/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cfg;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="audit")
public class PersistenceExceptionTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    private RuntimeService runtimeService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    public void testPersistenceExceptionContainsRealCause() {
        StringBuffer longString = new StringBuffer();
        for (int i = 0; i < 100; ++i) {
            longString.append("tensymbols");
        }
        BpmnModelInstance modelInstance = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"process1").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().userTask(longString.toString()).endEvent().done();
        this.testRule.deploy(modelInstance);
        try {
            this.runtimeService.startProcessInstanceByKey("process1").getId();
            Assert.fail((String)"persistence exception is expected");
        }
        catch (ProcessEngineException ex) {
            Throwable cause = ex.getCause();
            Assertions.assertThat((String)cause.getMessage()).contains(new CharSequence[]{"insertHistoricTaskInstanceEvent"});
        }
    }
}

