/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.encoding;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ProcessEngineCharacterEncodingTest {
    @Rule
    public ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected TaskService taskService;
    protected Charset defaultCharset;
    protected List<Task> tasks = new ArrayList<Task>();
    @Parameterized.Parameter(value=0)
    public Charset charset;

    @Parameterized.Parameters(name="{index} - {0}")
    public static Collection<Object[]> scenarios() {
        return Arrays.asList({StandardCharsets.UTF_8}, {StandardCharsets.UTF_16});
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setDefaultCharset(this.defaultCharset);
        for (Task task : this.tasks) {
            this.taskService.deleteTask(task.getId(), true);
        }
    }

    @Before
    public void setUp() {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.processEngineConfiguration.getTaskService();
        this.defaultCharset = this.processEngineConfiguration.getDefaultCharset();
        this.processEngineConfiguration.setDefaultCharset(this.charset);
    }

    protected Task newTask() {
        Task task = this.taskService.newTask();
        this.tasks.add(task);
        this.taskService.saveTask(task);
        return task;
    }

    protected Task newTaskWithComment(String message) {
        Task task = this.newTask();
        this.taskService.createComment(task.getId(), null, message);
        return task;
    }

    protected Comment createNewComment(String taskId, String message) {
        return this.taskService.createComment(taskId, null, message);
    }

    @Test
    public void shouldPreserveArabicTaskCommentMessageWithCharset() {
        String message = "\u0627\u06cc\u0646 \u0646\u0645\u0648\u0646\u0647 \u0627\u0633\u062a";
        Task task = this.newTaskWithComment(message);
        List taskComments = this.taskService.getTaskComments(task.getId());
        Assertions.assertThat((List)taskComments).hasSize(1);
        Assertions.assertThat((String)((Comment)taskComments.get(0)).getFullMessage()).isEqualTo((Object)message);
    }

    @Test
    public void shouldPreserveLatinTaskCommentMessageWithCharset() {
        String message = "This is an example";
        Task task = this.newTaskWithComment(message);
        List taskComments = this.taskService.getTaskComments(task.getId());
        Assertions.assertThat((List)taskComments).hasSize(1);
        Assertions.assertThat((String)((Comment)taskComments.get(0)).getFullMessage()).isEqualTo((Object)message);
    }

    @Test
    public void shouldPreserveArabicTaskUpdateCommentMessageWithCharset() {
        String taskId = this.newTask().getId();
        Comment comment = this.createNewComment(taskId, "OriginalMessage");
        String updatedMessage = "\u0627\u06cc\u0646 \u0646\u0645\u0648\u0646\u0647 \u0627\u0633\u062a";
        this.taskService.updateTaskComment(taskId, comment.getId(), updatedMessage);
        Comment updatedComment = this.taskService.getTaskComment(taskId, comment.getId());
        Assertions.assertThat((Object)updatedComment).isNotNull();
        Assertions.assertThat((String)updatedComment.getFullMessage()).isEqualTo((Object)updatedMessage);
    }

    @Test
    public void shouldPreserveLatinTaskUpdateCommentMessageWithCharset() {
        String taskId = this.newTask().getId();
        Comment comment = this.createNewComment(taskId, "OriginalMessage");
        String updatedMessage = "This is an example";
        this.taskService.updateTaskComment(taskId, comment.getId(), updatedMessage);
        Comment updatedComment = this.taskService.getTaskComment(taskId, comment.getId());
        Assertions.assertThat((Object)updatedComment).isNotNull();
        Assertions.assertThat((String)updatedComment.getFullMessage()).isEqualTo((Object)updatedMessage);
    }
}

