/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.filter;

import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.persistence.entity.FilterEntity;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterServiceTest
extends PluggableProcessEngineTest {
    protected Filter filter;

    @Before
    public void setUp() {
        this.filter = this.filterService.newTaskFilter().setName("name").setOwner("owner").setQuery((Query)this.taskService.createTaskQuery()).setProperties(new HashMap());
        Assert.assertNull((Object)this.filter.getId());
        this.filterService.saveFilter(this.filter);
        Assert.assertNotNull((Object)this.filter.getId());
    }

    @After
    public void tearDown() {
        for (Filter filter : this.filterService.createTaskFilterQuery().list()) {
            this.filterService.deleteFilter(filter.getId());
        }
    }

    @Test
    public void testCreateFilter() {
        Assert.assertNotNull((Object)this.filter);
        Filter filter2 = this.filterService.getFilter(this.filter.getId());
        Assert.assertNotNull((Object)filter2);
        FilterServiceTest.compareFilter(this.filter, filter2);
    }

    @Test
    public void testCreateInvalidFilter() {
        try {
            this.filter.setName(null);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.filter.setName("");
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.filter.setQuery((Query)null);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateFilter() {
        this.filter.setName("newName");
        this.filter.setOwner("newOwner");
        this.filter.setQuery((Query)this.taskService.createTaskQuery());
        this.filter.setProperties(new HashMap());
        this.filterService.saveFilter(this.filter);
        Filter filter2 = this.filterService.getFilter(this.filter.getId());
        FilterServiceTest.compareFilter(this.filter, filter2);
    }

    @Test
    public void testExtendFilter() {
        TaskQuery extendingQuery = this.taskService.createTaskQuery().taskName("newName").taskOwner("newOwner");
        Filter newFilter = this.filter.extend((Query)extendingQuery);
        Assert.assertNull((Object)newFilter.getId());
        TaskQueryImpl filterQuery = (TaskQueryImpl)newFilter.getQuery();
        Assert.assertEquals((Object)"newName", (Object)filterQuery.getName());
        Assert.assertEquals((Object)"newOwner", (Object)filterQuery.getOwner());
    }

    @Test
    public void testQueryFilter() {
        Filter filter2 = (Filter)this.filterService.createTaskFilterQuery().filterId(this.filter.getId()).filterName("name").filterOwner("owner").singleResult();
        FilterServiceTest.compareFilter(this.filter, filter2);
        filter2 = (Filter)this.filterService.createTaskFilterQuery().filterNameLike("%m%").singleResult();
        FilterServiceTest.compareFilter(this.filter, filter2);
    }

    @Test
    public void testQueryUnknownFilter() {
        Filter unknownFilter = (Filter)this.filterService.createTaskFilterQuery().filterId("unknown").singleResult();
        Assert.assertNull((Object)unknownFilter);
        unknownFilter = (Filter)this.filterService.createTaskFilterQuery().filterId(this.filter.getId()).filterName("invalid").singleResult();
        Assert.assertNull((Object)unknownFilter);
    }

    @Test
    public void testDeleteFilter() {
        this.filterService.deleteFilter(this.filter.getId());
        this.filter = this.filterService.getFilter(this.filter.getId());
        Assert.assertNull((Object)this.filter);
    }

    @Test
    public void testDeleteUnknownFilter() {
        this.filterService.deleteFilter(this.filter.getId());
        long count = this.filterService.createFilterQuery().count();
        Assert.assertEquals((long)0L, (long)count);
        try {
            this.filterService.deleteFilter(this.filter.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public static void compareFilter(Filter filter1, Filter filter2) {
        Assert.assertNotNull((Object)filter1);
        Assert.assertNotNull((Object)filter2);
        Assert.assertEquals((Object)filter1.getId(), (Object)filter2.getId());
        Assert.assertEquals((Object)filter1.getResourceType(), (Object)filter2.getResourceType());
        Assert.assertEquals((Object)filter1.getName(), (Object)filter2.getName());
        Assert.assertEquals((Object)filter1.getOwner(), (Object)filter2.getOwner());
        Assert.assertEquals((Object)((FilterEntity)filter1).getQueryInternal(), (Object)((FilterEntity)filter2).getQueryInternal());
        Assert.assertEquals((Object)filter1.getProperties(), (Object)filter2.getProperties());
    }
}

