/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatch;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInputInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionOutputInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricExternalTaskLog;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLog;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionInputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricDecisionOutputInstanceEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricExternalTaskLogEntity;
import org.camunda.bpm.engine.impl.persistence.entity.AttachmentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricDetailVariableInstanceUpdateEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricVariableInstanceEntity;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Comment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.history.removaltime.AbstractRemovalTimeTest;
import org.camunda.bpm.engine.test.api.history.removaltime.FailingExecutionListener;
import org.camunda.bpm.engine.test.dmn.businessruletask.TestPojo;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RemovalTimeStrategyEndTest
extends AbstractRemovalTimeTest {
    protected final String CALLED_PROCESS_KEY = "calledProcess";
    protected final BpmnModelInstance CALLED_PROCESS = ((UserTaskBuilder)((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"calledProcess").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().userTask("userTask").name("userTask")).camundaCandidateUsers("foo")).endEvent().done();
    protected final String CALLING_PROCESS_KEY = "callingProcess";
    protected final BpmnModelInstance CALLING_PROCESS = ((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done();
    protected final Date START_DATE = new Date(1363607000000L);
    protected final Date END_DATE = new GregorianCalendar(2013, 2, 18, 13, 0, 0).getTime();

    @Before
    public void setUp() {
        processEngineConfiguration.setHistoryRemovalTimeStrategy("end").setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)new DefaultHistoryRemovalTimeProvider()).initHistoryRemovalTime();
    }

    @After
    public void clearDatabase() {
        this.clearAuthorization();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionInstance() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaAsyncAfter()).camundaDecisionRef("dish-decision")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime(), (Matcher)IsNull.nullValue());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInstance)historicDecisionInstances.get(2)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionInputInstance() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaAsyncAfter()).camundaDecisionRef("dish-decision")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        List historicDecisionInputInstances = historicDecisionInstance.getInputs();
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime(), (Matcher)IsNull.nullValue());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        historicDecisionInputInstances = historicDecisionInstance.getInputs();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDecisionInputInstance)historicDecisionInputInstances.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldResolveHistoricDecisionOutputInstance() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaAsyncAfter()).camundaDecisionRef("dish-decision")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        List historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        MatcherAssert.assertThat((Object)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime(), (Matcher)IsNull.nullValue());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        historicDecisionOutputInstances = historicDecisionInstance.getOutputs();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDecisionOutputInstance)historicDecisionOutputInstances.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricProcessInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult();
        MatcherAssert.assertThat((Object)historicProcessInstance.getRemovalTime(), (Matcher)IsNull.nullValue());
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("calledProcess").singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)historicProcessInstance.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricActivityInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        MatcherAssert.assertThat((Object)historicActivityInstance.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.taskService.complete(taskId);
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("userTask").singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)historicActivityInstance.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @RequiredDatabase(excludes={"mysql"})
    public void shouldResolveHistoricActivityInstanceInConcurrentEnvironment() {
        int degreeOfParallelism = 30;
        this.testRule.deploy(((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().serviceTask().camundaExpression("${true}")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        try {
            IntStream.range(0, degreeOfParallelism).parallel().forEach(i -> this.runtimeService.startProcessInstanceByKey("process"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"No exception should occur");
        }
    }

    @Test
    public void shouldResolveHistoricTaskInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        MatcherAssert.assertThat((Object)historicTaskInstance.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        historicTaskInstance = (HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)historicTaskInstance.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricTaskAuthorization_HistoricTaskInstance() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("myUserId");
        authorization.setResource((Resource)Resources.HISTORIC_TASK);
        authorization.setResourceId(taskId);
        this.authorizationService.saveAuthorization(authorization);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        Date removalTime = this.addDays(this.END_DATE, 5);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResetAuthorizationAfterUpdate_HistoricTaskInstance() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.enabledAuth();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.disableAuth();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getProcessInstanceId()));
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveAuthorizationAfterUpdate_HistoricTaskInstance() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_TASK);
        authorization.setResourceId("*");
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)IsNull.nullValue());
        taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        authorization.setResourceId(taskId);
        this.authorizationService.saveAuthorization(authorization);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRootProcessInstanceId(), (Matcher)Is.is((Object)processInstance.getRootProcessInstanceId()));
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricTaskAuthorization_HistoricProcessInstance() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        String rootProcessInstanceId = this.runtimeService.startProcessInstanceByKey("callingProcess").getProcessInstanceId();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("myUserId");
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult()).getId();
        authorization.setResourceId(processInstanceId);
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, processInstanceId, rootProcessInstanceId})});
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        Date removalTime = this.addDays(this.END_DATE, 5);
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{removalTime, processInstanceId, rootProcessInstanceId})});
    }

    @Test
    public void shouldResetAuthorizationAfterUpdate_HistoricProcessInstance() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.enabledAuth();
        String rootProcessInstanceId = this.runtimeService.startProcessInstanceByKey("callingProcess").getProcessInstanceId();
        this.disableAuth();
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setUserId("myUserId");
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().activeActivityIdIn(new String[]{"userTask"}).singleResult()).getId();
        authorization.setResourceId(processInstanceId);
        this.authorizationService.saveAuthorization(authorization);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Date removalTime = this.addDays(this.END_DATE, 5);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{removalTime, processInstanceId, rootProcessInstanceId})});
        authorization.setResourceId("*");
        this.authorizationService.saveAuthorization(authorization);
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "*", null})});
    }

    @Test
    public void shouldResolveAuthorizationAfterUpdate_HistoricProcessInstance() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        ProcessInstance rootProcessInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        Authorization authorization = this.authorizationService.createNewAuthorization(1);
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        authorization.setResourceId("*");
        authorization.setUserId("foo");
        this.authorizationService.saveAuthorization(authorization);
        AuthorizationQuery authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{null, "*", null})});
        String processInstanceId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().executedActivityIdIn(new String[]{"userTask"}).singleResult()).getId();
        authorization.setResourceId(processInstanceId);
        this.authorizationService.saveAuthorization(authorization);
        authQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        Date removalTime = this.addDays(this.END_DATE, 5);
        String rootProcessInstanceId = rootProcessInstance.getRootProcessInstanceId();
        Assertions.assertThat((List)authQuery.list()).extracting(new String[]{"removalTime", "resourceId", "rootProcessInstanceId"}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{removalTime, processInstanceId, rootProcessInstanceId})});
    }

    @Test
    public void shouldWriteHistoryAndResolveHistoricTaskAuthorizationInDifferentTransactions() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.enabledAuth();
        this.taskService.setAssignee(taskId, "myUserId");
        this.disableAuth();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldWriteHistoryAndResolveHistoricTaskAuthorizationInSameTransaction() {
        processEngineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.enabledAuth();
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.disableAuth();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        Authorization authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        authorization = (Authorization)this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)authorization.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveVariableInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        HistoricVariableInstance historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        MatcherAssert.assertThat((Object)historicVariableInstance.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        historicVariableInstance = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)historicVariableInstance.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricDetailByVariableInstanceUpdate() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        MatcherAssert.assertThat((Object)((HistoricDetail)historicDetails.get(0)).getRemovalTime(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)((HistoricDetail)historicDetails.get(1)).getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricDetail)historicDetails.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricDetail)historicDetails.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveHistoricDetailByFormProperty() {
        DeploymentWithDefinitions deployment = this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        String processDefinitionId = ((ProcessDefinition)deployment.getDeployedProcessDefinitions().get(0)).getId();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("aFormProperty", "aFormPropertyValue");
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.formService.submitStartForm(processDefinitionId, properties);
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().formFields().singleResult();
        MatcherAssert.assertThat((Object)historicDetail.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().formFields().singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)historicDetail.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveIncident() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().scriptTask().camundaAsyncBefore()).scriptFormat("groovy")).scriptText("if(execution.getIncidents().size() == 0) throw new RuntimeException()")).userTask().endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(0)).getRemovalTime(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(1)).getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveIncidentWithPreservedCreateTime() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().scriptTask().camundaAsyncBefore()).scriptFormat("groovy")).scriptText("if(execution.getIncidents().size() == 0) throw new RuntimeException()")).userTask().endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(0)).getCreateTime(), (Matcher)Is.is((Object)this.START_DATE));
        MatcherAssert.assertThat((Object)((HistoricIncident)historicIncidents.get(1)).getCreateTime(), (Matcher)Is.is((Object)this.START_DATE));
    }

    @Test
    public void shouldNotResolveStandaloneIncident() {
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.repositoryService.suspendProcessDefinitionByKey("calledProcess", true, new Date());
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.managementService.executeJob(jobId);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicIncident.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.clearJobLog(jobId);
        this.clearHistoricIncident(historicIncident);
    }

    @Test
    public void shouldResolveExternalTaskLog() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        LockedExternalTask externalTask = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("anExternalTaskTopic", 3000L).execute().get(0);
        HistoricExternalTaskLog externalTaskLog = (HistoricExternalTaskLog)this.historyService.createHistoricExternalTaskLogQuery().singleResult();
        MatcherAssert.assertThat((Object)externalTaskLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.externalTaskService.complete(externalTask.getId(), "aWorkerId");
        Date removalTime = this.addDays(this.END_DATE, 5);
        List externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().list();
        MatcherAssert.assertThat((Object)((HistoricExternalTaskLog)externalTaskLogs.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricExternalTaskLog)externalTaskLogs.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveExternalTaskLogWithTimestampPreserved() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        LockedExternalTask externalTask = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("anExternalTaskTopic", 3000L).execute().get(0);
        this.externalTaskService.complete(externalTask.getId(), "aWorkerId");
        List externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().list();
        MatcherAssert.assertThat((Object)((HistoricExternalTaskLog)externalTaskLogs.get(0)).getTimestamp(), (Matcher)Is.is((Object)this.START_DATE));
        MatcherAssert.assertThat((Object)((HistoricExternalTaskLog)externalTaskLogs.get(1)).getTimestamp(), (Matcher)Is.is((Object)this.START_DATE));
    }

    @Test
    public void shouldResolveJobLog() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List jobLog = this.historyService.createHistoricJobLogQuery().list();
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(0)).getRemovalTime(), (Matcher)IsNull.nullValue());
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(1)).getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        jobLog = this.historyService.createHistoricJobLogQuery().list();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(0)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(1)).getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveJobLogWithTimestampPreserved() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        List jobLog = this.historyService.createHistoricJobLogQuery().list();
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(0)).getTimestamp(), (Matcher)Is.is((Object)this.START_DATE));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLog.get(1)).getTimestamp(), (Matcher)Is.is((Object)this.START_DATE));
    }

    @Test
    public void shouldResolveUserOperationLog_SetJobRetries() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.managementService.setJobRetries(jobId, 65);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveUserOperationLog_SetExternalTaskRetries() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String externalTaskId = ((ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.externalTaskService.setRetries(externalTaskId, 65);
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        LockedExternalTask externalTask = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("anExternalTaskTopic", 2000L).execute().get(0);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.externalTaskService.complete(externalTask.getId(), "aWorkerId");
        Date removalTime = this.addDays(this.END_DATE, 5);
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveUserOperationLog_ClaimTask() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.taskService.claim(taskId, "aUserId");
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveUserOperationLog_CreateAttachment() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com");
        this.identityService.clearAuthentication();
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)userOperationLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveUserOperationLogWithTimestampPreserved() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com");
        this.identityService.clearAuthentication();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry userOperationLog = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        MatcherAssert.assertThat((Object)userOperationLog.getTimestamp(), (Matcher)Is.is((Object)this.START_DATE));
    }

    @Test
    public void shouldResolveIdentityLink_AddCandidateUser() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, "aUserId");
        HistoricIdentityLinkLog historicIdentityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().userId("aUserId").singleResult();
        MatcherAssert.assertThat((Object)historicIdentityLinkLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        historicIdentityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().userId("aUserId").singleResult();
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)historicIdentityLinkLog.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveIdentityLinkWithTimePreserved() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, "aUserId");
        this.taskService.complete(taskId);
        HistoricIdentityLinkLog historicIdentityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().userId("aUserId").singleResult();
        MatcherAssert.assertThat((Object)historicIdentityLinkLog.getTime(), (Matcher)Is.is((Object)this.START_DATE));
    }

    @Test
    public void shouldNotResolveIdentityLink_AddCandidateUser() {
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        Task aTask = this.taskService.newTask();
        this.taskService.saveTask(aTask);
        this.taskService.addCandidateUser(aTask.getId(), "aUserId");
        HistoricIdentityLinkLog historicIdentityLinkLog = (HistoricIdentityLinkLog)this.historyService.createHistoricIdentityLinkLogQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIdentityLinkLog, (Matcher)IsNull.notNullValue());
        MatcherAssert.assertThat((Object)historicIdentityLinkLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.taskService.complete(aTask.getId());
        this.clearHistoricTaskInst(aTask.getId());
    }

    @Test
    public void shouldResolveCommentByProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createComment(null, processInstanceId, "aMessage");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)IsNull.nullValue());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveCommentByTaskId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.createComment(taskId, null, "aMessage");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveCommentByWrongTaskIdAndProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createComment("aNonExistentTaskId", processInstanceId, "aMessage");
        Comment comment = (Comment)this.taskService.getProcessInstanceComments(processInstanceId).get(0);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveCommentByTaskIdAndWrongProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.createComment(taskId, "aNonExistentProcessInstanceId", "aMessage");
        Comment comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        comment = (Comment)this.taskService.getTaskComments(taskId).get(0);
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)comment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveAttachmentByProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)IsNull.nullValue());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        Date removalTime = this.addDays(this.END_DATE, 5);
        attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveAttachmentByTaskId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, taskId, null, null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        attachment = this.taskService.getAttachment(attachmentId);
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldNotResolveAttachmentByWrongTaskIdAndProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, "aWrongTaskId", processInstanceId, null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldResolveAttachmentByTaskIdAndWrongProcessInstanceId() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        String attachmentId = this.taskService.createAttachment(null, taskId, "aWrongProcessInstanceId", null, null, "http://camunda.com").getId();
        Attachment attachment = this.taskService.getAttachment(attachmentId);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        attachment = this.taskService.getAttachment(attachmentId);
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)attachment.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_CreateAttachmentByTask() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, taskId, null, null, null, (InputStream)new ByteArrayInputStream("hello world".getBytes()));
        ByteArrayEntity byteArray = this.findByteArrayById(attachment.getContentId());
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        byteArray = this.findByteArrayById(attachment.getContentId());
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_CreateAttachmentByProcessInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String calledProcessInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        AttachmentEntity attachment = (AttachmentEntity)this.taskService.createAttachment(null, null, calledProcessInstanceId, null, null, (InputStream)new ByteArrayInputStream("hello world".getBytes()));
        ByteArrayEntity byteArray = this.findByteArrayById(attachment.getContentId());
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        byteArray = this.findByteArrayById(attachment.getContentId());
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_SetVariable() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)new ByteArrayInputStream("hello world".getBytes()));
        HistoricVariableInstanceEntity historicVariableInstance = (HistoricVariableInstanceEntity)this.historyService.createHistoricVariableInstanceQuery().singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(historicVariableInstance.getByteArrayId());
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)IsNull.nullValue());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        byteArray = this.findByteArrayById(historicVariableInstance.getByteArrayId());
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_UpdateVariable() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)new ByteArrayInputStream("hello world".getBytes()));
        HistoricDetailVariableInstanceUpdateEntity historicDetails = (HistoricDetailVariableInstanceUpdateEntity)this.historyService.createHistoricDetailQuery().variableUpdates().variableTypeIn(new String[]{"Bytes"}).singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(historicDetails.getByteArrayValueId());
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        byteArray = this.findByteArrayById(historicDetails.getByteArrayValueId());
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_JobLog() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().scriptTask().camundaAsyncBefore()).scriptFormat("groovy")).scriptText("if(execution.getIncidents().size() == 0) throw new RuntimeException(\"I'm supposed to fail!\")")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogEventEntity jobLog = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(jobLog.getExceptionByteArrayId());
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Date removalTime = this.addDays(this.END_DATE, 5);
        byteArray = this.findByteArrayById(jobLog.getExceptionByteArrayId());
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveByteArray_ExternalTaskLog() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("aTopicName")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((LockedExternalTask)this.externalTaskService.fetchAndLock(5, "aWorkerId").topic("aTopicName", Integer.MAX_VALUE).execute().get(0)).getId();
        this.externalTaskService.handleFailure(taskId, "aWorkerId", null, "errorDetails", 5, 3000L);
        HistoricExternalTaskLogEntity externalTaskLog = (HistoricExternalTaskLogEntity)this.historyService.createHistoricExternalTaskLogQuery().failureLog().singleResult();
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(externalTaskLog.getErrorDetailsByteArrayId());
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.externalTaskService.complete(taskId, "aWorkerId");
        byteArrayEntity = this.findByteArrayById(externalTaskLog.getErrorDetailsByteArrayId());
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldResolveByteArray_DecisionInput() {
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("testDecision")).userTask().endEvent().done());
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeInputs().singleResult();
        HistoricDecisionInputInstanceEntity historicDecisionInputInstanceEntity = (HistoricDecisionInputInstanceEntity)historicDecisionInstance.getInputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionInputInstanceEntity.getByteArrayValueId());
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)IsNull.nullValue());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        byteArrayEntity = this.findByteArrayById(historicDecisionInputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/testDmnWithPojo.dmn11.xml"})
    public void shouldResolveByteArray_DecisionOutput() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("testDecision")).userTask().endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        HistoricDecisionOutputInstanceEntity historicDecisionOutputInstanceEntity = (HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)IsNull.nullValue());
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/history/removaltime/HistoricRootProcessInstanceTest.shouldResolveByteArray_DecisionOutputLiteralExpression.dmn"})
    public void shouldResolveByteArray_DecisionOutputLiteralExpression() {
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        this.testRule.deploy(((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaDecisionRef("testDecision")).userTask().endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("pojo", (Object)new TestPojo("okay", 13.37)));
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().rootDecisionInstancesOnly().includeOutputs().singleResult();
        HistoricDecisionOutputInstanceEntity historicDecisionOutputInstanceEntity = (HistoricDecisionOutputInstanceEntity)historicDecisionInstance.getOutputs().get(0);
        ByteArrayEntity byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)IsNull.nullValue());
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        byteArrayEntity = this.findByteArrayById(historicDecisionOutputInstanceEntity.getByteArrayValueId());
        Date removalTime = this.addDays(this.END_DATE, 5);
        MatcherAssert.assertThat((Object)byteArrayEntity.getRemovalTime(), (Matcher)Is.is((Object)removalTime));
    }

    @Test
    public void shouldResolveBatch() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            this.managementService.executeJob(job.getId());
        }
        HistoricBatch historicBatch = (HistoricBatch)this.historyService.createHistoricBatchQuery().singleResult();
        MatcherAssert.assertThat((Object)historicBatch.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.END_DATE, 5)));
        this.historyService.deleteHistoricBatch(batch.getId());
    }

    @Test
    public void shouldResolveBatchJobLog() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            this.managementService.executeJob(job.getId());
        }
        List jobLogs = this.historyService.createHistoricJobLogQuery().list();
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLogs.get(0)).getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.END_DATE, 5)));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLogs.get(1)).getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.END_DATE, 5)));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLogs.get(2)).getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.END_DATE, 5)));
        this.historyService.deleteHistoricBatch(batch.getId());
    }

    @Test
    public void shouldResolveBatchJobLog_ByteArray() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        FailingExecutionListener.shouldFail = true;
        this.testRule.deploy(((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().camundaExecutionListenerClass("end", FailingExecutionListener.class)).endEvent().done());
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            try {
                this.managementService.executeJob(job.getId());
            }
            catch (RuntimeException runtimeException) {}
        }
        jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            this.managementService.executeJob(job.getId());
        }
        HistoricJobLogEventEntity jobLog = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        String byteArrayId = jobLog.getExceptionByteArrayId();
        ByteArrayEntity byteArray = this.findByteArrayById(byteArrayId);
        MatcherAssert.assertThat((Object)byteArray.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.END_DATE, 5)));
        this.historyService.deleteHistoricBatch(batch.getId());
        FailingExecutionListener.shouldFail = false;
    }

    @Test
    public void shouldResolveBatchJobLogWithTimestampPreserved() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List jobs = this.managementService.createJobQuery().list();
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        List jobLogs = this.historyService.createHistoricJobLogQuery().list();
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLogs.get(0)).getTimestamp(), (Matcher)Is.is((Object)this.START_DATE));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLogs.get(1)).getTimestamp(), (Matcher)Is.is((Object)this.START_DATE));
        MatcherAssert.assertThat((Object)((HistoricJobLog)jobLogs.get(2)).getTimestamp(), (Matcher)Is.is((Object)this.START_DATE));
        this.historyService.deleteHistoricBatch(batch.getId());
    }

    @Test
    public void shouldResolveBatchIncident_SeedJob() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.managementService.setJobRetries(jobLog.getJobId(), 0);
        this.managementService.executeJob(jobLog.getJobId());
        List jobs = this.managementService.createJobQuery().list();
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.historyService.deleteHistoricBatch(batch.getId());
    }

    @Test
    public void shouldResolveBatchIncident_BatchJob() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.runtimeService.deleteProcessInstance(processInstanceId, "aDeleteReason");
        this.managementService.executeJob(jobLog.getJobId());
        String jobId = ((Job)this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.managementService.deleteJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).singleResult()).getId();
        this.managementService.executeJob(jobId);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.historyService.deleteHistoricBatch(batch.getId());
    }

    @Test
    public void shouldResolveBatchIncident_MonitorJob() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.managementService.executeJob(jobLog.getJobId());
        String jobId = ((Job)this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).singleResult()).getId();
        this.managementService.executeJob(jobId);
        jobId = ((Job)this.managementService.createJobQuery().jobDefinitionId(batch.getMonitorJobDefinitionId()).singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        this.managementService.executeJob(jobId);
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident.getRemovalTime(), (Matcher)Is.is((Object)this.addDays(this.START_DATE, 5)));
        this.historyService.deleteHistoricBatch(batch.getId());
    }

    @Test
    public void shouldNotUpdateCreateTimeForIncidentRelatedToBatch() {
        processEngineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        processEngineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.CALLED_PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("calledProcess").getId();
        ClockUtil.setCurrentTime((Date)this.START_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        HistoricJobLog jobLog = (HistoricJobLog)this.historyService.createHistoricJobLogQuery().singleResult();
        MatcherAssert.assertThat((Object)jobLog.getRemovalTime(), (Matcher)IsNull.nullValue());
        this.managementService.setJobRetries(jobLog.getJobId(), 0);
        this.managementService.executeJob(jobLog.getJobId());
        List jobs = this.managementService.createJobQuery().list();
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        HistoricIncident historicIncident = (HistoricIncident)this.historyService.createHistoricIncidentQuery().singleResult();
        MatcherAssert.assertThat((Object)historicIncident.getCreateTime(), (Matcher)Is.is((Object)this.START_DATE));
        this.historyService.deleteHistoricBatch(batch.getId());
    }
}

