/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.gateway;

import java.util.Date;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.junit.Assert;
import org.junit.Test;

public class ParallelGatewayTest
extends PluggableProcessEngineTest {
    @Deployment
    @Test
    public void testSplitMergeNoWaitstates() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("forkJoinNoWaitStates");
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    @Test
    public void testUnstructuredConcurrencyTwoForks() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("unstructuredConcurrencyTwoForks");
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    @Test
    public void testUnstructuredConcurrencyTwoJoins() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("unstructuredConcurrencyTwoJoins");
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    @Test
    public void testForkFollowedByOnlyEndEvents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("forkFollowedByEndEvents");
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    @Test
    public void testNestedForksFollowedByEndEvents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedForksFollowedByEndEvents");
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    @Test
    public void testNestedForkJoin() {
        String pid = this.runtimeService.startProcessInstanceByKey("nestedForkJoin").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        List tasks = query.list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Task 0", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((long)1L, (long)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        tasks = query.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"Task A", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Task B", (Object)((Task)tasks.get(1)).getName());
        Assert.assertEquals((long)2L, (long)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        tasks = query.list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Task B", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((long)2L, (long)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        tasks = query.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"Task B1", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Task B2", (Object)((Task)tasks.get(1)).getName());
        Assert.assertEquals((long)3L, (long)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = query.list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Task C", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((long)1L, (long)this.runtimeService.getActivityInstance(pid).getChildActivityInstances().length);
    }

    @Deployment
    @Test
    public void testReceyclingExecutionWithCallActivity() {
        this.runtimeService.startProcessInstanceByKey("parent-process").getId();
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().orderByTaskName().asc();
        List tasks = query.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"Another task", (Object)((Task)tasks.get(0)).getName());
        Assert.assertEquals((Object)"Some Task", (Object)((Task)tasks.get(1)).getName());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = query.list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Another task", (Object)((Task)tasks.get(0)).getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    @Test
    public void testCompletingJoin() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    @Test
    public void testAsyncParallelGateway() {
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)jobDefinition);
        Assert.assertEquals((Object)"parallelJoinEnd", (Object)jobDefinition.getActivityId());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertFalse((boolean)processInstance.isEnded());
        List list = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)2L, (long)list.size());
        this.managementService.executeJob(((Job)list.get(0)).getId());
        this.managementService.executeJob(((Job)list.get(1)).getId());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Deployment
    @Test
    public void testAsyncParallelGatewayAfterScopeTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertFalse((boolean)processInstance.isEnded());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        List list = this.managementService.createJobQuery().list();
        Assert.assertEquals((long)2L, (long)list.size());
        this.managementService.executeJob(((Job)list.get(0)).getId());
        this.managementService.executeJob(((Job)list.get(1)).getId());
        Assert.assertNull((Object)this.runtimeService.createProcessInstanceQuery().singleResult());
    }

    @Deployment
    @Test
    public void testCompletingJoinInSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertTrue((boolean)processInstance.isEnded());
    }

    @Deployment
    @Test
    public void testParallelGatewayBeforeAndInSubProcess() {
        ActivityInstance[] childActivityInstances;
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        Assertions.assertThat((List)tasks).hasSize(3);
        ActivityInstance instance = this.runtimeService.getActivityInstance(processInstance.getId());
        Assertions.assertThat((String)instance.getActivityName()).isEqualTo((Object)"Process1");
        for (ActivityInstance activityInstance : childActivityInstances = instance.getChildActivityInstances()) {
            if (activityInstance.getActivityId().equals("SubProcess_1")) {
                ActivityInstance[] instances;
                for (ActivityInstance activityInstance2 : instances = activityInstance.getChildActivityInstances()) {
                    Assertions.assertThat((String)activityInstance2.getActivityName()).isIn(new Object[]{"Inner User Task 1", "Inner User Task 2"});
                }
                continue;
            }
            Assertions.assertThat((String)activityInstance.getActivityName()).isEqualTo((Object)"Outer User Task");
        }
    }

    @Deployment
    @Test
    public void testForkJoin() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("forkJoin");
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = query.list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        Task task1 = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Receive Payment", (Object)task1.getName());
        Task task2 = (Task)tasks.get(1);
        Assert.assertEquals((Object)"Ship Order", (Object)task2.getName());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        tasks = query.list();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)"Archive Order", (Object)((Task)tasks.get(0)).getName());
    }

    @Deployment
    @Test
    public void testUnbalancedForkJoin() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("UnbalancedForkJoin");
        TaskQuery query = (TaskQuery)this.taskService.createTaskQuery().processInstanceId(pi.getId()).orderByTaskName().asc();
        List tasks = query.list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        Task task1 = (Task)tasks.get(0);
        Assert.assertEquals((Object)"Task 1", (Object)task1.getName());
        Task task2 = (Task)tasks.get(1);
        Assert.assertEquals((Object)"Task 2", (Object)task2.getName());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        tasks = query.list();
        Task task3 = (Task)tasks.get(0);
        Assert.assertEquals((long)2L, (long)tasks.size());
        Assert.assertEquals((Object)"Task 3", (Object)task3.getName());
        Task task4 = (Task)tasks.get(1);
        Assert.assertEquals((Object)"Task 4", (Object)task4.getName());
        this.taskService.complete(task3.getId());
        this.taskService.complete(task4.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }

    @Test
    public void testRemoveConcurrentExecutionLocalVariablesOnJoin() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"process").startEvent().parallelGateway("fork").userTask("task1").parallelGateway("join").userTask("afterTask").endEvent().moveToNode("fork").userTask("task2").connectTo("join").done());
        this.runtimeService.startProcessInstanceByKey("process");
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.runtimeService.setVariableLocal(task.getExecutionId(), "var", (Object)"value");
        }
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createVariableInstanceQuery().count());
    }

    @Deployment
    @Test
    public void testImplicitParallelGatewayAfterSignalBehavior() {
        Exception exceptionOccurred = null;
        this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("service").singleResult();
        try {
            this.runtimeService.signal(execution.getId());
        }
        catch (Exception e) {
            exceptionOccurred = e;
        }
        Assert.assertNull((Object)exceptionOccurred);
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
    }

    @Deployment
    @Test
    public void testExplicitParallelGatewayAfterSignalBehavior() {
        this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().activityId("service").singleResult();
        this.runtimeService.signal(execution.getId());
        Assert.assertEquals((long)3L, (long)this.taskService.createTaskQuery().count());
    }

    @Test
    @RequiredHistoryLevel(value="full")
    public void testParallelGatewayCancellationHistoryEvent() {
        this.testRule.deploy(((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"parallelProcess").startEvent().parallelGateway("Gateway_in").intermediateCatchEvent("Event_Wait").message("Message_1")).parallelGateway("Gateway_out").endEvent().moveToNode("Gateway_in").connectTo("Gateway_out").done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelProcess");
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("Event_Wait").cancelAllForActivity("Gateway_out").execute();
        Date currentTime = ClockUtil.now();
        Assertions.assertThat((Object)((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult())).isNull();
        Assertions.assertThat((Object)((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult())).isNotNull();
        HistoricActivityInstance historicActivityInstanceEventWait = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("Event_Wait").singleResult();
        Assertions.assertThat((Date)historicActivityInstanceEventWait.getEndTime()).isCloseTo(currentTime, 2000L);
        HistoricActivityInstance historicActivityInstanceMergingGateway = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("Gateway_out").singleResult();
        Assertions.assertThat((Date)historicActivityInstanceMergingGateway.getEndTime()).isCloseTo(currentTime, 2000L);
    }
}

