/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.parse;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.Problem;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.ResourceReport;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryConditionalEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.BoundaryEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.CompensationEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartConditionalEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.EventSubProcessStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.IntermediateConditionalEventBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.NoneStartEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.ThrowEscalationEventActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.helper.BpmnProperties;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.test.util.SystemPropertiesRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.camunda.commons.testing.WatchLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class BpmnParseTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public SystemPropertiesRule systemProperties = SystemPropertiesRule.resetPropsAfterTest();
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule();
    public RepositoryService repositoryService;
    public RuntimeService runtimeService;
    public ProcessEngineConfigurationImpl processEngineConfiguration;

    @Before
    public void setup() {
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setEnableXxeProcessing(false);
    }

    @After
    public void tearDown() {
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }

    @Test
    public void testInvalidSubProcessWithTimerStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSubProcessWithTimerStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a timer start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("timerEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_3");
        }
    }

    @Test
    public void testInvalidSubProcessWithMessageStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSubProcessWithMessageStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process definition could be parsed, although the sub process contains not a blanco start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("messageEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_3");
        }
    }

    @Test
    public void testInvalidSubProcessWithoutStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSubProcessWithoutStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process definition could be parsed, although the sub process did not contain a start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("subProcess must define a startEvent element", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "SubProcess_1");
        }
    }

    @Test
    public void testInvalidSubProcessWithConditionalStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSubProcessWithConditionalStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a conditional start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("The content of element 'bpmn2:conditionalEventDefinition' is not complete.", e.getMessage());
            this.testRule.assertTextPresent("conditionalEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((List)((Problem)errors.get(0)).getElementIds()).isEmpty();
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"StartEvent_2");
        }
    }

    @Test
    public void testInvalidSubProcessWithSignalStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSubProcessWithSignalStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a signal start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("signalEventDefintion only allowed on start event if subprocess is an event subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_3");
        }
    }

    @Test
    public void testInvalidSubProcessWithErrorStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSubProcessWithErrorStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a error start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("errorEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_3");
        }
    }

    @Test
    public void testInvalidSubProcessWithEscalationStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSubProcessWithEscalationStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a escalation start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("escalationEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_3");
        }
    }

    @Test
    public void testInvalidSubProcessWithCompensationStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSubProcessWithCompensationStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a compensation start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("compensateEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_3");
        }
    }

    @Test
    public void testInvalidTransactionWithMessageStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidTransactionWithMessageStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process definition could be parsed, although the sub process contains not a blanco start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("messageEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_2");
        }
    }

    @Test
    public void testInvalidTransactionWithTimerStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidTransactionWithTimerStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a timer start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("timerEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_2");
        }
    }

    @Test
    public void testInvalidTransactionWithConditionalStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidTransactionWithConditionalStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a conditional start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("The content of element 'bpmn2:conditionalEventDefinition' is not complete.", e.getMessage());
            this.testRule.assertTextPresent("conditionalEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((List)((Problem)errors.get(0)).getElementIds()).isEmpty();
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"StartEvent_3");
        }
    }

    @Test
    public void testInvalidTransactionWithSignalStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidTransactionWithSignalStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a signal start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("signalEventDefintion only allowed on start event if subprocess is an event subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_2");
        }
    }

    @Test
    public void testInvalidTransactionWithErrorStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidTransactionWithErrorStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a error start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("errorEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_2");
        }
    }

    @Test
    public void testInvalidTransactionWithEscalationStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidTransactionWithEscalationStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a escalation start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("escalationEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_2");
        }
    }

    @Test
    public void testInvalidTransactionWithCompensationStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidTransactionWithCompensationStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process contains a compensation start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("compensateEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_2");
        }
    }

    @Test
    public void testInvalidProcessDefinition() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidProcessDefinition");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail();
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("cvc-complex-type.3.2.2:", e.getMessage());
            this.testRule.assertTextPresent("invalidAttribute", e.getMessage());
            this.testRule.assertTextPresent("process", e.getMessage());
            Assertions.assertThat((List)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getElementIds()).isEmpty();
        }
    }

    @Test
    public void testExpressionParsingErrors() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testExpressionParsingErrors");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could not be parsed, the expression contains an escalation start event.");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("Error parsing '${currentUser()': syntax error at position 15, encountered 'null', expected '}'", e.getMessage());
        }
    }

    @Test
    public void testXmlParsingErrors() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testXMLParsingErrors");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could not be parsed, the XML contains an escalation start event.");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("The end-tag for element type \"bpmndi:BPMNLabel\" must end with a '>' delimiter", e.getMessage());
        }
    }

    @Test
    public void testInvalidSequenceFlowInAndOutEventSubProcess() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidSequenceFlowInAndOutEventSubProcess");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, although the sub process has incoming and outgoing sequence flows");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("start event of event subprocess must be of type 'error', 'message', 'timer', 'signal', 'compensation' or 'escalation'", e.getMessage());
            this.testRule.assertTextPresent("Invalid incoming sequence flow of event subprocess", e.getMessage());
            this.testRule.assertTextPresent("Invalid outgoing sequence flow of event subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(3);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"StartEvent_2");
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"SequenceFlow_2");
            Assertions.assertThat((String)((Problem)errors.get(2)).getMainElementId()).isEqualTo((Object)"SequenceFlow_1");
        }
    }

    @Test
    public void testInvalidProcessWithoutStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidProcessWithoutStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process definition could be parsed, although the process did not contain a start event.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("process must define a startEvent element", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "Process_1");
        }
    }

    @Test
    public void testParseMultipleStartEvent() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseMultipleStartEvent");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail();
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("timerEventDefinition is not allowed on start event within a subprocess", e.getMessage());
            this.testRule.assertTextPresent("messageEventDefinition only allowed on start event if subprocess is an event subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"startSubProcess");
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"startSubProcess");
        }
    }

    @Test
    public void testParseWithBpmnNamespacePrefix() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseWithBpmnNamespacePrefix.bpmn20.xml").deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Test
    public void testParseWithMultipleDocumentation() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseWithMultipleDocumentation.bpmn20.xml").deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Test
    public void testParseCollaborationPlane() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseCollaborationPlane.bpmn").deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Test
    public void testInvalidAsyncAfterEventBasedGateway() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidAsyncAfterEventBasedGateway");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail();
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("'asyncAfter' not supported for", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "eventBasedGateway");
        }
    }

    @Deployment
    @Test
    public void testParseDiagramInterchangeElements() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandExecutor.execute((Command)new Command<ProcessDefinitionEntity>(){

            public ProcessDefinitionEntity execute(CommandContext commandContext) {
                return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedLatestProcessDefinitionByKey("myProcess");
            }
        });
        Assert.assertNotNull((Object)processDefinitionEntity);
        Assert.assertEquals((long)7L, (long)processDefinitionEntity.getActivities().size());
        List resourceNames = this.repositoryService.getDeploymentResourceNames(processDefinitionEntity.getDeploymentId());
        if (this.processEngineConfiguration.isCreateDiagramOnDeploy()) {
            Assert.assertEquals((long)2L, (long)resourceNames.size());
        } else {
            Assert.assertEquals((long)1L, (long)resourceNames.size());
        }
        for (ActivityImpl activity : processDefinitionEntity.getActivities()) {
            if (activity.getId().equals("theStart")) {
                this.assertActivityBounds(activity, 70, 255, 30, 30);
            } else if (activity.getId().equals("task1")) {
                this.assertActivityBounds(activity, 176, 230, 100, 80);
            } else if (activity.getId().equals("gateway1")) {
                this.assertActivityBounds(activity, 340, 250, 40, 40);
            } else if (activity.getId().equals("task2")) {
                this.assertActivityBounds(activity, 445, 138, 100, 80);
            } else if (activity.getId().equals("gateway2")) {
                this.assertActivityBounds(activity, 620, 250, 40, 40);
            } else if (activity.getId().equals("task3")) {
                this.assertActivityBounds(activity, 453, 304, 100, 80);
            } else if (activity.getId().equals("theEnd")) {
                this.assertActivityBounds(activity, 713, 256, 28, 28);
            }
            for (PvmTransition sequenceFlow : activity.getOutgoingTransitions()) {
                Assert.assertTrue((((TransitionImpl)sequenceFlow).getWaypoints().size() >= 4 ? 1 : 0) != 0);
                TransitionImpl transitionImpl = (TransitionImpl)sequenceFlow;
                if (transitionImpl.getId().equals("flowStartToTask1")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 100, 270, 176, 270);
                    continue;
                }
                if (transitionImpl.getId().equals("flowTask1ToGateway1")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 276, 270, 340, 270);
                    continue;
                }
                if (transitionImpl.getId().equals("flowGateway1ToTask2")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 360, 250, 360, 178, 445, 178);
                    continue;
                }
                if (transitionImpl.getId().equals("flowGateway1ToTask3")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 360, 290, 360, 344, 453, 344);
                    continue;
                }
                if (transitionImpl.getId().equals("flowTask2ToGateway2")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 545, 178, 640, 178, 640, 250);
                    continue;
                }
                if (transitionImpl.getId().equals("flowTask3ToGateway2")) {
                    this.assertSequenceFlowWayPoints(transitionImpl, 553, 344, 640, 344, 640, 290);
                    continue;
                }
                if (!transitionImpl.getId().equals("flowGateway2ToEnd")) continue;
                this.assertSequenceFlowWayPoints(transitionImpl, 660, 270, 713, 270);
            }
        }
    }

    @Deployment
    @Test
    public void testParseNamespaceInConditionExpressionType() {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)commandExecutor.execute((Command)new Command<ProcessDefinitionEntity>(){

            public ProcessDefinitionEntity execute(CommandContext commandContext) {
                return Context.getProcessEngineConfiguration().getDeploymentCache().findDeployedLatestProcessDefinitionByKey("resolvableNamespacesProcess");
            }
        });
        Assert.assertNotNull((Object)processDefinitionEntity);
        ActivityImpl activity = processDefinitionEntity.findActivity("ExclusiveGateway_1");
        Assert.assertNotNull((Object)activity);
        for (PvmTransition transition : activity.getOutgoingTransitions()) {
            if (transition.getDestination().getId().equals("Task_2")) {
                Assert.assertTrue((boolean)transition.getProperty("conditionText").equals("#{approved}"));
                continue;
            }
            if (transition.getDestination().getId().equals("Task_3")) {
                Assert.assertTrue((boolean)transition.getProperty("conditionText").equals("#{!approved}"));
                continue;
            }
            Assert.fail((String)"Something went wrong");
        }
    }

    @Deployment
    @Test
    public void testParseDiagramInterchangeElementsForUnknownModelElements() {
    }

    @Test
    @Deployment
    public void testParseDefinitionWithDeprecatedActivitiNamespace() {
    }

    @Test
    @Deployment
    public void testParseDefinitionWithCamundaNamespace() {
    }

    @Deployment
    @Test
    public void testParseCompensationEndEvent() {
        ActivityImpl endEvent = this.findActivityInDeployedProcessDefinition("end");
        Assert.assertEquals((Object)"compensationEndEvent", (Object)endEvent.getProperty("type"));
        Assert.assertEquals((Object)Boolean.TRUE, (Object)endEvent.getProperty("throwsCompensation"));
        Assert.assertEquals(CompensationEventActivityBehavior.class, endEvent.getActivityBehavior().getClass());
    }

    @Deployment
    @Test
    public void testParseCompensationStartEvent() {
        ActivityImpl compensationStartEvent = this.findActivityInDeployedProcessDefinition("compensationStartEvent");
        Assert.assertEquals((Object)"compensationStartEvent", (Object)compensationStartEvent.getProperty("type"));
        Assert.assertEquals(EventSubProcessStartEventActivityBehavior.class, compensationStartEvent.getActivityBehavior().getClass());
        ActivityImpl compensationEventSubProcess = (ActivityImpl)compensationStartEvent.getFlowScope();
        Assert.assertEquals((Object)Boolean.TRUE, (Object)compensationEventSubProcess.getProperty("isForCompensation"));
        ScopeImpl subprocess = compensationEventSubProcess.getFlowScope();
        Assert.assertEquals((Object)compensationEventSubProcess.getActivityId(), (Object)subprocess.getProperty("compensationHandler"));
    }

    @Deployment
    @Test
    public void testParseAsyncMultiInstanceBody() {
        ActivityImpl innerTask = this.findActivityInDeployedProcessDefinition("miTask");
        ActivityImpl miBody = innerTask.getParentFlowScopeActivity();
        Assert.assertTrue((boolean)miBody.isAsyncBefore());
        Assert.assertTrue((boolean)miBody.isAsyncAfter());
        Assert.assertFalse((boolean)innerTask.isAsyncBefore());
        Assert.assertFalse((boolean)innerTask.isAsyncAfter());
    }

    @Deployment
    @Test
    public void testParseAsyncActivityWrappedInMultiInstanceBody() {
        ActivityImpl innerTask = this.findActivityInDeployedProcessDefinition("miTask");
        Assert.assertTrue((boolean)innerTask.isAsyncBefore());
        Assert.assertTrue((boolean)innerTask.isAsyncAfter());
        ActivityImpl miBody = innerTask.getParentFlowScopeActivity();
        Assert.assertFalse((boolean)miBody.isAsyncBefore());
        Assert.assertFalse((boolean)miBody.isAsyncAfter());
    }

    @Deployment
    @Test
    public void testParseAsyncActivityWrappedInMultiInstanceBodyWithAsyncMultiInstance() {
        ActivityImpl innerTask = this.findActivityInDeployedProcessDefinition("miTask");
        Assert.assertEquals((Object)true, (Object)innerTask.isAsyncBefore());
        Assert.assertEquals((Object)false, (Object)innerTask.isAsyncAfter());
        ActivityImpl miBody = innerTask.getParentFlowScopeActivity();
        Assert.assertEquals((Object)false, (Object)miBody.isAsyncBefore());
        Assert.assertEquals((Object)true, (Object)miBody.isAsyncAfter());
    }

    @Test
    public void testParseSwitchedSourceAndTargetRefsForAssociations() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseSwitchedSourceAndTargetRefsForAssociations.bpmn20.xml").deploy();
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.compensationMiActivity.bpmn20.xml"})
    @Test
    public void testParseCompensationHandlerOfMiActivity() {
        ActivityImpl miActivity = this.findActivityInDeployedProcessDefinition("undoBookHotel");
        ScopeImpl flowScope = miActivity.getFlowScope();
        Assert.assertEquals((Object)"multiInstanceBody", (Object)flowScope.getProperty(BpmnParse.PROPERTYNAME_TYPE));
        Assert.assertEquals((Object)"bookHotel#multiInstanceBody", (Object)((ActivityImpl)flowScope).getActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/compensate/CompensateEventTest.compensationMiSubprocess.bpmn20.xml"})
    @Test
    public void testParseCompensationHandlerOfMiSubprocess() {
        ActivityImpl miActivity = this.findActivityInDeployedProcessDefinition("undoBookHotel");
        ScopeImpl flowScope = miActivity.getFlowScope();
        Assert.assertEquals((Object)"multiInstanceBody", (Object)flowScope.getProperty(BpmnParse.PROPERTYNAME_TYPE));
        Assert.assertEquals((Object)"scope#multiInstanceBody", (Object)((ActivityImpl)flowScope).getActivityId());
    }

    @Deployment
    @Test
    public void testParseSignalStartEvent() {
        ActivityImpl signalStartActivity = this.findActivityInDeployedProcessDefinition("start");
        Assert.assertEquals((Object)"signalStartEvent", (Object)signalStartActivity.getProperty("type"));
        Assert.assertEquals(NoneStartEventActivityBehavior.class, signalStartActivity.getActivityBehavior().getClass());
    }

    @Deployment
    @Test
    public void testParseEscalationBoundaryEvent() {
        ActivityImpl escalationBoundaryEvent = this.findActivityInDeployedProcessDefinition("escalationBoundaryEvent");
        Assert.assertEquals((Object)"boundaryEscalation", (Object)escalationBoundaryEvent.getProperties().get(BpmnProperties.TYPE));
        Assert.assertEquals(BoundaryEventActivityBehavior.class, escalationBoundaryEvent.getActivityBehavior().getClass());
    }

    @Deployment
    @Test
    public void testParseEscalationIntermediateThrowingEvent() {
        ActivityImpl escalationThrowingEvent = this.findActivityInDeployedProcessDefinition("escalationThrowingEvent");
        Assert.assertEquals((Object)"intermediateEscalationThrowEvent", (Object)escalationThrowingEvent.getProperties().get(BpmnProperties.TYPE));
        Assert.assertEquals(ThrowEscalationEventActivityBehavior.class, escalationThrowingEvent.getActivityBehavior().getClass());
    }

    @Deployment
    @Test
    public void testParseEscalationEndEvent() {
        ActivityImpl escalationEndEvent = this.findActivityInDeployedProcessDefinition("escalationEndEvent");
        Assert.assertEquals((Object)"escalationEndEvent", (Object)escalationEndEvent.getProperties().get(BpmnProperties.TYPE));
        Assert.assertEquals(ThrowEscalationEventActivityBehavior.class, escalationEndEvent.getActivityBehavior().getClass());
    }

    @Deployment
    @Test
    public void testParseEscalationStartEvent() {
        ActivityImpl escalationStartEvent = this.findActivityInDeployedProcessDefinition("escalationStartEvent");
        Assert.assertEquals((Object)"escalationStartEvent", (Object)escalationStartEvent.getProperties().get(BpmnProperties.TYPE));
        Assert.assertEquals(EventSubProcessStartEventActivityBehavior.class, escalationStartEvent.getActivityBehavior().getClass());
    }

    public void parseInvalidConditionalEvent(String processDefinitionResource, String elementId) {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)processDefinitionResource);
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, conditional event definition contains no condition.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("The content of element 'bpmn:conditionalEventDefinition' is not complete.", e.getMessage());
            this.testRule.assertTextPresent("Conditional event must contain an expression for evaluation.", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((List)((Problem)errors.get(0)).getElementIds()).isEmpty();
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)elementId);
        }
    }

    @Test
    public void testParseInvalidConditionalBoundaryEvent() {
        this.parseInvalidConditionalEvent("testParseInvalidConditionalBoundaryEvent", "conditionalBoundaryEvent");
    }

    @Deployment
    @Test
    public void testParseConditionalBoundaryEvent() {
        ActivityImpl conditionalBoundaryEvent = this.findActivityInDeployedProcessDefinition("conditionalBoundaryEvent");
        Assert.assertEquals((Object)"boundaryConditional", (Object)conditionalBoundaryEvent.getProperties().get(BpmnProperties.TYPE));
        Assert.assertEquals(BoundaryConditionalEventActivityBehavior.class, conditionalBoundaryEvent.getActivityBehavior().getClass());
    }

    @Deployment
    @Test
    public void testParseAsyncBoundaryEvent() {
        ActivityImpl conditionalBoundaryEvent1 = this.findActivityInDeployedProcessDefinition("conditionalBoundaryEvent1");
        ActivityImpl conditionalBoundaryEvent2 = this.findActivityInDeployedProcessDefinition("conditionalBoundaryEvent2");
        Assert.assertTrue((boolean)conditionalBoundaryEvent1.isAsyncAfter());
        Assert.assertTrue((boolean)conditionalBoundaryEvent1.isAsyncBefore());
        Assert.assertFalse((boolean)conditionalBoundaryEvent2.isAsyncAfter());
        Assert.assertFalse((boolean)conditionalBoundaryEvent2.isAsyncBefore());
    }

    @Test
    public void testParseInvalidIntermediateConditionalEvent() {
        this.parseInvalidConditionalEvent("testParseInvalidIntermediateConditionalEvent", "intermediateConditionalEvent");
    }

    @Deployment
    @Test
    public void testParseIntermediateConditionalEvent() {
        ActivityImpl intermediateConditionalEvent = this.findActivityInDeployedProcessDefinition("intermediateConditionalEvent");
        Assert.assertEquals((Object)"intermediateConditional", (Object)intermediateConditionalEvent.getProperties().get(BpmnProperties.TYPE));
        Assert.assertEquals(IntermediateConditionalEventBehavior.class, intermediateConditionalEvent.getActivityBehavior().getClass());
    }

    @Test
    public void testParseInvalidEventSubprocessConditionalStartEvent() {
        this.parseInvalidConditionalEvent("testParseInvalidEventSubprocessConditionalStartEvent", "conditionalStartEventSubProcess");
    }

    @Deployment
    @Test
    public void testParseEventSubprocessConditionalStartEvent() {
        ActivityImpl conditionalStartEventSubProcess = this.findActivityInDeployedProcessDefinition("conditionalStartEventSubProcess");
        Assert.assertEquals((Object)"conditionalStartEvent", (Object)conditionalStartEventSubProcess.getProperties().get(BpmnProperties.TYPE));
        Assert.assertEquals(EventSubProcessStartConditionalEventActivityBehavior.class, conditionalStartEventSubProcess.getActivityBehavior().getClass());
    }

    protected void assertActivityBounds(ActivityImpl activity, int x, int y, int width, int height) {
        Assert.assertEquals((long)x, (long)activity.getX());
        Assert.assertEquals((long)y, (long)activity.getY());
        Assert.assertEquals((long)width, (long)activity.getWidth());
        Assert.assertEquals((long)height, (long)activity.getHeight());
    }

    protected void assertSequenceFlowWayPoints(TransitionImpl sequenceFlow, Integer ... waypoints) {
        Assert.assertEquals((long)waypoints.length, (long)sequenceFlow.getWaypoints().size());
        for (int i = 0; i < waypoints.length; ++i) {
            Assert.assertEquals((Object)waypoints[i], sequenceFlow.getWaypoints().get(i));
        }
    }

    protected ActivityImpl findActivityInDeployedProcessDefinition(String activityId) {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        Assert.assertNotNull((Object)processDefinition);
        ProcessDefinitionEntity cachedProcessDefinition = (ProcessDefinitionEntity)this.processEngineConfiguration.getDeploymentCache().getProcessDefinitionCache().get((Object)processDefinition.getId());
        return cachedProcessDefinition.findActivity(activityId);
    }

    @Test
    public void testNoCamundaInSourceThrowsError() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testNoCamundaInSourceThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:in extension element should contain source!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Missing parameter 'source' or 'sourceExpression' when passing variables", e.getMessage());
            this.testRule.assertTextPresent("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"callActivity");
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"callActivity");
        }
    }

    @Test
    public void testNoCamundaInSourceShouldWithoutValidation() {
        try {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(true);
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testNoCamundaInSourceThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
        }
        finally {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(false);
        }
    }

    @Test
    public void testEmptyCamundaInSourceThrowsError() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testEmptyCamundaInSourceThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:in extension element should contain source!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Empty attribute 'source' when passing variables", e.getMessage());
            this.testRule.assertTextPresent("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"callActivity");
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"callActivity");
        }
    }

    @Test
    public void testEmptyCamundaInSourceWithoutValidation() {
        try {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(true);
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testEmptyCamundaInSourceThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
        }
        finally {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(false);
        }
    }

    @Test
    public void testNoCamundaInTargetThrowsError() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testNoCamundaInTargetThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:in extension element should contain target!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "callActivity");
        }
    }

    @Test
    public void testNoCamundaInTargetWithoutValidation() {
        try {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(true);
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testNoCamundaInTargetThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:in extension element should contain target!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "callActivity");
        }
        finally {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(false);
        }
    }

    @Test
    public void testEmptyCamundaInTargetThrowsError() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testEmptyCamundaInTargetThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:in extension element should contain target!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Empty attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "callActivity");
        }
    }

    @Test
    public void testEmptyCamundaInTargetWithoutValidation() {
        try {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(true);
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testEmptyCamundaInTargetThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
        }
        finally {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(false);
        }
    }

    @Test
    public void testNoCamundaOutSourceThrowsError() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testNoCamundaOutSourceThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:out extension element should contain source!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Missing parameter 'source' or 'sourceExpression' when passing variables", e.getMessage());
            this.testRule.assertTextPresent("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"callActivity");
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"callActivity");
        }
    }

    @Test
    public void testNoCamundaOutSourceWithoutValidation() {
        try {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(true);
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testNoCamundaOutSourceThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
        }
        finally {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(false);
        }
    }

    @Test
    public void testEmptyCamundaOutSourceThrowsError() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testEmptyCamundaOutSourceThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:out extension element should contain source!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Empty attribute 'source' when passing variables", e.getMessage());
            this.testRule.assertTextPresent("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"callActivity");
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"callActivity");
        }
    }

    @Test
    public void testEmptyCamundaOutSourceWithoutValidation() {
        try {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(true);
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testEmptyCamundaOutSourceThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
        }
        finally {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(false);
        }
    }

    @Test
    public void testNoCamundaOutTargetThrowsError() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testNoCamundaOutTargetThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:out extension element should contain target!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "callActivity");
        }
    }

    @Test
    public void testNoCamundaOutTargetWithoutValidation() {
        try {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(true);
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testNoCamundaOutTargetThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:out extension element should contain target!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Missing attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "callActivity");
        }
        finally {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(false);
        }
    }

    @Test
    public void testEmptyCamundaOutTargetThrowsError() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testEmptyCamundaOutTargetThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Process camunda:out extension element should contain target!");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Empty attribute 'target' when attribute 'source' or 'sourceExpression' is set", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "callActivity");
        }
    }

    @Test
    public void testEmptyCamundaOutTargetWithoutValidation() {
        try {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(true);
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testEmptyCamundaOutTargetThrowsError");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
        }
        finally {
            this.processEngineConfiguration.setDisableStrictCallActivityValidation(false);
        }
    }

    @Deployment
    @Test
    public void testParseProcessDefinitionTtl() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        Integer timeToLive = ((ProcessDefinition)processDefinitions.get(0)).getHistoryTimeToLive();
        Assert.assertNotNull((Object)timeToLive);
        Assert.assertEquals((long)5L, (long)timeToLive.intValue());
        Assert.assertTrue((boolean)((ProcessDefinition)processDefinitions.get(0)).isStartableInTasklist());
    }

    @Deployment
    @Test
    public void testParseProcessDefinitionStringTtl() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        Integer timeToLive = ((ProcessDefinition)processDefinitions.get(0)).getHistoryTimeToLive();
        Assert.assertNotNull((Object)timeToLive);
        Assert.assertEquals((long)5L, (long)timeToLive.intValue());
    }

    @Test
    public void testParseProcessDefinitionMalformedStringTtl() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionMalformedStringTtl");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition historyTimeToLive value can not be parsed.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Cannot parse historyTimeToLive", e.getMessage());
            this.assertErrors(((ResourceReport)e.getResorceReports().get(0)).getErrors(), "oneTaskProcess");
        }
    }

    @Deployment
    @Test
    public void testParseProcessDefinitionEmptyTtl() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        Integer timeToLive = ((ProcessDefinition)processDefinitions.get(0)).getHistoryTimeToLive();
        Assert.assertNull((Object)timeToLive);
    }

    @Deployment
    @Test
    public void testParseProcessDefinitionWithoutTtl() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        Integer timeToLive = ((ProcessDefinition)processDefinitions.get(0)).getHistoryTimeToLive();
        Assert.assertNull((Object)timeToLive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseProcessDefinitionWithoutTtlWithConfigDefault() {
        this.processEngineConfiguration.setHistoryTimeToLive("6");
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionWithoutTtl");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
            Assert.assertNotNull((Object)processDefinitions);
            Assert.assertEquals((long)1L, (long)processDefinitions.size());
            Integer timeToLive = ((ProcessDefinition)processDefinitions.get(0)).getHistoryTimeToLive();
            Assert.assertNotNull((Object)timeToLive);
            Assert.assertEquals((long)6L, (long)timeToLive.intValue());
        }
        finally {
            this.processEngineConfiguration.setHistoryTimeToLive(null);
        }
    }

    @Test
    public void testParseProcessDefinitionWithoutTtlWithMalformedConfigDefault() {
        this.processEngineConfiguration.setHistoryTimeToLive("PP555DDD");
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionWithoutTtl");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition historyTimeToLive value can not be parsed.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Cannot parse historyTimeToLive", e.getMessage());
        }
        finally {
            this.processEngineConfiguration.setHistoryTimeToLive(null);
        }
    }

    @Test
    public void testParseProcessDefinitionWithoutTtlWithInvalidConfigDefault() {
        this.processEngineConfiguration.setHistoryTimeToLive("invalidValue");
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionWithoutTtl");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition historyTimeToLive value can not be parsed.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Cannot parse historyTimeToLive", e.getMessage());
        }
        finally {
            this.processEngineConfiguration.setHistoryTimeToLive(null);
        }
    }

    @Test
    public void testParseProcessDefinitionWithoutTtlWithNegativeConfigDefault() {
        this.processEngineConfiguration.setHistoryTimeToLive("-6");
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionWithoutTtl");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition historyTimeToLive value can not be parsed.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Cannot parse historyTimeToLive", e.getMessage());
        }
        finally {
            this.processEngineConfiguration.setHistoryTimeToLive(null);
        }
    }

    @Test
    public void testParseProcessDefinitionInvalidTtl() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionInvalidTtl");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition historyTimeToLive value can not be parsed.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Cannot parse historyTimeToLive", e.getMessage());
        }
    }

    @Test
    public void testParseProcessDefinitionNegativTtl() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionNegativeTtl");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition historyTimeToLive value can not be parsed.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Cannot parse historyTimeToLive", e.getMessage());
        }
    }

    @Deployment
    @Test
    public void testParseProcessDefinitionStartable() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        Assert.assertNotNull((Object)processDefinitions);
        Assert.assertEquals((long)1L, (long)processDefinitions.size());
        Assert.assertFalse((boolean)((ProcessDefinition)processDefinitions.get(0)).isStartableInTasklist());
    }

    @Test
    public void testInvalidExecutionListenerClassDefinition() {
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidExecutionListenerClassDefinition");
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().name(resource).addClasspathResource(resource);
        try {
            deploymentBuilder.deploy();
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Attribute 'class' cannot be empty", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"Task_1v32izq");
        }
    }

    @Test
    public void testInvalidExecutionListenerDelegateDefinition() {
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testInvalidExecutionListenerDelegateDefinition");
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().name(resource).addClasspathResource(resource);
        try {
            deploymentBuilder.deploy();
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Attribute 'delegateExpression' cannot be empty", e.getMessage());
            Assertions.assertThat((String)((Problem)((ResourceReport)e.getResorceReports().get(0)).getErrors().get(0)).getMainElementId()).isEqualTo((Object)"Task_1v32izq");
        }
    }

    @Test
    public void shouldPreventXxeProcessing() {
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionXXE");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("DOCTYPE is disallowed when the feature \"http://apache.org/xml/features/disallow-doctype-decl\" set to true.");
    }

    @Test
    public void shouldAllowXxeProcessing() {
        this.processEngineConfiguration.setEnableXxeProcessing(true);
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionXXE");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Could not parse").hasMessageContaining("file.txt");
    }

    @Test
    public void testFeatureSecureProcessingRejectsDefinitionDueToAttributeLimit() {
        Assume.assumeThat((Object)System.getProperty("java.vm.vendor"), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"IBM")));
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionFSP");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Attribute Number Limit should have been exceeded while parsing the model!");
        }
        catch (ProcessEngineException e) {
            this.testRule.assertTextPresent("JAXP00010002", e.getMessage());
        }
    }

    @Test
    public void testFeatureSecureProcessingAcceptsDefinitionWhenAttributeLimitOverridden() {
        System.setProperty("jdk.xml.elementAttributeLimit", "0");
        String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testParseProcessDefinitionFSP");
        DeploymentBuilder deploymentBuilder = this.repositoryService.createDeployment().name(resource).addClasspathResource(resource);
        this.testRule.deploy(deploymentBuilder);
        Assert.assertEquals((long)1L, (long)this.repositoryService.createProcessDefinitionQuery().count());
    }

    @Test
    public void testFeatureSecureProcessingRestrictExternalSchemaAccess() {
        Assume.assumeTrue((boolean)this.doesJdkSupportExternalSchemaAccessProperty());
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        DeploymentBuilder builder = this.repositoryService.createDeployment().addModelInstance("process.bpmn", process);
        System.setProperty("javax.xml.accessExternalSchema", "");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(builder)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Could not parse 'process.bpmn'");
    }

    @Test
    public void testFeatureSecureProcessingAllowExternalSchemaAccess() {
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
        System.setProperty("javax.xml.accessExternalSchema", "all");
        DeploymentWithDefinitions deployment = this.testRule.deploy(process);
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void testTimerWithoutFullDefinition() {
        try {
            String timerWithoutDetails = "<?xml version='1.0' encoding='UTF-8'?><definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'  xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL'  xmlns:camunda='http://camunda.org/schema/1.0/bpmn'  targetNamespace='Examples'>  <process id='process' isExecutable='true'>    <startEvent id='start'>      <timerEventDefinition id='TimerEventDefinition_1'/>    </startEvent>  </process></definitions>";
            this.repositoryService.createDeployment().addString("process.bpmn20.xml", timerWithoutDetails).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, it contains uncomplete timer event definition.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Timer needs configuration (either timeDate, timeCycle or timeDuration is needed).", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(1);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"start");
        }
    }

    @Test
    public void testSequenceFlowNoIdAndUnexistantDestination() {
        try {
            String incorrectSequenceFlow = "<?xml version='1.0' encoding='UTF-8'?><definitions xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'  xmlns='http://www.omg.org/spec/BPMN/20100524/MODEL'  xmlns:camunda='http://camunda.org/schema/1.0/bpmn'  targetNamespace='Examples'>  <process id='process' isExecutable='true'>    <startEvent id='start'/>    <sequenceFlow sourceRef='start' targetRef='eventBasedGateway' />  </process></definitions>";
            this.repositoryService.createDeployment().addString("process.bpmn20.xml", incorrectSequenceFlow).deploy();
            Assert.fail((String)"Exception expected: Unexisting target.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("Invalid destination 'eventBasedGateway' of sequence flow 'null'", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(2);
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isNull();
            Assertions.assertThat((List)((Problem)errors.get(1)).getElementIds()).isEmpty();
        }
    }

    @Test
    public void testMultipleTimerStartEvents() {
        try {
            String resource = TestHelper.getBpmnProcessDefinitionResource(this.getClass(), (String)"testMultipleTimerStartEvents");
            this.repositoryService.createDeployment().name(resource).addClasspathResource(resource).deploy();
            Assert.fail((String)"Exception expected: Process definition could be parsed, it contains multiple multiple none start events or timer start events.");
        }
        catch (ParseException e) {
            this.testRule.assertTextPresent("multiple none start events or timer start events not supported on process definition", e.getMessage());
            this.testRule.assertTextPresent("multiple start events not supported for subprocess", e.getMessage());
            List errors = ((ResourceReport)e.getResorceReports().get(0)).getErrors();
            Assertions.assertThat((List)errors).hasSize(4);
            Assertions.assertThat((String)((Problem)errors.get(0)).getMainElementId()).isEqualTo((Object)"timerStart2");
            Assertions.assertThat((String)((Problem)errors.get(1)).getMainElementId()).isEqualTo((Object)"plainStart1");
            Assertions.assertThat((String)((Problem)errors.get(2)).getMainElementId()).isEqualTo((Object)"plainStart2");
            Assertions.assertThat((String)((Problem)errors.get(3)).getMainElementId()).isEqualTo((Object)"plainStartInSub1");
        }
    }

    @Test
    @WatchLogger(loggerNames={"org.camunda.bpm.engine.bpmn.parser"}, level="INFO")
    public void testIntermediateCatchTimerEventWithTimeCycleNotRecommendedInfoMessage() {
        BpmnModelInstance process = ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().intermediateCatchEvent("timerintermediatecatchevent1").timerWithCycle("0 0/5 * * * ?")).endEvent().done();
        this.testRule.deploy(process);
        String logMessage = "definitionKey: process; It is not recommended to use an intermediate catch timer event with a time cycle, element with id 'timerintermediatecatchevent1'.";
        Assertions.assertThat((List)this.loggingRule.getFilteredLog(logMessage)).hasSize(1);
    }

    @Test
    public void testParseEmptyExtensionProperty() {
        this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/parse/BpmnParseTest.testParseEmptyExtensionProperty.bpmn").deploy();
        Assertions.assertThat((long)this.repositoryService.createProcessDefinitionQuery().count()).isEqualTo(1L);
    }

    protected boolean doesJdkSupportExternalSchemaAccessProperty() {
        String jvmVendor = System.getProperty("java.vm.vendor");
        String javaVersion = System.getProperty("java.version");
        boolean isIbmJDK = jvmVendor != null && jvmVendor.contains("IBM");
        boolean isJava6 = javaVersion != null && javaVersion.startsWith("1.6");
        boolean isJava7 = javaVersion != null && javaVersion.startsWith("1.7");
        return !isJava6 && (!isIbmJDK || !isJava7);
    }

    protected void assertErrors(List<Problem> errors, String elementId) {
        Assertions.assertThat(errors).hasSize(1);
        Assertions.assertThat((String)errors.get(0).getMainElementId()).isEqualTo((Object)elementId);
    }
}

