/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.groups.Tuple;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.history.event.HistoricVariableUpdateEventEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.models.AsyncProcessModels;
import org.camunda.bpm.engine.test.bpmn.async.AsyncListener;
import org.camunda.bpm.engine.test.cmmn.decisiontask.TestPojo;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoricDetailQueryTest {
    protected static final String PROCESS_KEY = "oneTaskProcess";
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected IdentityService identityService;
    protected CaseService caseService;

    @Before
    public void initServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.identityService = this.engineRule.getIdentityService();
        this.caseService = this.engineRule.getCaseService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByUserOperationId() {
        this.startProcessInstance(PROCESS_KEY);
        this.identityService.setAuthenticatedUserId("demo");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        String userOperationId = ((HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult()).getUserOperationId();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().userOperationId(userOperationId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByUserOperationIdAndVariableUpdates() {
        this.startProcessInstance(PROCESS_KEY);
        this.identityService.setAuthenticatedUserId("demo");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        String userOperationId = ((HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult()).getUserOperationId();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().userOperationId(userOperationId).variableUpdates();
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidUserOperationId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().userOperationId("invalid");
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.userOperationId(null);
            Assert.fail((String)"It was possible to set a null value as userOperationId.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        String executionId = ((HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult()).getExecutionId();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().executionId(executionId);
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidExecutionId() {
        this.startProcessInstance(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().executionId("invalid");
        Assert.assertEquals((long)0L, (long)query.list().size());
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByExecutionIdAndProcessInstanceId() {
        this.startProcessInstance(PROCESS_KEY);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String processInstanceId = task.getProcessInstanceId();
        String executionId = task.getExecutionId();
        String taskId = task.getId();
        this.taskService.resolveTask(taskId, (Map)this.getVariables());
        HistoricDetail detail = (HistoricDetail)this.historyService.createHistoricDetailQuery().processInstanceId(processInstanceId).executionId(executionId).singleResult();
        Assertions.assertThat((String)detail.getProcessInstanceId()).isEqualTo((Object)processInstanceId);
        Assertions.assertThat((String)detail.getExecutionId()).isEqualTo((Object)executionId);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeIn() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableTypeIn(new String[]{"string"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricDetail historicDetail = (HistoricDetail)query.list().get(0);
        if (historicDetail instanceof HistoricVariableUpdate) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)historicDetail;
            Assert.assertEquals((Object)variableUpdate.getVariableName(), (Object)"stringVar");
            Assert.assertEquals((Object)variableUpdate.getTypeName(), (Object)"string");
        } else {
            Assert.fail((String)"Historic detail should be a variable update!");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeInWithCapitalLetter() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableTypeIn(new String[]{"Boolean"});
        Assert.assertEquals((long)1L, (long)query.list().size());
        Assert.assertEquals((long)1L, (long)query.count());
        HistoricDetail historicDetail = (HistoricDetail)query.list().get(0);
        if (historicDetail instanceof HistoricVariableUpdate) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)historicDetail;
            Assert.assertEquals((Object)variableUpdate.getVariableName(), (Object)"boolVar");
            Assert.assertEquals((Object)variableUpdate.getTypeName(), (Object)"boolean");
        } else {
            Assert.fail((String)"Historic detail should be a variable update!");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByVariableTypeInWithSeveralTypes() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        variables1.put("intVar", 5);
        variables1.put("nullVar", null);
        variables1.put("pojoVar", new TestPojo("str", 0.0));
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableTypeIn(new String[]{"boolean", "integer", "Serializable"});
        Assert.assertEquals((long)3L, (long)query.list().size());
        Assert.assertEquals((long)3L, (long)query.count());
        HashSet<String> allowedVariableTypes = new HashSet<String>();
        allowedVariableTypes.add("boolean");
        allowedVariableTypes.add("integer");
        allowedVariableTypes.add("object");
        for (HistoricDetail detail : query.list()) {
            if (detail instanceof HistoricVariableUpdate) {
                HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)detail;
                Assert.assertTrue((boolean)allowedVariableTypes.contains(variableUpdate.getTypeName()));
                continue;
            }
            Assert.fail((String)"Historic detail should be a variable update!");
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidVariableTypeIn() {
        HashMap<String, Object> variables1 = new HashMap<String, Object>();
        variables1.put("stringVar", "test");
        variables1.put("boolVar", true);
        variables1.put("intVar", 5);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableTypeIn(new String[]{"invalid"});
        Assert.assertEquals((long)0L, (long)query.count());
        try {
            query.variableTypeIn(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.variableTypeIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLike() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("bazBarFoo", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("FooBar%").list();
        Assertions.assertThat((List)historicDetails).hasSize(1);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        HistoricVariableUpdate historicDetail = (HistoricVariableUpdate)historicDetails.get(0);
        Assertions.assertThat((String)historicDetail.getVariableName()).isEqualTo((Object)"FooBarBaz");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikeTwoWildcards() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("FooBaz", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("%Bar%").list();
        Assertions.assertThat((List)historicDetails).hasSize(1);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        HistoricVariableUpdate historicDetail = (HistoricVariableUpdate)historicDetails.get(0);
        Assertions.assertThat((String)historicDetail.getVariableName()).isEqualTo((Object)"FooBarBaz");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikePrefixWildcard() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("FooBar", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("%Bar").list();
        Assertions.assertThat((List)historicDetails).hasSize(1);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        HistoricVariableUpdate historicDetail = (HistoricVariableUpdate)historicDetails.get(0);
        Assertions.assertThat((String)historicDetail.getVariableName()).isEqualTo((Object)"FooBar");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikeInfixWildcard() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("FooBar", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("Foo%Baz").list();
        Assertions.assertThat((List)historicDetails).hasSize(1);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        HistoricVariableUpdate historicDetail = (HistoricVariableUpdate)historicDetails.get(0);
        Assertions.assertThat((String)historicDetail.getVariableName()).isEqualTo((Object)"FooBarBaz");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikeIgnoreCase() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("BarBaz", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("foo%").list();
        Assertions.assertThat((List)historicDetails).hasSize(1);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        HistoricVariableUpdate historicDetail = (HistoricVariableUpdate)historicDetails.get(0);
        Assertions.assertThat((String)historicDetail.getVariableName()).isEqualTo((Object)"FooBarBaz");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikeEqualsNoWildcard() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("BarBaz", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("BarBaz").list();
        Assertions.assertThat((List)historicDetails).hasSize(1);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        HistoricVariableUpdate historicDetail = (HistoricVariableUpdate)historicDetails.get(0);
        Assertions.assertThat((String)historicDetail.getVariableName()).isEqualTo((Object)"BarBaz");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikeEqualsWildcards() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("BarFooBaz", "variableValue");
        variables.put("BarBaz", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("%BarBaz%").list();
        Assertions.assertThat((List)historicDetails).hasSize(1);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        HistoricVariableUpdate historicDetail = (HistoricVariableUpdate)historicDetails.get(0);
        Assertions.assertThat((String)historicDetail.getVariableName()).isEqualTo((Object)"BarBaz");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikeTwoMatches() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("BarBazFoo", "anotherVariableValue");
        variables.put("FooBaz", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("%Bar%").list();
        Assertions.assertThat((List)historicDetails).hasSize(2);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(1))).isInstanceOf(HistoricVariableUpdate.class);
        Assertions.assertThat((List)historicDetails).extracting("variableName").containsOnly(new Object[]{"FooBarBaz", "BarBazFoo"});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikeTwoProcessInstances() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("BarBazFoo", "anotherVariableValue");
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        List historicDetails = this.historyService.createHistoricDetailQuery().variableNameLike("FooBar%").list();
        Assertions.assertThat((List)historicDetails).hasSize(2);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(0))).isInstanceOf(HistoricVariableUpdate.class);
        Assertions.assertThat((Object)((HistoricDetail)historicDetails.get(1))).isInstanceOf(HistoricVariableUpdate.class);
        Assertions.assertThat((List)historicDetails).extracting(new String[]{"variableName", "processInstanceId"}).containsExactlyInAnyOrder((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{"FooBarBaz", processInstance1.getId()}), Assertions.tuple((Object[])new Object[]{"FooBarBaz", processInstance2.getId()})});
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void shouldQueryByVariableNameLikeNull() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("FooBarBaz", "variableValue");
        variables.put("FooBaz", "anotherVariableValue");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> query.variableNameLike(null)).isInstanceOf(NullValueException.class)).hasMessageContaining("Variable name like is null");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryBySingleProcessInstanceId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId()});
        Assert.assertEquals((long)1L, (long)query.count());
        Assert.assertEquals((Object)((HistoricDetail)query.list().get(0)).getProcessInstanceId(), (Object)processInstance.getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryBySeveralProcessInstanceIds() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceIdIn(new String[]{processInstance.getProcessInstanceId(), processInstance2.getProcessInstanceId()});
        HashSet<String> expectedProcessInstanceIds = new HashSet<String>();
        expectedProcessInstanceIds.add(processInstance.getId());
        expectedProcessInstanceIds.add(processInstance2.getId());
        Assert.assertEquals((long)2L, (long)query.count());
        Assert.assertTrue((boolean)expectedProcessInstanceIds.contains(((HistoricDetail)query.list().get(0)).getProcessInstanceId()));
        Assert.assertTrue((boolean)expectedProcessInstanceIds.contains(((HistoricDetail)query.list().get(1)).getProcessInstanceId()));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByNonExistingProcessInstanceId() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery().processInstanceIdIn(new String[]{"foo"});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidProcessInstanceIds() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        try {
            query.processInstanceIdIn(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            query.processInstanceIdIn(new String[]{null});
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByOccurredBefore() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertEquals((long)1L, (long)query.occurredBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.occurredBefore(hourAgo.getTime()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByOccurredAfter() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertEquals((long)0L, (long)query.occurredAfter(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)query.occurredAfter(hourAgo.getTime()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testQueryByOccurredAfterAndOccurredBefore() {
        Calendar startTime = Calendar.getInstance();
        ClockUtil.setCurrentTime((Date)startTime.getTime());
        Calendar hourAgo = Calendar.getInstance();
        hourAgo.add(11, -1);
        Calendar hourFromNow = Calendar.getInstance();
        hourFromNow.add(11, 1);
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        Assert.assertEquals((long)0L, (long)query.occurredAfter(hourFromNow.getTime()).occurredBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)1L, (long)query.occurredAfter(hourAgo.getTime()).occurredBefore(hourFromNow.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.occurredAfter(hourFromNow.getTime()).occurredBefore(hourAgo.getTime()).count());
        Assert.assertEquals((long)0L, (long)query.occurredAfter(hourAgo.getTime()).occurredBefore(hourAgo.getTime()).count());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidOccurredBeforeDate() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        try {
            query.occurredBefore(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    public void testQueryByInvalidOccurredAfterDate() {
        HashMap<String, String> variables1 = new HashMap<String, String>();
        variables1.put("stringVar", "test");
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY, variables1);
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        try {
            query.occurredAfter(null);
            Assert.fail((String)"A ProcessEngineException was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    public void testQueryByCaseInstanceIdAndCaseExecutionId() {
        String caseInstanceId = this.caseService.createCaseInstanceByKey("oneTaskCase").getId();
        this.caseService.setVariable(caseInstanceId, "myVariable", (Object)1);
        HistoricDetail detail = (HistoricDetail)this.historyService.createHistoricDetailQuery().caseInstanceId(caseInstanceId).caseExecutionId(caseInstanceId).singleResult();
        Assertions.assertThat((String)detail.getCaseInstanceId()).isEqualTo((Object)caseInstanceId);
        Assertions.assertThat((String)detail.getCaseExecutionId()).isEqualTo((Object)caseInstanceId);
    }

    @Test
    public void testInitialFlagAsyncBeforeUserTask() {
        BpmnModelInstance model = AsyncProcessModels.ASYNC_BEFORE_USER_TASK_PROCESS;
        this.testHelper.deployAndGetDefinition(model);
        String initalValue = "initial";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)initalValue));
        String localValue = "bar";
        this.runtimeService.setVariableLocal(processInstance.getId(), "local", (Object)localValue);
        List details = this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)details.size());
        for (HistoricDetail historicDetail : details) {
            HistoricVariableUpdateEventEntity detail = (HistoricVariableUpdateEventEntity)historicDetail;
            String variableValue = detail.getTextValue();
            if (variableValue.equals(initalValue)) {
                Assert.assertTrue((boolean)detail.isInitial());
                continue;
            }
            if (variableValue.equals(localValue)) {
                Assert.assertFalse((boolean)detail.isInitial());
                continue;
            }
            Assert.fail((String)("illegal variable value:" + variableValue));
        }
    }

    @Test
    public void testInitialFlagAsyncBeforeStartEvent() {
        BpmnModelInstance model = AsyncProcessModels.ASYNC_BEFORE_START_EVENT_PROCESS;
        this.testHelper.deployAndGetDefinition(model);
        String initalValue = "initial";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)initalValue));
        String secondValue = "second";
        this.runtimeService.setVariable(processInstance.getId(), "foo", (Object)secondValue);
        List details = this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)details.size());
        for (HistoricDetail historicDetail : details) {
            HistoricVariableUpdateEventEntity detail = (HistoricVariableUpdateEventEntity)historicDetail;
            String variableValue = detail.getTextValue();
            if (variableValue.equals(initalValue)) {
                Assert.assertTrue((boolean)detail.isInitial());
                continue;
            }
            if (variableValue.equals(secondValue)) {
                Assert.assertFalse((boolean)detail.isInitial());
                continue;
            }
            Assert.fail((String)("illegal variable value:" + variableValue));
        }
    }

    @Test
    public void testInitialFlagAsyncBeforeSubprocess() {
        BpmnModelInstance model = AsyncProcessModels.ASYNC_BEFORE_SUBPROCESS_START_EVENT_PROCESS;
        this.testHelper.deployAndGetDefinition(model);
        String initalValue = "initial";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("Process", (Map)Variables.createVariables().putValue("foo", (Object)initalValue));
        String secondValue = "second";
        this.runtimeService.setVariable(processInstance.getId(), "foo", (Object)secondValue);
        List details = this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)details.size());
        for (HistoricDetail historicDetail : details) {
            HistoricVariableUpdateEventEntity detail = (HistoricVariableUpdateEventEntity)historicDetail;
            String variableValue = detail.getTextValue();
            if (variableValue.equals(initalValue)) {
                Assert.assertTrue((boolean)detail.isInitial());
                continue;
            }
            if (variableValue.equals(secondValue)) {
                Assert.assertFalse((boolean)detail.isInitial());
                continue;
            }
            Assert.fail((String)("illegal variable value:" + variableValue));
        }
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/async/AsyncStartEventTest.testAsyncStartEventListeners.bpmn20.xml"})
    public void testInitialFlagAsyncBeforeStartEventGlobalExecutionListener() {
        String initalValue = "initial";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncStartEvent", (Map)Variables.createVariables().putValue("foo", (Object)initalValue));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List details = this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)details.size());
        for (HistoricDetail historicDetail : details) {
            HistoricVariableUpdateEventEntity detail = (HistoricVariableUpdateEventEntity)historicDetail;
            Assert.assertTrue((boolean)detail.isInitial());
            String variableValue = detail.getTextValue();
            if (variableValue.equals(initalValue)) {
                Assert.assertEquals((Object)"foo", (Object)detail.getVariableName());
                continue;
            }
            if (variableValue.equals("listener invoked")) {
                Assert.assertEquals((Object)"listener", (Object)detail.getVariableName());
                continue;
            }
            Assert.fail((String)("illegal variable value:" + variableValue));
        }
    }

    @Test
    public void testInitialFlagAsyncBeforeStartEventExecutionListener() {
        BpmnModelInstance model = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).camundaExecutionListenerClass("start", AsyncListener.class)).userTask().endEvent().done();
        this.testHelper.deployAndGetDefinition(model);
        String initalValue = "initial";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("foo", (Object)initalValue));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List details = this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)details.size());
        for (HistoricDetail historicDetail : details) {
            HistoricVariableUpdateEventEntity detail = (HistoricVariableUpdateEventEntity)historicDetail;
            String variableValue = detail.getTextValue();
            Assert.assertTrue((boolean)detail.isInitial());
            if (variableValue.equals(initalValue)) {
                Assert.assertEquals((Object)"foo", (Object)detail.getVariableName());
                continue;
            }
            if (variableValue.equals("listener invoked")) {
                Assert.assertEquals((Object)"listener", (Object)detail.getVariableName());
                continue;
            }
            Assert.fail((String)("illegal variable value:" + variableValue));
        }
    }

    @Test
    public void testInitialFlagAsyncBeforeStartEventEndExecutionListener() {
        BpmnModelInstance model = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).camundaExecutionListenerClass("end", AsyncListener.class)).userTask().endEvent().done();
        this.testHelper.deployAndGetDefinition(model);
        String initalValue = "initial";
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("foo", (Object)initalValue));
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List details = this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertEquals((long)2L, (long)details.size());
        for (HistoricDetail historicDetail : details) {
            HistoricVariableUpdateEventEntity detail = (HistoricVariableUpdateEventEntity)historicDetail;
            String variableValue = detail.getTextValue();
            Assert.assertTrue((boolean)detail.isInitial());
            if (variableValue.equals(initalValue)) {
                Assert.assertEquals((Object)"foo", (Object)detail.getVariableName());
                continue;
            }
            if (variableValue.equals("listener invoked")) {
                Assert.assertEquals((Object)"listener", (Object)detail.getVariableName());
                continue;
            }
            Assert.fail((String)("illegal variable value:" + variableValue));
        }
    }

    protected VariableMap getVariables() {
        return Variables.createVariables().putValue("aVariableName", (Object)"aVariableValue");
    }

    protected void startProcessInstance(String key) {
        this.startProcessInstances(key, 1);
    }

    protected void startProcessInstances(String key, int numberOfInstances) {
        for (int i = 0; i < numberOfInstances; ++i) {
            this.runtimeService.startProcessInstanceByKey(key);
        }
        this.testHelper.executeAvailableJobs();
    }
}

