/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExternalTaskQueryTest
extends PluggableProcessEngineTest {
    protected static final String WORKER_ID = "aWorkerId";
    protected static final String TOPIC_NAME = "externalTaskTopic";
    protected static final String ERROR_MESSAGE = "error";
    protected static final double MAX_DOUBLE_VALUE = 1.0E125;

    @Before
    public void setUp() throws Exception {
        ClockUtil.setCurrentTime((Date)new Date());
    }

    @After
    public void tearDown() throws Exception {
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testSingleResult() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assert.assertNotNull((Object)externalTask.getId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)externalTask.getProcessInstanceId());
        Assert.assertEquals((Object)"externalTask", (Object)externalTask.getActivityId());
        Assert.assertNotNull((Object)externalTask.getActivityInstanceId());
        Assert.assertNotNull((Object)externalTask.getExecutionId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)externalTask.getProcessDefinitionId());
        Assert.assertEquals((Object)"oneExternalTaskProcess", (Object)externalTask.getProcessDefinitionKey());
        Assert.assertEquals((Object)TOPIC_NAME, (Object)externalTask.getTopicName());
        Assert.assertNull((Object)externalTask.getWorkerId());
        Assert.assertNull((Object)externalTask.getLockExpirationTime());
        Assert.assertFalse((boolean)externalTask.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testList() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        Assert.assertEquals((long)5L, (long)this.externalTaskService.createExternalTaskQuery().list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testCount() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        Assert.assertEquals((long)5L, (long)this.externalTaskService.createExternalTaskQuery().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByLockState() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        this.lockInstances(TOPIC_NAME, 10000L, 3, WORKER_ID);
        List lockedTasks = this.externalTaskService.createExternalTaskQuery().locked().list();
        List nonLockedTasks = this.externalTaskService.createExternalTaskQuery().notLocked().list();
        Assert.assertEquals((long)3L, (long)lockedTasks.size());
        for (ExternalTask task : lockedTasks) {
            Assert.assertNotNull((Object)task.getLockExpirationTime());
        }
        Assert.assertEquals((long)2L, (long)nonLockedTasks.size());
        for (ExternalTask task : nonLockedTasks) {
            Assert.assertNull((Object)task.getLockExpirationTime());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessDefinitionId() {
        org.camunda.bpm.engine.repository.Deployment secondDeployment = this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml").deploy();
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        this.startInstancesById(((ProcessDefinition)processDefinitions.get(0)).getId(), 3);
        this.startInstancesById(((ProcessDefinition)processDefinitions.get(1)).getId(), 2);
        List definition1Tasks = this.externalTaskService.createExternalTaskQuery().processDefinitionId(((ProcessDefinition)processDefinitions.get(0)).getId()).list();
        List definition2Tasks = this.externalTaskService.createExternalTaskQuery().processDefinitionId(((ProcessDefinition)processDefinitions.get(1)).getId()).list();
        Assert.assertEquals((long)3L, (long)definition1Tasks.size());
        for (ExternalTask task : definition1Tasks) {
            Assert.assertEquals((Object)((ProcessDefinition)processDefinitions.get(0)).getId(), (Object)task.getProcessDefinitionId());
        }
        Assert.assertEquals((long)2L, (long)definition2Tasks.size());
        for (ExternalTask task : definition2Tasks) {
            Assert.assertEquals((Object)((ProcessDefinition)processDefinitions.get(1)).getId(), (Object)task.getProcessDefinitionId());
        }
        this.repositoryService.deleteDeployment(secondDeployment.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByActivityId() {
        this.startInstancesByKey("parallelExternalTaskProcess", 3);
        List tasks = this.externalTaskService.createExternalTaskQuery().activityId("externalTask2").list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((Object)"externalTask2", (Object)task.getActivityId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByActivityIdIn() {
        this.startInstancesByKey("parallelExternalTaskProcess", 3);
        List<String> activityIds = Arrays.asList("externalTask1", "externalTask2");
        List tasks = this.externalTaskService.createExternalTaskQuery().activityIdIn(activityIds.toArray(new String[0])).list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertTrue((boolean)activityIds.contains(task.getActivityId()));
        }
    }

    @Test
    public void testFailQueryByActivityIdInNull() {
        try {
            this.externalTaskService.createExternalTaskQuery().activityIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/parallelExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByTopicName() {
        this.startInstancesByKey("parallelExternalTaskProcess", 3);
        List topic1Tasks = this.externalTaskService.createExternalTaskQuery().topicName("topic1").list();
        Assert.assertEquals((long)3L, (long)topic1Tasks.size());
        for (ExternalTask task : topic1Tasks) {
            Assert.assertEquals((Object)"topic1", (Object)task.getTopicName());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceId() {
        List<ProcessInstance> processInstances = this.startInstancesByKey("oneExternalTaskProcess", 3);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(processInstances.get(0).getId()).singleResult();
        Assert.assertNotNull((Object)task);
        Assert.assertEquals((Object)processInstances.get(0).getId(), (Object)task.getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByLargeListOfProcessInstanceIdIn() {
        ArrayList<String> processInstances = new ArrayList<String>();
        for (int i = 0; i < 1001; ++i) {
            processInstances.add(this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess").getProcessInstanceId());
        }
        List tasks = this.externalTaskService.createExternalTaskQuery().processInstanceIdIn(processInstances.toArray(new String[processInstances.size()])).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)1001L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertTrue((boolean)processInstances.contains(task.getProcessInstanceId()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByProcessInstanceIdIn() {
        List<ProcessInstance> processInstances = this.startInstancesByKey("oneExternalTaskProcess", 3);
        List<String> processInstanceIds = Arrays.asList(processInstances.get(0).getId(), processInstances.get(1).getId());
        List tasks = this.externalTaskService.createExternalTaskQuery().processInstanceIdIn(new String[]{processInstances.get(0).getId(), processInstances.get(1).getId()}).list();
        Assert.assertNotNull((Object)tasks);
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertTrue((boolean)processInstanceIds.contains(task.getProcessInstanceId()));
        }
    }

    @Test
    public void testQueryByNonExistingProcessInstanceId() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery().processInstanceIdIn(new String[]{"nonExisting"});
        Assert.assertEquals((long)0L, (long)query.count());
    }

    @Test
    public void testQueryByProcessInstanceIdNull() {
        try {
            this.externalTaskService.createExternalTaskQuery().processInstanceIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByExecutionId() {
        List<ProcessInstance> processInstances = this.startInstancesByKey("oneExternalTaskProcess", 3);
        ProcessInstance firstInstance = processInstances.get(0);
        ActivityInstance externalTaskActivityInstance = this.runtimeService.getActivityInstance(firstInstance.getId()).getActivityInstances("externalTask")[0];
        String executionId = externalTaskActivityInstance.getExecutionIds()[0];
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().executionId(executionId).singleResult();
        Assert.assertNotNull((Object)externalTask);
        Assert.assertEquals((Object)executionId, (Object)externalTask.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByWorkerId() {
        this.startInstancesByKey("oneExternalTaskProcess", 10);
        this.lockInstances(TOPIC_NAME, 10000L, 3, "worker1");
        this.lockInstances(TOPIC_NAME, 10000L, 4, "worker2");
        List tasks = this.externalTaskService.createExternalTaskQuery().workerId("worker1").list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((Object)"worker1", (Object)task.getWorkerId());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByLockExpirationTime() {
        this.startInstancesByKey("oneExternalTaskProcess", 10);
        this.lockInstances(TOPIC_NAME, 5000L, 3, WORKER_ID);
        this.lockInstances(TOPIC_NAME, 10000L, 4, WORKER_ID);
        Date lockDate = new Date(ClockUtil.getCurrentTime().getTime() + 7000L);
        List lockedExpirationBeforeTasks = this.externalTaskService.createExternalTaskQuery().lockExpirationBefore(lockDate).list();
        List lockedExpirationAfterTasks = this.externalTaskService.createExternalTaskQuery().lockExpirationAfter(lockDate).list();
        Assert.assertEquals((long)3L, (long)lockedExpirationBeforeTasks.size());
        for (ExternalTask task : lockedExpirationBeforeTasks) {
            Assert.assertNotNull((Object)task.getLockExpirationTime());
            Assert.assertTrue((task.getLockExpirationTime().getTime() < lockDate.getTime() ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)4L, (long)lockedExpirationAfterTasks.size());
        for (ExternalTask task : lockedExpirationAfterTasks) {
            Assert.assertNotNull((Object)task.getLockExpirationTime());
            Assert.assertTrue((task.getLockExpirationTime().getTime() > lockDate.getTime() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testQueryWithNullValues() {
        try {
            this.externalTaskService.createExternalTaskQuery().externalTaskId(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("externalTaskId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().activityId(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("activityId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().executionId(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("executionId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().lockExpirationAfter(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("lockExpirationAfter is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().lockExpirationBefore(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("lockExpirationBefore is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processDefinitionId(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("processDefinitionId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processInstanceId(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("processInstanceId is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().topicName(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("topicName is null", e.getMessage());
        }
        try {
            this.externalTaskService.createExternalTaskQuery().workerId(null).list();
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresent("workerId is null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQuerySorting() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        this.startInstancesByKey("twoExternalTaskProcess", 5);
        this.lockInstances(TOPIC_NAME, 5000L, 5, WORKER_ID);
        this.lockInstances(TOPIC_NAME, 10000L, 5, WORKER_ID);
        List tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderById().asc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskById());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessInstanceId().asc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskByProcessInstanceId());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessDefinitionId().asc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskByProcessDefinitionId());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessDefinitionKey().asc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskByProcessDefinitionKey());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByLockExpirationTime().asc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.externalTaskByLockExpirationTime());
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderById().desc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskById()));
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessInstanceId().desc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByProcessInstanceId()));
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessDefinitionId().desc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByProcessDefinitionId()));
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByProcessDefinitionKey().desc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByProcessDefinitionKey()));
        tasks = ((ExternalTaskQuery)this.externalTaskService.createExternalTaskQuery().orderByLockExpirationTime().desc()).list();
        Assert.assertEquals((long)10L, (long)tasks.size());
        TestOrderingUtil.verifySorting(tasks, TestOrderingUtil.inverted(TestOrderingUtil.externalTaskByLockExpirationTime()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryBySuspensionState() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        this.suspendInstances(3);
        List suspendedTasks = this.externalTaskService.createExternalTaskQuery().suspended().list();
        List activeTasks = this.externalTaskService.createExternalTaskQuery().active().list();
        Assert.assertEquals((long)3L, (long)suspendedTasks.size());
        for (ExternalTask task : suspendedTasks) {
            Assert.assertTrue((boolean)task.isSuspended());
        }
        Assert.assertEquals((long)2L, (long)activeTasks.size());
        for (ExternalTask task : activeTasks) {
            Assert.assertFalse((boolean)task.isSuspended());
            Assert.assertFalse((boolean)suspendedTasks.contains(task));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByRetries() {
        this.startInstancesByKey("oneExternalTaskProcess", 5);
        List<LockedExternalTask> tasks = this.lockInstances(TOPIC_NAME, 10000L, 3, WORKER_ID);
        this.failInstances(tasks.subList(0, 2), ERROR_MESSAGE, 0, 5000L);
        this.failInstances(tasks.subList(2, 3), ERROR_MESSAGE, 4, 5000L);
        List tasksWithRetries = this.externalTaskService.createExternalTaskQuery().withRetriesLeft().list();
        List tasksWithoutRetries = this.externalTaskService.createExternalTaskQuery().noRetriesLeft().list();
        Assert.assertEquals((long)3L, (long)tasksWithRetries.size());
        for (ExternalTask task : tasksWithRetries) {
            Assert.assertTrue((task.getRetries() == null || task.getRetries() > 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)2L, (long)tasksWithoutRetries.size());
        for (ExternalTask task : tasksWithoutRetries) {
            Assert.assertTrue((task.getRetries() == 0 ? 1 : 0) != 0);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryById() {
        this.startInstancesByKey("oneExternalTaskProcess", 2);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        ExternalTask firstTask = (ExternalTask)tasks.get(0);
        ExternalTask resultTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().externalTaskId(firstTask.getId()).singleResult();
        Assert.assertEquals((Object)firstTask.getId(), (Object)resultTask.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByIds() {
        this.startInstancesByKey("oneExternalTaskProcess", 3);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        HashSet ids = new HashSet();
        Collections.addAll(ids, ((ExternalTask)tasks.get(0)).getId(), ((ExternalTask)tasks.get(1)).getId());
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery().externalTaskIdIn(ids);
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByIdsWithNull() {
        Set ids = null;
        try {
            this.externalTaskService.createExternalTaskQuery().externalTaskIdIn(ids).list();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Set of external task ids is null");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByIdsWithEmptyList() {
        HashSet ids = new HashSet();
        try {
            this.externalTaskService.createExternalTaskQuery().externalTaskIdIn(ids).list();
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Set of external task ids is empty");
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryByBusinessKey() {
        String businessKey = "theUltimateKey";
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", businessKey);
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assert.assertNotNull((Object)externalTask);
        Assert.assertEquals((Object)businessKey, (Object)externalTask.getBusinessKey());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testQueryListByBusinessKey() {
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", "businessKey" + i);
        }
        Assert.assertEquals((long)5L, (long)this.externalTaskService.createExternalTaskQuery().count());
        List list = this.externalTaskService.createExternalTaskQuery().list();
        for (ExternalTask externalTask : list) {
            Assert.assertNotNull((Object)externalTask.getBusinessKey());
        }
    }

    @Test
    public void shouldCheckPresenceOfVersionTag() {
        BpmnModelInstance process = ((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaVersionTag("1.2.3.4")).startEvent().serviceTask().camundaExternalTask("my-topic")).endEvent().done();
        this.testRule.deploy(process);
        this.startInstancesByKey("process", 1);
        ExternalTask task = (ExternalTask)this.externalTaskService.createExternalTaskQuery().singleResult();
        Assertions.assertThat((String)task.getProcessDefinitionVersionTag()).isEqualTo((Object)"1.2.3.4");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionKey() throws Exception {
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processDefinitionKey("oneExternalTaskProcess").count());
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processDefinitionKey("oneExternalTaskProcess").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionKeyIn() throws Exception {
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processDefinitionKeyIn(new String[]{"oneExternalTaskProcess"}).count());
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processDefinitionKeyIn(new String[]{"oneExternalTaskProcess"}).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessDefinitionName() throws Exception {
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processDefinitionName("One external task process").count());
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processDefinitionName("One external task process").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void processDefinitionNameLike() throws Exception {
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processDefinitionNameLike("One external task proc%").count());
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess");
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processDefinitionNameLike("One external task proc%").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 928374L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("longVar", (Object)928374L).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("shortVar", (Object)123).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("nullVar", null).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("longVar", (Object)999L).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("shortVar", (Object)999).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("integerVar", (Object)999).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("stringVar", (Object)"999").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("booleanVar", (Object)false).count());
        Calendar otherDate = Calendar.getInstance();
        otherDate.add(1, 1);
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("dateVar", (Object)otherDate.getTime()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("nullVar", (Object)"999").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotEquals("longVar", (Object)999L).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotEquals("shortVar", (Object)999).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotEquals("integerVar", (Object)999).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotEquals("stringVar", (Object)"999").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotEquals("booleanVar", (Object)false).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotEquals("longVar", (Object)928374L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableNameEqualsIgnoreCase() throws Exception {
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableNamesIgnoreCase().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals(variableName.toLowerCase(), (Object)variableValue).matchVariableNamesIgnoreCase().count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueEqualsIgnoreCase() throws Exception {
        String variableName = "someVariable";
        String variableValue = "someCamelCaseValue";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put(variableName, variableValue);
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals(variableName, (Object)variableValue).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("nonExistentVariable", (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals("nonExistentVariable", (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals(variableName, (Object)"nonExistentValue").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName, (Object)"nonExistentValue".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotEquals(variableName, (Object)variableValue.toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotEquals(variableName, (Object)variableValue.toLowerCase()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueLike() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", "stringVal%").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", "%ngValue").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", "%ngVal%").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", "stringVar%").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", "%ngVar").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", "%ngVar%").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", "stringVal").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("nonExistingVar", "string%").count());
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueLikeIgnoreCase() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", variables);
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "%ngValue".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "%ngVal%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "stringVar%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "%ngVar".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "%ngVar%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", "stringVal".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("nonExistingVar", "stringVal%".toLowerCase()).count());
        try {
            this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueLike("stringVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueNotLike() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", variables);
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", "stringVal%").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", "%ngValue").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", "%ngVal%").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", "stringVar%").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", "%ngVar").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", "%ngVar%").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", "stringVal").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("nonExistingVar", "string%").count());
        Assertions.assertThatThrownBy(() -> this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", null).count()).isInstanceOf(ProcessEngineException.class);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueNotLikeIgnoreCase() throws Exception {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("stringVar", "stringValue");
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "stringVal%".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "%ngValue".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "%ngVal%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "stringVar%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "%ngVar".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "%ngVar%".toLowerCase()).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", "stringVal".toLowerCase()).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("nonExistingVar", "stringVal%".toLowerCase()).count());
        Assertions.assertThatThrownBy(() -> this.externalTaskService.createExternalTaskQuery().matchVariableValuesIgnoreCase().processVariableValueNotLike("stringVar", null).count()).isInstanceOf(ProcessEngineException.class);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueCompare() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("numericVar", 928374);
        Date date = new GregorianCalendar(2014, 2, 2, 2, 2, 2).getTime();
        variables.put("dateVar", date);
        variables.put("stringVar", "ab");
        variables.put("nullVar", null);
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", variables);
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928373).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928373).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("numericVar", (Object)928375).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("numericVar", (Object)928373).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928375).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928374).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("numericVar", (Object)928373).count());
        Date before = new GregorianCalendar(2014, 2, 2, 2, 2, 1).getTime();
        Date after = new GregorianCalendar(2014, 2, 2, 2, 2, 3).getTime();
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("dateVar", (Object)before).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("dateVar", (Object)after).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)after).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)date).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("dateVar", (Object)before).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("stringVar", (Object)"aa").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ba").count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"ab").count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("stringVar", (Object)"aa").count());
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("nullVar", null).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("nullVar", (Object)true).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("nullVar", (Object)false).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("nullVar", (Object)true).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("nullVar", (Object)false).count();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("nonExisting", (Object)123).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueEqualsNumber() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", "123"));
        Assert.assertEquals((long)4L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123L)).count());
        Assert.assertEquals((long)4L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123.0)).count());
        Assert.assertEquals((long)4L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue(null)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessVariableValueNumberComparison() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 123L));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 12345L));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", (short)123));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 123.0));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 123));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", null));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", Variables.longValue(null)));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", "123"));
        Assert.assertEquals((long)4L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueNotEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)5L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueGreaterThanOrEquals("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThan("var", (Object)Variables.numberValue((Number)123)).count());
        Assert.assertEquals((long)4L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueLessThanOrEquals("var", (Object)Variables.numberValue((Number)123)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableEqualsNumberMax() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 1.0E125));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)1.0E125)).count());
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)Long.MAX_VALUE)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableEqualsNumberLongValueOverflow() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 1.0E125));
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", Long.MAX_VALUE));
        Assert.assertEquals((long)1L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)1.0E125)).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml"})
    @Test
    public void testVariableEqualsNumberNonIntegerDoubleShouldNotMatchInteger() throws Exception {
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)42).putValue("var2", (Object)52.4));
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)42.4)).count());
        this.runtimeService.startProcessInstanceByKey("oneExternalTaskProcess", Collections.singletonMap("var", 42.4));
        Assert.assertEquals((long)0L, (long)this.externalTaskService.createExternalTaskQuery().processVariableValueEquals("var", (Object)Variables.numberValue((Number)52)).count());
    }

    protected List<ProcessInstance> startInstancesByKey(String processDefinitionKey, int number) {
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < number; ++i) {
            processInstances.add(this.runtimeService.startProcessInstanceByKey(processDefinitionKey));
        }
        return processInstances;
    }

    protected List<ProcessInstance> startInstancesById(String processDefinitionId, int number) {
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        for (int i = 0; i < number; ++i) {
            processInstances.add(this.runtimeService.startProcessInstanceById(processDefinitionId));
        }
        return processInstances;
    }

    protected void suspendInstances(int number) {
        List processInstances = this.runtimeService.createProcessInstanceQuery().listPage(0, number);
        for (ProcessInstance processInstance : processInstances) {
            this.runtimeService.suspendProcessInstanceById(processInstance.getId());
        }
    }

    protected List<LockedExternalTask> lockInstances(String topic, long duration, int number, String workerId) {
        return this.externalTaskService.fetchAndLock(number, workerId).topic(topic, duration).execute();
    }

    protected void failInstances(List<LockedExternalTask> tasks, String errorMessage, int retries, long retryTimeout) {
        this.failInstances(tasks, errorMessage, null, retries, retryTimeout);
    }

    protected void failInstances(List<LockedExternalTask> tasks, String errorMessage, String errorDetails, int retries, long retryTimeout) {
        for (LockedExternalTask task : tasks) {
            this.externalTaskService.handleFailure(task.getId(), task.getWorkerId(), errorMessage, errorDetails, retries, retryTimeout);
        }
    }
}

