/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.tenantcheck;

import java.util.Arrays;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MultiTenancyMigrationExecuteTenantCheckTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);

    @Test
    public void canMigrateWithAuthenticatedTenant() {
        ProcessDefinition sourceDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        this.assertMigratedTo(processInstance, targetDefinition);
    }

    @Test
    public void cannotMigrateOfNonAuthenticatedTenant() {
        ProcessDefinition sourceDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.engineRule.getIdentityService().setAuthentication("user", null, Arrays.asList(TENANT_TWO));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot migrate process instance '" + processInstance.getId() + "' because it belongs to no authenticated tenant");
    }

    @Test
    public void cannotMigrateWithNoAuthenticatedTenant() {
        ProcessDefinition sourceDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Cannot migrate process instance '" + processInstance.getId() + "' because it belongs to no authenticated tenant");
    }

    @Test
    public void canMigrateSharedInstanceWithNoTenant() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        this.assertMigratedTo(processInstance, targetDefinition);
    }

    @Test
    public void canMigrateInstanceWithTenantCheckDisabled() {
        ProcessDefinition sourceDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS);
        MigrationPlan migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).mapEqualActivities().build();
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(sourceDefinition.getId());
        this.engineRule.getIdentityService().setAuthentication("user", null, null);
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.engineRule.getRuntimeService().newMigration(migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).execute();
        this.assertMigratedTo(processInstance, targetDefinition);
    }

    protected void assertMigratedTo(ProcessInstance processInstance, ProcessDefinition targetDefinition) {
        Assert.assertEquals((long)1L, (long)this.engineRule.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstance.getId()).processDefinitionId(targetDefinition.getId()).count());
    }
}

