/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.executionlistener.RecorderExecutionListener;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInstanceModificationCancellationTest
extends PluggableProcessEngineTest {
    protected static final String ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml";
    protected static final String ONE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml";
    protected static final String CONCURRENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";
    protected static final String CONCURRENT_SCOPE_TASKS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml";
    protected static final String NESTED_PARALLEL_ONE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml";
    protected static final String NESTED_PARALLEL_ONE_SCOPE_TASK_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml";
    protected static final String NESTED_PARALLEL_CONCURRENT_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml";
    protected static final String NESTED_PARALLEL_CONCURRENT_SCOPE_TASKS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml";
    protected static final String LISTENER_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.listenerProcess.bpmn20.xml";
    protected static final String FAILING_OUTPUT_MAPPINGS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.failingOutputMappingProcess.bpmn20.xml";
    protected static final String INTERRUPTING_EVENT_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml";
    protected static final String CALL_ACTIVITY_PROCESS = "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml";
    protected static final String SIMPLE_SUBPROCESS = "org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml";
    protected static final String TWO_SUBPROCESSES = "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTwoSubProcesses.bpmn20.xml";
    protected static final String NESTED_CALL_ACTIVITY = "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testNestedCallActivity.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancellationInOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAllInOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("theTask")).execute();
        this.runtimeService.createProcessInstanceModification(processInstanceId).cancelAllForActivity("theTask").execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancellationAndCreationInOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).startBeforeActivity("theTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertEquals((Object)tree.getId(), (Object)updatedTree.getId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "theTask").equals(this.getInstanceIdForActivity(updatedTree, "theTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("theTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testCreationAndCancellationInOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "theTask").equals(this.getInstanceIdForActivity(updatedTree, "theTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("theTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancellationInOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancelAllInOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).execute();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("theTask").execute();
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancellationAndCreationInOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).startBeforeActivity("theTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "theTask").equals(this.getInstanceIdForActivity(updatedTree, "theTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("theTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.oneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCreationAndCancellationInOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("theTask")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "theTask").equals(this.getInstanceIdForActivity(updatedTree, "theTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("theTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("theTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancellationInConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancelAllInConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("task1")).execute();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("task1").execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("task2").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCancellationAndCreationInConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("task1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").noScope().concurrent().up().child("task2").noScope().concurrent().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml"})
    @Test
    public void testCreationAndCancellationInConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").noScope().concurrent().up().child("task2").noScope().concurrent().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml"})
    @Test
    public void testCancellationInConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task2").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml"})
    @Test
    public void testCancelAllInConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1")).execute();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelAllForActivity("task1").execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task2").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml"})
    @Test
    public void testCancellationAndCreationInConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("task1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).noScope().concurrent().child("task1").scope().up().up().child(null).noScope().concurrent().child("task2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGatewayScopeTasks.bpmn20.xml"})
    @Test
    public void testCreationAndCancellationInConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("parallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("task1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "task1").equals(this.getInstanceIdForActivity(updatedTree, "task1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).noScope().concurrent().child("task1").scope().up().up().child(null).noScope().concurrent().child("task2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.taskService.complete(((Task)tasks.get(1)).getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancellationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    @Test
    public void testScopeCancellationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCancellationAndCreationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).startBeforeActivity("innerTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask").equals(this.getInstanceIdForActivity(updatedTree, "innerTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneTaskProcess.bpmn20.xml"})
    @Test
    public void testCreationAndCancellationInNestedOneTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask").equals(this.getInstanceIdForActivity(updatedTree, "innerTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancellationInNestedOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneScopeTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testScopeCancellationInNestedOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneScopeTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCancellationAndCreationInNestedOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneScopeTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).startBeforeActivity("innerTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask").equals(this.getInstanceIdForActivity(updatedTree, "innerTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelOneScopeTaskProcess.bpmn20.xml"})
    @Test
    public void testCreationAndCancellationInNestedOneScopeTaskProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedOneScopeTaskProcess");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask").equals(this.getInstanceIdForActivity(updatedTree, "innerTask")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml"})
    @Test
    public void testCancellationInNestedConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml"})
    @Test
    public void testScopeCancellationInNestedConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml"})
    @Test
    public void testCancellationAndCreationInNestedConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).startBeforeActivity("innerTask1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask1").equals(this.getInstanceIdForActivity(updatedTree, "innerTask1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask1").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").noScope().concurrent().up().child(null).noScope().concurrent().child(null).scope().child("innerTask1").noScope().concurrent().up().child("innerTask2").noScope().concurrent().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGateway.bpmn20.xml"})
    @Test
    public void testCreationAndCancellationInNestedConcurrentProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGateway");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask1").equals(this.getInstanceIdForActivity(updatedTree, "innerTask1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask1").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").noScope().concurrent().up().child(null).noScope().concurrent().child(null).scope().child("innerTask1").noScope().concurrent().up().child("innerTask2").noScope().concurrent().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml"})
    @Test
    public void testCancellationInNestedConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml"})
    @Test
    public void testScopeCancellationInNestedConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "subProcess")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("outerTask").scope().done());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertNotNull((Object)task);
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml"})
    @Test
    public void testCancellationAndCreationInNestedConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).startBeforeActivity("innerTask1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask1").equals(this.getInstanceIdForActivity(updatedTree, "innerTask1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask1").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).concurrent().noScope().child(null).scope().child(null).concurrent().noScope().child("innerTask1").scope().up().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nestedParallelGatewayScopeTasks.bpmn20.xml"})
    @Test
    public void testCreationAndCancellationInNestedConcurrentScopeTasksProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("nestedParallelGatewayScopeTasks");
        String processInstanceId = processInstance.getId();
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).startBeforeActivity("innerTask1")).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        this.testRule.assertProcessNotEnded(processInstanceId);
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        Assert.assertTrue((!this.getInstanceIdForActivity(tree, "innerTask1").equals(this.getInstanceIdForActivity(updatedTree, "innerTask1")) ? 1 : 0) != 0);
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("outerTask").beginScope("subProcess").activity("innerTask1").activity("innerTask2").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("outerTask").concurrent().noScope().up().child(null).noScope().concurrent().child(null).scope().child(null).concurrent().noScope().child("innerTask1").scope().up().up().child(null).concurrent().noScope().child("innerTask2").scope().done());
        List tasks = this.taskService.createTaskQuery().list();
        Assert.assertEquals((long)3L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.listenerProcess.bpmn20.xml"})
    @Test
    public void testEndListenerInvocation() {
        RecorderExecutionListener.clear();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("listenerProcess", Collections.singletonMap("listener", new RecorderExecutionListener()));
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask1")).execute();
        Assert.assertEquals((long)1L, (long)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.RecordedEvent innerTask1EndEvent = RecorderExecutionListener.getRecordedEvents().get(0);
        Assert.assertEquals((Object)"end", (Object)innerTask1EndEvent.getEventName());
        Assert.assertEquals((Object)"innerTask1", (Object)innerTask1EndEvent.getActivityId());
        Assert.assertEquals((Object)this.getInstanceIdForActivity(tree, "innerTask1"), (Object)innerTask1EndEvent.getActivityInstanceId());
        RecorderExecutionListener.clear();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask2")).execute();
        Assert.assertEquals((long)2L, (long)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.RecordedEvent innerTask2EndEvent = RecorderExecutionListener.getRecordedEvents().get(0);
        Assert.assertEquals((Object)"end", (Object)innerTask2EndEvent.getEventName());
        Assert.assertEquals((Object)"innerTask2", (Object)innerTask2EndEvent.getActivityId());
        Assert.assertEquals((Object)this.getInstanceIdForActivity(tree, "innerTask2"), (Object)innerTask2EndEvent.getActivityInstanceId());
        RecorderExecutionListener.RecordedEvent subProcessEndEvent = RecorderExecutionListener.getRecordedEvents().get(1);
        Assert.assertEquals((Object)"end", (Object)subProcessEndEvent.getEventName());
        Assert.assertEquals((Object)"subProcess", (Object)subProcessEndEvent.getActivityId());
        Assert.assertEquals((Object)this.getInstanceIdForActivity(tree, "subProcess"), (Object)subProcessEndEvent.getActivityInstanceId());
        RecorderExecutionListener.clear();
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "outerTask")).execute();
        Assert.assertEquals((long)2L, (long)RecorderExecutionListener.getRecordedEvents().size());
        RecorderExecutionListener.RecordedEvent outerTaskEndEvent = RecorderExecutionListener.getRecordedEvents().get(0);
        Assert.assertEquals((Object)"end", (Object)outerTaskEndEvent.getEventName());
        Assert.assertEquals((Object)"outerTask", (Object)outerTaskEndEvent.getActivityId());
        Assert.assertEquals((Object)this.getInstanceIdForActivity(tree, "outerTask"), (Object)outerTaskEndEvent.getActivityInstanceId());
        RecorderExecutionListener.RecordedEvent processEndEvent = RecorderExecutionListener.getRecordedEvents().get(1);
        Assert.assertEquals((Object)"end", (Object)processEndEvent.getEventName());
        Assert.assertNull((Object)processEndEvent.getActivityId());
        Assert.assertEquals((Object)tree.getId(), (Object)processEndEvent.getActivityInstanceId());
        RecorderExecutionListener.clear();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.failingOutputMappingProcess.bpmn20.xml"})
    @Test
    public void testSkipOutputMappingsOnCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingOutputMappingProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "innerTask")).execute(false, true);
        this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "outerTask")).execute(false, true);
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingEventSubProcess.bpmn20.xml"})
    @Test
    public void testProcessInstanceEventSubscriptionsPreservedOnIntermediateCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        EventSubscription subscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)subscription);
        Assert.assertEquals((Object)processInstance.getId(), (Object)subscription.getProcessInstanceId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task1")).startBeforeActivity("task1")).execute();
        EventSubscription updatedSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult();
        Assert.assertNotNull((Object)updatedSubscription);
        Assert.assertEquals((Object)subscription.getId(), (Object)updatedSubscription.getId());
        Assert.assertEquals((Object)subscription.getProcessInstanceId(), (Object)updatedSubscription.getProcessInstanceId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testProcessInstanceVariablesPreservedOnIntermediateCancellation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", (Map)Variables.createVariables().putValue("var", (Object)"value"));
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstance.getId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "theTask")).startBeforeActivity("theTask")).execute();
        Object variable = this.runtimeService.getVariable(processInstance.getId(), "var");
        Assert.assertNotNull((Object)variable);
        Assert.assertEquals((Object)"value", (Object)variable);
    }

    public String getInstanceIdForActivity(ActivityInstance activityInstance, String activityId) {
        ActivityInstance instance = this.getChildInstanceForActivity(activityInstance, activityId);
        if (instance != null) {
            return instance.getId();
        }
        return null;
    }

    public ActivityInstance getChildInstanceForActivity(ActivityInstance activityInstance, String activityId) {
        if (activityId.equals(activityInstance.getActivityId())) {
            return activityInstance;
        }
        for (ActivityInstance childInstance : activityInstance.getChildActivityInstances()) {
            ActivityInstance instance = this.getChildInstanceForActivity(childInstance, activityId);
            if (instance == null) continue;
            return instance;
        }
        return null;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml"})
    @Test
    public void testCancellationInCallActivitySubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        String processInstanceId = processInstance.getId();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)2L, (long)instanceList.size());
        ActivityInstance tree = this.runtimeService.getActivityInstance(taskInSubProcess.getProcessInstanceId());
        this.runtimeService.createProcessInstanceModification(taskInSubProcess.getProcessInstanceId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task")).execute();
        this.testRule.assertProcessEnded(processInstanceId);
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)0L, (long)instanceList.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml"})
    @Test
    public void testCancellationAndRestartInCallActivitySubProcess() {
        this.runtimeService.startProcessInstanceByKey("callSimpleSubProcess");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)2L, (long)instanceList.size());
        ActivityInstance tree = this.runtimeService.getActivityInstance(taskInSubProcess.getProcessInstanceId());
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(taskInSubProcess.getProcessInstanceId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task")).startBeforeActivity("task")).execute();
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        Assert.assertEquals((long)2L, (long)instanceList.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testTwoSubProcesses.bpmn20.xml"})
    @Test
    public void testSingleCancellationWithTwoSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callTwoSubProcesses");
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)3L, (long)instanceList.size());
        List taskList = this.taskService.createTaskQuery().list();
        Assert.assertNotNull((Object)taskList);
        Assert.assertEquals((long)2L, (long)taskList.size());
        List activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getProcessInstanceId());
        Assert.assertNotNull((Object)activeActivityIds);
        Assert.assertEquals((long)2L, (long)activeActivityIds.size());
        ActivityInstance tree = this.runtimeService.getActivityInstance(((Task)taskList.get(0)).getProcessInstanceId());
        this.runtimeService.createProcessInstanceModification(((Task)taskList.get(0)).getProcessInstanceId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task")).execute();
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)2L, (long)instanceList.size());
        activeActivityIds = this.runtimeService.getActiveActivityIds(processInstance.getProcessInstanceId());
        Assert.assertNotNull((Object)activeActivityIds);
        Assert.assertEquals((long)1L, (long)activeActivityIds.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/callactivity/simpleSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testNestedCallActivity.bpmn20.xml", "org/camunda/bpm/engine/test/bpmn/callactivity/CallActivity.testCallSimpleSubProcess.bpmn20.xml"})
    @Test
    public void testCancellationMultilevelProcessInstanceInCallActivity() {
        this.runtimeService.startProcessInstanceByKey("nestedCallActivity");
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        Task taskBeforeSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskBeforeSubProcess.getId());
        Task taskInSubProcess = (Task)taskQuery.singleResult();
        this.taskService.complete(taskInSubProcess.getId());
        Task taskInNestedSubProcess = (Task)taskQuery.singleResult();
        List instanceList = this.runtimeService.createProcessInstanceQuery().list();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)3L, (long)instanceList.size());
        ActivityInstance tree = this.runtimeService.getActivityInstance(taskInNestedSubProcess.getProcessInstanceId());
        this.runtimeService.createProcessInstanceModification(taskInNestedSubProcess.getProcessInstanceId()).cancelActivityInstance(this.getInstanceIdForActivity(tree, "task")).execute();
        instanceList = this.runtimeService.createProcessInstanceQuery().list();
        Assert.assertNotNull((Object)instanceList);
        Assert.assertEquals((long)0L, (long)instanceList.size());
    }
}

