/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.test.history.TestEventHandler;
import org.jetbrains.annotations.NotNull;
import org.junit.rules.Verifier;

public class HistoryEventVerifier
extends Verifier {
    private final TestEventHandler eventHandler;
    private final List<Condition<HistoryEvent>> hasConditions = new ArrayList<Condition<HistoryEvent>>(50);
    private final List<Condition<HistoryEvent>> isConditions = new ArrayList<Condition<HistoryEvent>>(50);

    public HistoryEventVerifier(TestEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void historyEventHas(String message, Predicate<HistoryEvent> predicate) {
        Condition<HistoryEvent> hasCondition = HistoryEventVerifier.getCondition(message, predicate);
        this.hasConditions.add(hasCondition);
    }

    public void historyEventIs(String message, Predicate<HistoryEvent> predicate) {
        Condition<HistoryEvent> isCondition = HistoryEventVerifier.getCondition(message, predicate);
        this.isConditions.add(isCondition);
    }

    @NotNull
    private static Condition<HistoryEvent> getCondition(String message, final Predicate<HistoryEvent> predicate) {
        return new Condition<HistoryEvent>(message){

            public boolean matches(HistoryEvent value) {
                return predicate.test(value);
            }
        };
    }

    protected void verify() throws Throwable {
        while (this.eventHandler.peek() != null) {
            HistoryEvent evt = this.eventHandler.poll();
            this.hasConditions.forEach(condition -> Assertions.assertThat((Object)evt).has(condition));
            this.isConditions.forEach(condition -> Assertions.assertThat((Object)evt).is(condition));
        }
    }
}

