/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.dmn;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.NativeHistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionRequirementsDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.joda.time.DateTime;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class HistoricDecisionInstanceQueryTest
extends PluggableProcessEngineTest {
    protected static final String DECISION_CASE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn";
    protected static final String DECISION_PROCESS = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml";
    protected static final String DECISION_PROCESS_WITH_UNDERSCORE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask_.bpmn20.xml";
    protected static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    protected static final String DECISION_SINGLE_OUTPUT_DMN_WITH_UNDERSCORE = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput_.dmn11.xml";
    protected static final String DECISION_NO_INPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.noInput.dmn11.xml";
    protected static final String DRG_DMN = "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml";
    protected static final String DECISION_DEFINITION_KEY = "testDecision";
    protected static final String DISH_DECISION = "dish-decision";

    @Before
    public void setUp() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void tearDown() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryIncludeInputsForNonExistingDecision() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().includeInputs();
        Assertions.assertThat((Object)((HistoricDecisionInstance)query.singleResult())).isNull();
        this.startProcessInstanceAndEvaluateDecision();
        Assertions.assertThat((Object)((HistoricDecisionInstance)query.decisionInstanceId("nonExisting").singleResult())).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryIncludeOutputs() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        try {
            ((HistoricDecisionInstance)query.singleResult()).getOutputs();
            Assert.fail((String)"expected exception: output not fetched");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        Assertions.assertThat((List)((HistoricDecisionInstance)query.includeOutputs().singleResult()).getOutputs()).hasSize(1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryIncludeOutputsForNonExistingDecision() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery().includeOutputs();
        Assertions.assertThat((Object)((HistoricDecisionInstance)query.singleResult())).isNull();
        this.startProcessInstanceAndEvaluateDecision();
        Assertions.assertThat((Object)((HistoricDecisionInstance)query.decisionInstanceId("nonExisting").singleResult())).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.noInput.dmn11.xml"})
    @Test
    public void testQueryIncludeInputsNoInput() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((List)((HistoricDecisionInstance)query.includeInputs().singleResult()).getInputs()).isEmpty();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.noInput.dmn11.xml"})
    @Test
    public void testQueryIncludeOutputsNoInput() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((List)((HistoricDecisionInstance)query.includeOutputs().singleResult()).getOutputs()).isEmpty();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryPaging() {
        this.startProcessInstanceAndEvaluateDecision();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((List)query.listPage(0, 2)).hasSize(2);
        Assertions.assertThat((List)query.listPage(1, 1)).hasSize(1);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQuerySortByEvaluationTime() {
        this.startProcessInstanceAndEvaluateDecision();
        this.waitASignificantAmountOfTime();
        this.startProcessInstanceAndEvaluateDecision();
        List orderAsc = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByEvaluationTime().asc()).list();
        Assertions.assertThat((boolean)((HistoricDecisionInstance)orderAsc.get(0)).getEvaluationTime().before(((HistoricDecisionInstance)orderAsc.get(1)).getEvaluationTime())).isTrue();
        List orderDesc = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByEvaluationTime().desc()).list();
        Assertions.assertThat((boolean)((HistoricDecisionInstance)orderDesc.get(0)).getEvaluationTime().after(((HistoricDecisionInstance)orderDesc.get(1)).getEvaluationTime())).isTrue();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQuerySortByDecisionInstanceId() {
        for (int i = 0; i < 5; ++i) {
            this.startProcessInstanceAndEvaluateDecision();
        }
        List orderAsc = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByDecisionInstanceId().asc()).list();
        Assertions.assertThat((int)orderAsc.size()).isEqualTo(5);
        TestOrderingUtil.verifySorting(orderAsc, TestOrderingUtil.propertyComparator(HistoricDecisionInstance::getId));
        List orderDesc = ((HistoricDecisionInstanceQuery)this.historyService.createHistoricDecisionInstanceQuery().orderByDecisionInstanceId().desc()).list();
        Assertions.assertThat((int)orderDesc.size()).isEqualTo(5);
        TestOrderingUtil.verifySorting(orderDesc, TestOrderingUtil.inverted(TestOrderingUtil.propertyComparator(HistoricDecisionInstance::getId)));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByDecisionInstanceId() {
        ProcessInstance pi1 = this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance pi2 = this.startProcessInstanceAndEvaluateDecision();
        String decisionInstanceId1 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi1.getId()).singleResult()).getId();
        String decisionInstanceId2 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi2.getId()).singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionInstanceId(decisionInstanceId1).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionInstanceId(decisionInstanceId2).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionInstanceId("unknown").count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByDecisionInstanceIds() {
        ProcessInstance pi1 = this.startProcessInstanceAndEvaluateDecision();
        ProcessInstance pi2 = this.startProcessInstanceAndEvaluateDecision();
        String decisionInstanceId1 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi1.getId()).singleResult()).getId();
        String decisionInstanceId2 = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().processInstanceId(pi2.getId()).singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionInstanceIdIn(new String[]{decisionInstanceId1}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionInstanceIdIn(new String[]{decisionInstanceId2}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionInstanceIdIn(new String[]{decisionInstanceId1, decisionInstanceId2}).count()).isEqualTo(2L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByDecisionDefinitionId() {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionDefinitionId(decisionDefinitionId).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionDefinitionId("other id").count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testQueryByDecisionDefinitionIdIn() {
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        String decisionDefinitionId2 = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DISH_DECISION).singleResult()).getId();
        this.startProcessInstanceAndEvaluateDecision();
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionDefinitionIdIn(new String[]{decisionDefinitionId, decisionDefinitionId2}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.decisionDefinitionIdIn(new String[]{"other id", "anotherFake"}).count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testQueryByInvalidDecisionDefinitionIdIn() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        try {
            query.decisionDefinitionIdIn(new String[]{"aFake", null}).count();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testQueryByDecisionDefinitionKeyIn() {
        this.startProcessInstanceAndEvaluateDecision();
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionDefinitionKeyIn(new String[]{DISH_DECISION, DECISION_DEFINITION_KEY}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.decisionDefinitionKeyIn(new String[]{"other id", "anotherFake"}).count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testQueryByInvalidDecisionDefinitionKeyIn() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        try {
            query.decisionDefinitionKeyIn(new String[]{"aFake", null}).count();
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByDecisionDefinitionKey() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionDefinitionKey(DECISION_DEFINITION_KEY).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionDefinitionKey("other key").count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByDecisionDefinitionName() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionDefinitionName("sample decision").count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionDefinitionName("other name").count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask_.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput_.dmn11.xml"})
    @Test
    public void testQueryByDecisionDefinitionNameLike() {
        this.startProcessInstanceAndEvaluateDecision();
        this.startProcessInstanceAndEvaluateDecisionWithUnderscore();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionDefinitionNameLike("%ample dec%").count()).isEqualTo(1L);
        Assertions.assertThat((long)query.decisionDefinitionNameLike("%ample\\_%").count()).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByInvalidDecisionDefinitionNameLike() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionDefinitionNameLike("%invalid%").count()).isEqualTo(0L);
        try {
            query.decisionDefinitionNameLike(null);
            Assert.fail();
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByProcessDefinitionKey() {
        String processDefinitionKey = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getKey();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.processDefinitionKey(processDefinitionKey).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.processDefinitionKey("other process").count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByProcessDefinitionId() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.processDefinitionId(processDefinitionId).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.processDefinitionId("other process").count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByProcessInstanceId() {
        this.startProcessInstanceAndEvaluateDecision();
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.processInstanceId(processInstanceId).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.processInstanceId("other process").count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByActivityId() {
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.activityIdIn(new String[]{"task"}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.activityIdIn(new String[]{"other activity"}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.activityIdIn(new String[]{"task", "other activity"}).count()).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByActivityInstanceId() {
        this.startProcessInstanceAndEvaluateDecision();
        String activityInstanceId = ((HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task").singleResult()).getId();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.activityInstanceIdIn(new String[]{activityInstanceId}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.activityInstanceIdIn(new String[]{"other activity"}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.activityInstanceIdIn(new String[]{activityInstanceId, "other activity"}).count()).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByEvaluatedBefore() {
        Date beforeEvaluated = new Date(1441612000L);
        Date evaluated = new Date(1441613000L);
        Date afterEvaluated = new Date(1441614000L);
        ClockUtil.setCurrentTime((Date)evaluated);
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.evaluatedBefore(afterEvaluated).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.evaluatedBefore(evaluated).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.evaluatedBefore(beforeEvaluated).count()).isEqualTo(0L);
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByEvaluatedAfter() {
        Date beforeEvaluated = new Date(1441612000L);
        Date evaluated = new Date(1441613000L);
        Date afterEvaluated = new Date(1441614000L);
        ClockUtil.setCurrentTime((Date)evaluated);
        this.startProcessInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.evaluatedAfter(beforeEvaluated).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.evaluatedAfter(evaluated).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.evaluatedAfter(afterEvaluated).count()).isEqualTo(0L);
        ClockUtil.reset();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByCaseDefinitionKey() {
        this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.caseDefinitionKey("case").count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionKey() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.caseDefinitionKey("invalid").count()).isEqualTo(0L);
        try {
            query.caseDefinitionKey(null);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByCaseDefinitionId() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.caseDefinitionId(caseInstance.getCaseDefinitionId()).count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByInvalidCaseDefinitionId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.caseDefinitionId("invalid").count()).isEqualTo(0L);
        try {
            query.caseDefinitionId(null);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.caseWithDecisionTask.cmmn", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByCaseInstanceId() {
        CaseInstance caseInstance = this.createCaseInstanceAndEvaluateDecision();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.caseInstanceId(caseInstance.getId()).count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByInvalidCaseInstanceId() {
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.caseInstanceId("invalid").count()).isEqualTo(0L);
        try {
            query.caseInstanceId(null);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByUserId() {
        this.evaluateDecisionWithAuthenticatedUser("demo");
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.userId("demo").count()).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testQueryByInvalidUserId() {
        this.evaluateDecisionWithAuthenticatedUser("demo");
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.userId("dem1").count()).isEqualTo(0L);
        try {
            query.userId(null);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testQueryByRootDecisionInstanceId() {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        String rootDecisionInstanceId = ((HistoricDecisionInstance)query.decisionDefinitionKey(DISH_DECISION).singleResult()).getId();
        String requiredDecisionInstanceId1 = ((HistoricDecisionInstance)query.decisionDefinitionKey("season").singleResult()).getId();
        String requiredDecisionInstanceId2 = ((HistoricDecisionInstance)query.decisionDefinitionKey("guestCount").singleResult()).getId();
        query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.rootDecisionInstanceId(rootDecisionInstanceId).count()).isEqualTo(3L);
        Assertions.assertThat((long)query.rootDecisionInstanceId(requiredDecisionInstanceId1).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.rootDecisionInstanceId(requiredDecisionInstanceId2).count()).isEqualTo(0L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testQueryByRootDecisionInstancesOnly() {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.rootDecisionInstancesOnly().count()).isEqualTo(1L);
        Assertions.assertThat((String)((HistoricDecisionInstance)query.rootDecisionInstancesOnly().singleResult()).getDecisionDefinitionKey()).isEqualTo((Object)DISH_DECISION);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testQueryByDecisionRequirementsDefinitionId() {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        DecisionRequirementsDefinition decisionRequirementsDefinition = (DecisionRequirementsDefinition)this.repositoryService.createDecisionRequirementsDefinitionQuery().singleResult();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionId("notExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionId(decisionRequirementsDefinition.getId()).count()).isEqualTo(3L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    @Test
    public void testQueryByDecisionRequirementsDefinitionKey() {
        this.decisionService.evaluateDecisionTableByKey(DISH_DECISION).variables((Map)Variables.createVariables().putValue("temperature", (Object)21).putValue("dayType", (Object)"Weekend")).evaluate();
        HistoricDecisionInstanceQuery query = this.historyService.createHistoricDecisionInstanceQuery();
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKey("notExisting").count()).isEqualTo(0L);
        Assertions.assertThat((long)query.decisionRequirementsDefinitionKey("dish").count()).isEqualTo(3L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testNativeQuery() {
        this.startProcessInstanceAndEvaluateDecision();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM " + tablePrefix + "ACT_HI_DECINST");
        Assertions.assertThat((int)nativeQuery.list().size()).isEqualTo(1);
        NativeHistoricDecisionInstanceQuery nativeQueryWithParameter = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM " + tablePrefix + "ACT_HI_DECINST H WHERE H.DEC_DEF_KEY_ = #{decisionDefinitionKey}");
        Assertions.assertThat((int)((NativeHistoricDecisionInstanceQuery)nativeQueryWithParameter.parameter("decisionDefinitionKey", (Object)DECISION_DEFINITION_KEY)).list().size()).isEqualTo(1);
        Assertions.assertThat((int)((NativeHistoricDecisionInstanceQuery)nativeQueryWithParameter.parameter("decisionDefinitionKey", (Object)"other decision")).list().size()).isEqualTo(0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testNativeCountQuery() {
        this.startProcessInstanceAndEvaluateDecision();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT count(*) FROM " + tablePrefix + "ACT_HI_DECINST");
        Assertions.assertThat((long)nativeQuery.count()).isEqualTo(1L);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.processWithBusinessRuleTask.bpmn20.xml", "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testNativeQueryPaging() {
        this.startProcessInstanceAndEvaluateDecision();
        this.startProcessInstanceAndEvaluateDecision();
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        NativeHistoricDecisionInstanceQuery nativeQuery = (NativeHistoricDecisionInstanceQuery)this.historyService.createNativeHistoricDecisionInstanceQuery().sql("SELECT * FROM " + tablePrefix + "ACT_HI_DECINST");
        Assertions.assertThat((int)nativeQuery.listPage(0, 2).size()).isEqualTo(2);
        Assertions.assertThat((int)nativeQuery.listPage(1, 1).size()).isEqualTo(1);
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecision() {
        return this.runtimeService.startProcessInstanceByKey("testProcess", (Map)this.getVariables());
    }

    protected ProcessInstance startProcessInstanceAndEvaluateDecisionWithUnderscore() {
        return this.runtimeService.startProcessInstanceByKey("testProcess_", (Map)this.getVariables());
    }

    protected CaseInstance createCaseInstanceAndEvaluateDecision() {
        return this.caseService.withCaseDefinitionByKey("case").setVariables((Map)this.getVariables()).create();
    }

    protected void evaluateDecisionWithAuthenticatedUser(String userId) {
        this.identityService.setAuthenticatedUserId(userId);
        VariableMap variables = Variables.putValue((String)"input1", (Object)"test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, (Map)variables);
    }

    protected VariableMap getVariables() {
        VariableMap variables = Variables.createVariables();
        variables.put((Object)"input1", (Object)"test");
        return variables;
    }

    protected void waitASignificantAmountOfTime() {
        DateTime now = new DateTime((Object)ClockUtil.getCurrentTime());
        ClockUtil.setCurrentTime((Date)now.plusSeconds(10).toDate());
    }
}

