/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Supplier;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.ThreadPoolJobExecutor;

public class JobExecutorWaitUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForJobExecutorToProcessAllJobs(long maxMillisToWait, long intervalMillis, JobExecutor jobExecutor, ManagementService managementService, boolean shutdown) {
        try {
            JobExecutorWaitUtils.waitForCondition(maxMillisToWait, intervalMillis, () -> !JobExecutorWaitUtils.areJobsAvailable(managementService));
        }
        finally {
            if (shutdown) {
                jobExecutor.shutdown();
            }
        }
    }

    public static void waitForJobExecutionRunnablesToFinish(long maxMillisToWait, long intervalMillis, JobExecutor jobExecutor) {
        JobExecutorWaitUtils.waitForCondition(maxMillisToWait, intervalMillis, () -> ((ThreadPoolJobExecutor)jobExecutor).getThreadPoolExecutor().getActiveCount() == 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForCondition(long maxMillisToWait, long intervalMillis, Supplier<Boolean> conditionSupplier) {
        boolean conditionFulfilled = false;
        Timer timer = new Timer();
        InterruptTask task = new InterruptTask(Thread.currentThread());
        timer.schedule((TimerTask)task, maxMillisToWait);
        try {
            while (!conditionFulfilled && !task.isTimeLimitExceeded()) {
                Thread.sleep(intervalMillis);
                conditionFulfilled = conditionSupplier.get();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            timer.cancel();
        }
        if (!conditionFulfilled) {
            throw new ProcessEngineException("time limit of " + maxMillisToWait + " was exceeded");
        }
    }

    private static boolean areJobsAvailable(ManagementService managementService) {
        return !managementService.createJobQuery().executable().list().isEmpty();
    }

    private static class InterruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InterruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

