/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.producer;

import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.impl.batch.BatchEntity;
import org.camunda.bpm.engine.impl.batch.history.HistoricBatchEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoricActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricIncidentEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricTaskInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.producer.DefaultHistoryEventProducer;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.runtime.Incident;

public class CacheAwareHistoryEventProducer
extends DefaultHistoryEventProducer {
    @Override
    protected HistoricActivityInstanceEventEntity loadActivityInstanceEventEntity(ExecutionEntity execution) {
        String activityInstanceId = execution.getActivityInstanceId();
        HistoricActivityInstanceEventEntity cachedEntity = this.findInCache(HistoricActivityInstanceEventEntity.class, activityInstanceId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newActivityInstanceEventEntity(execution);
    }

    @Override
    protected HistoricProcessInstanceEventEntity loadProcessInstanceEventEntity(ExecutionEntity execution) {
        String processInstanceId = execution.getProcessInstanceId();
        HistoricProcessInstanceEventEntity cachedEntity = this.findInCache(HistoricProcessInstanceEventEntity.class, processInstanceId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newProcessInstanceEventEntity(execution);
    }

    @Override
    protected HistoricTaskInstanceEventEntity loadTaskInstanceEvent(DelegateTask task) {
        String taskId = task.getId();
        HistoricTaskInstanceEventEntity cachedEntity = this.findInCache(HistoricTaskInstanceEventEntity.class, taskId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newTaskInstanceEventEntity(task);
    }

    @Override
    protected HistoricIncidentEventEntity loadIncidentEvent(Incident incident) {
        String incidentId = incident.getId();
        HistoricIncidentEventEntity cachedEntity = this.findInCache(HistoricIncidentEventEntity.class, incidentId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newIncidentEventEntity(incident);
    }

    @Override
    protected HistoricBatchEntity loadBatchEntity(BatchEntity batch) {
        String batchId = batch.getId();
        HistoricBatchEntity cachedEntity = this.findInCache(HistoricBatchEntity.class, batchId);
        if (cachedEntity != null) {
            return cachedEntity;
        }
        return this.newBatchEventEntity(batch);
    }

    protected <T extends HistoryEvent> T findInCache(Class<T> type, String id) {
        return (T)((HistoryEvent)Context.getCommandContext().getDbEntityManager().getCachedEntity(type, id));
    }

    @Override
    protected ProcessDefinitionEntity getProcessDefinitionEntity(String processDefinitionId) {
        CommandContext commandContext = Context.getCommandContext();
        ProcessDefinitionEntity entity = null;
        if (commandContext != null) {
            entity = commandContext.getDbEntityManager().getCachedEntity(ProcessDefinitionEntity.class, processDefinitionId);
        }
        return entity != null ? entity : super.getProcessDefinitionEntity(processDefinitionId);
    }
}

