/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.telemetry.dto;

import camundajar.impl.com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.camunda.bpm.engine.impl.telemetry.dto.ApplicationServerImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.CommandImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.DatabaseImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.JdkImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.LicenseKeyDataImpl;
import org.camunda.bpm.engine.impl.telemetry.dto.MetricImpl;
import org.camunda.bpm.engine.telemetry.Command;
import org.camunda.bpm.engine.telemetry.Internals;
import org.camunda.bpm.engine.telemetry.Metric;

public class InternalsImpl
implements Internals {
    public static final String SERIALIZED_APPLICATION_SERVER = "application-server";
    public static final String SERIALIZED_CAMUNDA_INTEGRATION = "camunda-integration";
    public static final String SERIALIZED_LICENSE_KEY = "license-key";
    public static final String SERIALIZED_DATA_COLLECTION_START_DATE = "data-collection-start-date";
    protected DatabaseImpl database;
    @SerializedName(value="application-server")
    protected ApplicationServerImpl applicationServer;
    @SerializedName(value="license-key")
    protected LicenseKeyDataImpl licenseKey;
    @SerializedName(value="camunda-integration")
    protected Set<String> camundaIntegration;
    @SerializedName(value="data-collection-start-date")
    protected Date dataCollectionStartDate;
    protected Map<String, Command> commands;
    protected Map<String, Metric> metrics;
    protected Set<String> webapps;
    protected JdkImpl jdk;

    public InternalsImpl() {
        this(null, null, null, null);
    }

    public InternalsImpl(DatabaseImpl database, ApplicationServerImpl server, LicenseKeyDataImpl licenseKey, JdkImpl jdk) {
        this.database = database;
        this.applicationServer = server;
        this.licenseKey = licenseKey;
        this.commands = new HashMap<String, Command>();
        this.jdk = jdk;
        this.camundaIntegration = new HashSet<String>();
    }

    public InternalsImpl(InternalsImpl internals) {
        this(internals.database, internals.applicationServer, internals.licenseKey, internals.jdk);
        this.camundaIntegration = internals.camundaIntegration == null ? null : new HashSet<String>(internals.getCamundaIntegration());
        this.commands = new HashMap<String, Command>(internals.getCommands());
        this.metrics = internals.metrics == null ? null : new HashMap<String, Metric>(internals.getMetrics());
        this.webapps = internals.webapps;
        this.dataCollectionStartDate = internals.dataCollectionStartDate;
    }

    @Override
    public DatabaseImpl getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseImpl database) {
        this.database = database;
    }

    @Override
    public ApplicationServerImpl getApplicationServer() {
        return this.applicationServer;
    }

    public void setApplicationServer(ApplicationServerImpl applicationServer) {
        this.applicationServer = applicationServer;
    }

    @Override
    public Date getDataCollectionStartDate() {
        return this.dataCollectionStartDate;
    }

    public void setDataCollectionStartDate(Date dataCollectionStartDate) {
        this.dataCollectionStartDate = dataCollectionStartDate;
    }

    @Override
    public Map<String, Command> getCommands() {
        return this.commands;
    }

    public void setCommands(Map<String, Command> commands) {
        this.commands = commands;
    }

    public void putCommand(String commandName, int count) {
        if (this.commands == null) {
            this.commands = new HashMap<String, Command>();
        }
        this.commands.put(commandName, new CommandImpl(count));
    }

    @Override
    public Map<String, Metric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Map<String, Metric> metrics) {
        this.metrics = metrics;
    }

    public void putMetric(String metricName, int count) {
        if (this.metrics == null) {
            this.metrics = new HashMap<String, Metric>();
        }
        this.metrics.put(metricName, new MetricImpl(count));
    }

    public void mergeDynamicData(InternalsImpl other) {
        this.commands = other.commands;
        this.metrics = other.metrics;
    }

    @Override
    public JdkImpl getJdk() {
        return this.jdk;
    }

    public void setJdk(JdkImpl jdk) {
        this.jdk = jdk;
    }

    @Override
    public Set<String> getCamundaIntegration() {
        return this.camundaIntegration;
    }

    public void setCamundaIntegration(Set<String> camundaIntegration) {
        this.camundaIntegration = camundaIntegration;
    }

    @Override
    public LicenseKeyDataImpl getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(LicenseKeyDataImpl licenseKey) {
        this.licenseKey = licenseKey;
    }

    @Override
    public Set<String> getWebapps() {
        return this.webapps;
    }

    public void setWebapps(Set<String> webapps) {
        this.webapps = webapps;
    }
}

