/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.async;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.task.TaskQuery;
import org.camunda.bpm.engine.test.Deployment;

public class AsyncAfterTest
extends PluggableProcessEngineTestCase {
    public void testTransitionIdRequired() {
        try {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/bpmn/async/AsyncAfterTest.testTransitionIdRequired.bpmn20.xml").deploy();
            AsyncAfterTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            this.assertTextPresent("Sequence flow with sourceRef='service' must have an id, activity with id 'service' uses 'asyncAfter'.", e.getMessage());
        }
    }

    @Deployment
    public void testAsyncAfterServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeServiceTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotBehaviorInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterServiceTaskMultipleTransitions() {
        HashMap<String, String> varMap = new HashMap<String, String>();
        varMap.put("flowToTake", "flow2");
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
        this.runtimeService.signal(pi.getId());
        varMap = new HashMap();
        varMap.put("flowToTake", "flow3");
        pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
    }

    @Deployment
    public void testAsyncAfterServiceTaskMultipleTransitionsConcurrent() {
        HashMap varMap = new HashMap();
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess", varMap);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        List jobs = this.managementService.createJobQuery().list();
        AsyncAfterTest.assertEquals((int)2, (int)jobs.size());
        this.managementService.executeJob(((Job)jobs.get(0)).getId());
        this.managementService.executeJob(((Job)jobs.get(1)).getId());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow2").singleResult());
        AsyncAfterTest.assertNotNull((Object)this.runtimeService.createExecutionQuery().activityId("taskAfterFlow3").singleResult());
    }

    @Deployment
    public void testAsyncAfterWithoutTransition() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "process-listenerEndInvoked"));
        this.managementService.executeJob(continuationJob.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterInNestedWithoutTransition() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertBehaviorInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job continuationJob = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)continuationJob);
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(pi.getId(), "subprocess-listenerEndInvoked"));
        this.managementService.executeJob(continuationJob.getId());
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(pi.getId(), "subprocess-listenerEndInvoked")));
    }

    @Deployment
    public void testAsyncAfterManualTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testManualTask");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeManualTask() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testManualTask");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterIntermediateCatchEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testIntermediateCatchEvent");
        this.runtimeService.correlateMessage("testMessage1");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeIntermediateCatchEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testIntermediateCatchEvent");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.executeAvailableJobs();
        this.runtimeService.correlateMessage("testMessage1");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterIntermediateThrowEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testIntermediateThrowEvent");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeIntermediateThrowEvent() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testIntermediateThrowEvent");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertProcessEnded(pi.getId());
    }

    @Deployment
    public void testAsyncAfterInclusiveGateway() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testInclusiveGateway");
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        AsyncAfterTest.assertEquals((long)2L, (long)this.managementService.createJobQuery().active().count());
        this.executeAvailableJobs();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        AsyncAfterTest.assertEquals((long)2L, (long)taskQuery.active().count());
        List tasks = taskQuery.active().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getProcessInstanceId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeInclusiveGateway() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testInclusiveGateway");
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        List jobs = this.managementService.createJobQuery().active().list();
        AsyncAfterTest.assertEquals((int)2, (int)jobs.size());
    }

    @Deployment
    public void testAsyncAfterExclusiveGateway() {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("flow", false);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExclusiveGateway", variables);
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        AsyncAfterTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().active().count());
        this.executeAvailableJobs();
        TaskQuery taskQuery = this.taskService.createTaskQuery();
        AsyncAfterTest.assertEquals((long)1L, (long)taskQuery.active().count());
        List tasks = taskQuery.active().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.assertProcessEnded(pi.getProcessInstanceId());
    }

    @Deployment
    public void testAsyncAfterAndBeforeExclusiveGateway() {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("flow", false);
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testExclusiveGateway", variables);
        this.assertNotListenerStartInvoked((Execution)pi);
        this.assertNotListenerEndInvoked((Execution)pi);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.managementService.executeJob(job.getId());
        this.assertListenerStartInvoked((Execution)pi);
        this.assertListenerEndInvoked((Execution)pi);
        AsyncAfterTest.assertEquals((long)1L, (long)this.managementService.createJobQuery().active().count());
    }

    @Deployment
    public void testAsyncAfterWithExecutionListener() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)job);
        this.assertNotListenerTakeInvoked((Execution)processInstance);
        this.managementService.executeJob(job.getId());
        job = (Job)this.managementService.createJobQuery().singleResult();
        AsyncAfterTest.assertNull((Object)job);
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        AsyncAfterTest.assertNotNull((Object)task);
        this.assertListenerTakeInvoked((Execution)processInstance);
    }

    protected void assertListenerStartInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "listenerStartInvoked")));
    }

    protected void assertListenerTakeInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "listenerTakeInvoked")));
    }

    protected void assertListenerEndInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "listenerEndInvoked")));
    }

    protected void assertBehaviorInvoked(Execution e) {
        AsyncAfterTest.assertTrue((boolean)((Boolean)this.runtimeService.getVariable(e.getId(), "behaviorInvoked")));
    }

    protected void assertNotListenerStartInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "listenerStartInvoked"));
    }

    protected void assertNotListenerTakeInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "listenerTakeInvoked"));
    }

    protected void assertNotListenerEndInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "listenerEndInvoked"));
    }

    protected void assertNotBehaviorInvoked(Execution e) {
        AsyncAfterTest.assertNull((Object)this.runtimeService.getVariable(e.getId(), "behaviorInvoked"));
    }
}

