/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.operation;

import java.util.ArrayList;
import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionImpl;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.model.CaseDefinitionBuilder;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.test.PvmTestCase;
import org.camunda.bpm.engine.test.cmmn.operation.CaseExecutionStateTransitionCollector;
import org.camunda.bpm.engine.test.cmmn.operation.TaskWaitState;

public class CaseExecutionCompletionTest
extends PvmTestCase {
    public void testCompleteActiveTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        taskA.complete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertTrue((boolean)((CaseExecutionImpl)caseInstance).getCaseExecutions().isEmpty());
    }

    public void testManualCompleteActiveTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        taskA.manualComplete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertTrue((boolean)((CaseExecutionImpl)caseInstance).getCaseExecutions().isEmpty());
    }

    public void testCompleteEnabledTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        try {
            taskA.complete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete an enabled task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        }
    }

    public void testManualCompleteEnabledTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        try {
            taskA.manualComplete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete an enabled task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        }
    }

    public void testCompleteAlreadyCompletedTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        taskA.complete();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        try {
            taskA.complete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete an already completed task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        }
    }

    public void testManualCompleteAlreadyCompletedTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        taskA.complete();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        try {
            taskA.manualComplete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete an already completed task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        }
    }

    public void testCompleteTerminatedTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        taskA.terminate();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isTerminated());
        try {
            taskA.complete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete an already completed task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)taskA.isTerminated());
        }
    }

    public void testManualCompleteTerminatedTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        taskA.terminate();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isTerminated());
        try {
            taskA.manualComplete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete an already completed task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)taskA.isTerminated());
        }
    }

    public void testDisableTaskShouldCompleteCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("disable", (CaseExecutionListener)stateTransitionCollector).listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        taskA.disable();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("enabled --disable(A)--> disabled");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isDisabled());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertTrue((boolean)((CaseExecutionImpl)caseInstance).getCaseExecutions().isEmpty());
    }

    public void testTerminateTaskShouldCompleteCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("terminate", (CaseExecutionListener)stateTransitionCollector).listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isActive());
        taskA.terminate();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --terminate(A)--> terminated");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isTerminated());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertTrue((boolean)((CaseExecutionImpl)caseInstance).getCaseExecutions().isEmpty());
    }

    public void testCompleteActiveCaseInstanceWithEnabledTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        try {
            caseInstance.complete();
        }
        catch (Exception e) {
            CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isActive());
            CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("A"));
        }
    }

    public void testManualCompleteActiveCaseInstanceWithEnabledTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        caseInstance.manualComplete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
    }

    public void testCompleteActiveCaseInstanceWithActiveTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isActive());
        try {
            caseInstance.complete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete a case instance containing an active task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isActive());
            CaseExecutionCompletionTest.assertFalse((boolean)caseInstance.isCompleted());
        }
    }

    public void testManualCompleteActiveCaseInstanceWithActiveTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isActive());
        try {
            caseInstance.manualComplete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete a case instance containing an active task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isActive());
            CaseExecutionCompletionTest.assertFalse((boolean)caseInstance.isCompleted());
        }
    }

    public void testCompleteAlreadyCompletedCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        caseInstance.manualComplete();
        try {
            caseInstance.complete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete an already completed case instance.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        }
    }

    public void testManualCompleteAlreadyCompletedCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isEnabled());
        caseInstance.manualComplete();
        try {
            caseInstance.manualComplete();
            CaseExecutionCompletionTest.fail((String)"It should not be possible to complete an already completed case instance.");
        }
        catch (CaseIllegalStateTransitionException e) {
            CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        }
    }

    public void testCompleteOnlyTaskA() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskB.manualStart();
        taskA.complete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)taskB.isActive());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isActive());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("B"));
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("X"));
        CaseExecutionCompletionTest.assertEquals((int)1, (int)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertEquals((int)1, (int)((CaseExecutionImpl)stageX).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isActive());
    }

    public void testManualCompleteOnlyTaskA() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskB.manualStart();
        taskA.manualComplete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)taskB.isActive());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isActive());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("B"));
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("X"));
        CaseExecutionCompletionTest.assertEquals((int)1, (int)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertEquals((int)1, (int)((CaseExecutionImpl)stageX).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isActive());
    }

    public void testDisableOnlyTaskA() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskB.manualStart();
        taskA.disable();
        CaseExecutionCompletionTest.assertTrue((boolean)stateTransitionCollector.stateTransitions.isEmpty());
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isDisabled());
        CaseExecutionCompletionTest.assertTrue((boolean)taskB.isActive());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isActive());
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("B"));
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("X"));
        CaseExecutionCompletionTest.assertEquals((int)1, (int)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertEquals((int)2, (int)((CaseExecutionImpl)stageX).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isActive());
    }

    public void testTerminateOnlyTaskA() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskB.manualStart();
        taskA.terminate();
        CaseExecutionCompletionTest.assertTrue((boolean)stateTransitionCollector.stateTransitions.isEmpty());
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isTerminated());
        CaseExecutionCompletionTest.assertTrue((boolean)taskB.isActive());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isActive());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("B"));
        CaseExecutionCompletionTest.assertNotNull((Object)caseInstance.findCaseExecution("X"));
        CaseExecutionCompletionTest.assertEquals((int)1, (int)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertEquals((int)1, (int)((CaseExecutionImpl)stageX).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isActive());
    }

    public void testCompleteTaskAAndTaskB() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskB.manualStart();
        taskA.complete();
        taskB.complete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        expectedStateTransitions.add("active --complete(B)--> completed");
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)taskB.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("B"));
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("X"));
        CaseExecutionCompletionTest.assertEquals((int)0, (int)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    public void testManualCompleteTaskAAndTaskB() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskB.manualStart();
        taskA.manualComplete();
        taskB.manualComplete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        expectedStateTransitions.add("active --complete(B)--> completed");
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)taskB.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("B"));
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("X"));
        CaseExecutionCompletionTest.assertEquals((int)0, (int)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    public void testDisableTaskAAndTaskB() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.disable();
        taskB.disable();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isDisabled());
        CaseExecutionCompletionTest.assertTrue((boolean)taskB.isDisabled());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("B"));
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("X"));
        CaseExecutionCompletionTest.assertEquals((int)0, (int)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    public void testTerminateTaskAAndTaskB() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualStart();
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskB.manualStart();
        taskA.terminate();
        taskB.terminate();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        CaseExecutionCompletionTest.assertTrue((boolean)taskA.isTerminated());
        CaseExecutionCompletionTest.assertTrue((boolean)taskB.isTerminated());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isCompleted());
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("A"));
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("B"));
        CaseExecutionCompletionTest.assertNull((Object)caseInstance.findCaseExecution("X"));
        CaseExecutionCompletionTest.assertEquals((int)0, (int)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    public void testAutoCompletionCaseInstanceWithoutChildren() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
    }

    public void testAutoCompletionStageWithoutChildren() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        CaseExecutionCompletionTest.assertTrue((boolean)caseInstance.isCompleted());
        CaseExecutionCompletionTest.assertTrue((boolean)stageX.isCompleted());
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        CaseExecutionCompletionTest.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
    }
}

