/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Date;
import java.util.List;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManagerFactory;
import org.camunda.bpm.engine.impl.history.event.HistoricProcessInstanceEventEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;

public class DbDeadlockTests
extends ConcurrencyTestCase {
    private ConcurrencyTestCase.ThreadControl thread1;
    private ConcurrencyTestCase.ThreadControl thread2;

    public void testTransactionIsolation() {
        this.thread1 = this.executeControllableCommand(new TestCommand("p1"));
        this.thread1.waitForSync();
        this.thread2 = this.executeControllableCommand(new TestCommand("p2"));
        this.thread2.waitForSync();
        this.thread2.makeContinue();
        this.thread1.makeContinue();
        this.thread2.waitForSync();
        this.thread1.waitForSync();
    }

    protected void tearDown() throws Exception {
        this.thread2.waitUntilDone();
        this.thread1.waitUntilDone();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                List list = commandContext.getDbEntityManager().createHistoricProcessInstanceQuery().list();
                for (HistoricProcessInstance historicProcessInstance : list) {
                    commandContext.getDbEntityManager().delete(HistoricProcessInstanceEventEntity.class, "deleteHistoricProcessInstance", (Object)historicProcessInstance.getId());
                }
                return null;
            }
        });
    }

    static class TestCommand
    extends ConcurrencyTestCase.ControllableCommand<Void> {
        protected String id;

        public TestCommand(String id) {
            this.id = id;
        }

        public Void execute(CommandContext commandContext) {
            DbEntityManager dbEntityManger = commandContext.getDbEntityManager();
            DbEntityManagerFactory dbEntityManagerFactory = new DbEntityManagerFactory(Context.getProcessEngineConfiguration().getIdGenerator());
            HistoricProcessInstanceEventEntity hpi = new HistoricProcessInstanceEventEntity();
            hpi.setId(this.id);
            hpi.setProcessInstanceId(this.id);
            hpi.setProcessDefinitionId("someProcDefId");
            hpi.setStartTime(new Date());
            dbEntityManger.insert((DbEntity)hpi);
            dbEntityManger.flush();
            this.monitor.sync();
            DbEntityManager dbEntityManager = dbEntityManagerFactory.openSession();
            dbEntityManager.createHistoricProcessInstanceQuery().list();
            this.monitor.sync();
            return null;
        }
    }
}

