/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.examples.bpmn.mail;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.test.Deployment;
import org.subethamail.wiser.Wiser;
import org.subethamail.wiser.WiserMessage;

public class EmailSendTaskTest
extends PluggableProcessEngineTestCase {
    private Wiser wiser;

    protected void setUp() throws Exception {
        super.setUp();
        boolean serverUpAndRunning = false;
        while (!serverUpAndRunning) {
            this.wiser = new Wiser();
            this.wiser.setPort(this.processEngineConfiguration.getMailServerPort());
            try {
                this.wiser.start();
                serverUpAndRunning = true;
            }
            catch (RuntimeException e) {
                if (!e.getMessage().toLowerCase().contains("BindException")) continue;
                Thread.sleep(250L);
            }
        }
    }

    protected void tearDown() throws Exception {
        this.wiser.stop();
        super.tearDown();
    }

    @Deployment
    public void testSendEmail() throws Exception {
        String from = "ordershipping@activiti.org";
        boolean male = true;
        String recipientName = "John Doe";
        String recipient = "johndoe@alfresco.com";
        Date now = new Date();
        String orderId = "123456";
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("sender", from);
        vars.put("recipient", recipient);
        vars.put("recipientName", recipientName);
        vars.put("male", male);
        vars.put("now", now);
        vars.put("orderId", orderId);
        this.runtimeService.startProcessInstanceByKey("sendMailExample", vars);
        List messages = this.wiser.getMessages();
        EmailSendTaskTest.assertEquals((int)1, (int)messages.size());
        WiserMessage message = (WiserMessage)messages.get(0);
        MimeMessage mimeMessage = message.getMimeMessage();
        EmailSendTaskTest.assertEquals((String)("Your order " + orderId + " has been shipped"), (String)mimeMessage.getHeader("Subject", null));
        EmailSendTaskTest.assertEquals((String)("\"" + from + "\" <" + from.toString() + ">"), (String)mimeMessage.getHeader("From", null));
        EmailSendTaskTest.assertTrue((boolean)mimeMessage.getHeader("To", null).contains(recipient));
    }
}

