/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.incident;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class IncidentTest
extends PluggableProcessEngineTestCase {
    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testShouldCreateOneIncident() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)incident);
        IncidentTest.assertNotNull((Object)incident.getId());
        IncidentTest.assertNotNull((Object)incident.getIncidentTimestamp());
        IncidentTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        IncidentTest.assertEquals((String)"Exception expected.", (String)incident.getIncidentMessage());
        IncidentTest.assertEquals((String)processInstance.getId(), (String)incident.getExecutionId());
        IncidentTest.assertEquals((String)"theServiceTask", (String)incident.getActivityId());
        IncidentTest.assertEquals((String)processInstance.getId(), (String)incident.getProcessInstanceId());
        IncidentTest.assertEquals((String)processInstance.getProcessDefinitionId(), (String)incident.getProcessDefinitionId());
        IncidentTest.assertEquals((String)incident.getId(), (String)incident.getCauseIncidentId());
        IncidentTest.assertEquals((String)incident.getId(), (String)incident.getRootCauseIncidentId());
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)job);
        IncidentTest.assertEquals((String)job.getId(), (String)incident.getConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testShouldCreateOneIncidentAfterSetRetries() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        IncidentTest.assertFalse((boolean)incidents.isEmpty());
        IncidentTest.assertTrue((incidents.size() == 1 ? 1 : 0) != 0);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)job);
        this.managementService.setJobRetries(job.getId(), 1);
        this.executeAvailableJobs();
        incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        IncidentTest.assertFalse((boolean)incidents.isEmpty());
        IncidentTest.assertTrue((incidents.size() == 1 ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testShouldCreateOneIncidentAfterExecuteJob() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        IncidentTest.assertFalse((boolean)incidents.isEmpty());
        IncidentTest.assertTrue((incidents.size() == 1 ? 1 : 0) != 0);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)job);
        try {
            this.managementService.executeJob(job.getId());
            IncidentTest.fail((String)"Exception was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        IncidentTest.assertFalse((boolean)incidents.isEmpty());
        IncidentTest.assertTrue((incidents.size() == 1 ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncidentForNestedExecution.bpmn"})
    public void testShouldCreateOneIncidentForNestedExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcessWithNestedExecutions");
        this.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)incident);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)job);
        String executionIdOfNestedFailingExecution = job.getExecutionId();
        IncidentTest.assertFalse((processInstance.getId() == executionIdOfNestedFailingExecution ? 1 : 0) != 0);
        IncidentTest.assertNotNull((Object)incident.getId());
        IncidentTest.assertNotNull((Object)incident.getIncidentTimestamp());
        IncidentTest.assertEquals((String)"failedJob", (String)incident.getIncidentType());
        IncidentTest.assertEquals((String)"Exception expected.", (String)incident.getIncidentMessage());
        IncidentTest.assertEquals((String)executionIdOfNestedFailingExecution, (String)incident.getExecutionId());
        IncidentTest.assertEquals((String)"theServiceTask", (String)incident.getActivityId());
        IncidentTest.assertEquals((String)processInstance.getId(), (String)incident.getProcessInstanceId());
        IncidentTest.assertEquals((String)incident.getId(), (String)incident.getCauseIncidentId());
        IncidentTest.assertEquals((String)incident.getId(), (String)incident.getRootCauseIncidentId());
        IncidentTest.assertEquals((String)job.getId(), (String)incident.getConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateRecursiveIncidents.bpmn", "org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testShouldCreateRecursiveIncidents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callFailingProcess");
        this.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().list();
        IncidentTest.assertFalse((boolean)incidents.isEmpty());
        IncidentTest.assertTrue((incidents.size() == 2 ? 1 : 0) != 0);
        ProcessInstance failingProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("failingProcess").singleResult();
        IncidentTest.assertNotNull((Object)failingProcess);
        ProcessInstance callProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("callFailingProcess").singleResult();
        IncidentTest.assertNotNull((Object)callProcess);
        Incident causeIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(failingProcess.getProcessDefinitionId()).singleResult();
        IncidentTest.assertNotNull((Object)causeIncident);
        Job job = (Job)this.managementService.createJobQuery().executionId(causeIncident.getExecutionId()).singleResult();
        IncidentTest.assertNotNull((Object)job);
        IncidentTest.assertNotNull((Object)causeIncident.getId());
        IncidentTest.assertNotNull((Object)causeIncident.getIncidentTimestamp());
        IncidentTest.assertEquals((String)"failedJob", (String)causeIncident.getIncidentType());
        IncidentTest.assertEquals((String)"Exception expected.", (String)causeIncident.getIncidentMessage());
        IncidentTest.assertEquals((String)job.getExecutionId(), (String)causeIncident.getExecutionId());
        IncidentTest.assertEquals((String)"theServiceTask", (String)causeIncident.getActivityId());
        IncidentTest.assertEquals((String)failingProcess.getId(), (String)causeIncident.getProcessInstanceId());
        IncidentTest.assertEquals((String)causeIncident.getId(), (String)causeIncident.getCauseIncidentId());
        IncidentTest.assertEquals((String)causeIncident.getId(), (String)causeIncident.getRootCauseIncidentId());
        IncidentTest.assertEquals((String)job.getId(), (String)causeIncident.getConfiguration());
        Incident recursiveCreatedIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(callProcess.getProcessDefinitionId()).singleResult();
        IncidentTest.assertNotNull((Object)recursiveCreatedIncident);
        Execution theCallActivityExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("theCallActivity").singleResult();
        IncidentTest.assertNotNull((Object)theCallActivityExecution);
        IncidentTest.assertNotNull((Object)recursiveCreatedIncident.getId());
        IncidentTest.assertNotNull((Object)recursiveCreatedIncident.getIncidentTimestamp());
        IncidentTest.assertEquals((String)"failedJob", (String)recursiveCreatedIncident.getIncidentType());
        IncidentTest.assertNull((Object)recursiveCreatedIncident.getIncidentMessage());
        IncidentTest.assertEquals((String)theCallActivityExecution.getId(), (String)recursiveCreatedIncident.getExecutionId());
        IncidentTest.assertEquals((String)"theCallActivity", (String)recursiveCreatedIncident.getActivityId());
        IncidentTest.assertEquals((String)processInstance.getId(), (String)recursiveCreatedIncident.getProcessInstanceId());
        IncidentTest.assertEquals((String)causeIncident.getId(), (String)recursiveCreatedIncident.getCauseIncidentId());
        IncidentTest.assertEquals((String)causeIncident.getId(), (String)recursiveCreatedIncident.getRootCauseIncidentId());
        IncidentTest.assertNull((Object)recursiveCreatedIncident.getConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateRecursiveIncidentsForNestedCallActivity.bpmn", "org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateRecursiveIncidents.bpmn", "org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testShouldCreateRecursiveIncidentsForNestedCallActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingFailingCallActivity");
        this.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().list();
        IncidentTest.assertFalse((boolean)incidents.isEmpty());
        IncidentTest.assertTrue((incidents.size() == 3 ? 1 : 0) != 0);
        ProcessInstance failingProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("failingProcess").singleResult();
        IncidentTest.assertNotNull((Object)failingProcess);
        Incident rootCauseIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(failingProcess.getProcessDefinitionId()).singleResult();
        IncidentTest.assertNotNull((Object)rootCauseIncident);
        Job job = (Job)this.managementService.createJobQuery().executionId(rootCauseIncident.getExecutionId()).singleResult();
        IncidentTest.assertNotNull((Object)job);
        IncidentTest.assertNotNull((Object)rootCauseIncident.getId());
        IncidentTest.assertNotNull((Object)rootCauseIncident.getIncidentTimestamp());
        IncidentTest.assertEquals((String)"failedJob", (String)rootCauseIncident.getIncidentType());
        IncidentTest.assertEquals((String)"Exception expected.", (String)rootCauseIncident.getIncidentMessage());
        IncidentTest.assertEquals((String)job.getExecutionId(), (String)rootCauseIncident.getExecutionId());
        IncidentTest.assertEquals((String)"theServiceTask", (String)rootCauseIncident.getActivityId());
        IncidentTest.assertEquals((String)failingProcess.getId(), (String)rootCauseIncident.getProcessInstanceId());
        IncidentTest.assertEquals((String)rootCauseIncident.getId(), (String)rootCauseIncident.getCauseIncidentId());
        IncidentTest.assertEquals((String)rootCauseIncident.getId(), (String)rootCauseIncident.getRootCauseIncidentId());
        IncidentTest.assertEquals((String)job.getId(), (String)rootCauseIncident.getConfiguration());
        ProcessInstance callFailingProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("callFailingProcess").singleResult();
        IncidentTest.assertNotNull((Object)callFailingProcess);
        Incident causeIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(callFailingProcess.getProcessDefinitionId()).singleResult();
        IncidentTest.assertNotNull((Object)causeIncident);
        Execution theCallActivityExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("theCallActivity").singleResult();
        IncidentTest.assertNotNull((Object)theCallActivityExecution);
        IncidentTest.assertNotNull((Object)causeIncident.getId());
        IncidentTest.assertNotNull((Object)causeIncident.getIncidentTimestamp());
        IncidentTest.assertEquals((String)"failedJob", (String)causeIncident.getIncidentType());
        IncidentTest.assertNull((Object)causeIncident.getIncidentMessage());
        IncidentTest.assertEquals((String)theCallActivityExecution.getId(), (String)causeIncident.getExecutionId());
        IncidentTest.assertEquals((String)"theCallActivity", (String)causeIncident.getActivityId());
        IncidentTest.assertEquals((String)callFailingProcess.getId(), (String)causeIncident.getProcessInstanceId());
        IncidentTest.assertEquals((String)rootCauseIncident.getId(), (String)causeIncident.getCauseIncidentId());
        IncidentTest.assertEquals((String)rootCauseIncident.getId(), (String)causeIncident.getRootCauseIncidentId());
        IncidentTest.assertNull((Object)causeIncident.getConfiguration());
        Incident topLevelIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        IncidentTest.assertNotNull((Object)topLevelIncident);
        Execution theCallingCallActivity = (Execution)this.runtimeService.createExecutionQuery().activityId("theCallingCallActivity").singleResult();
        IncidentTest.assertNotNull((Object)theCallingCallActivity);
        IncidentTest.assertNotNull((Object)topLevelIncident.getId());
        IncidentTest.assertNotNull((Object)topLevelIncident.getIncidentTimestamp());
        IncidentTest.assertEquals((String)"failedJob", (String)topLevelIncident.getIncidentType());
        IncidentTest.assertNull((Object)topLevelIncident.getIncidentMessage());
        IncidentTest.assertEquals((String)theCallingCallActivity.getId(), (String)topLevelIncident.getExecutionId());
        IncidentTest.assertEquals((String)"theCallingCallActivity", (String)topLevelIncident.getActivityId());
        IncidentTest.assertEquals((String)processInstance.getId(), (String)topLevelIncident.getProcessInstanceId());
        IncidentTest.assertEquals((String)causeIncident.getId(), (String)topLevelIncident.getCauseIncidentId());
        IncidentTest.assertEquals((String)rootCauseIncident.getId(), (String)topLevelIncident.getRootCauseIncidentId());
        IncidentTest.assertNull((Object)topLevelIncident.getConfiguration());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testShouldDeleteIncidentAfterJobHasBeenDeleted() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)job);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)incident);
        this.managementService.deleteJob(job.getId());
        incident = (Incident)this.runtimeService.createIncidentQuery().incidentId(incident.getId()).singleResult();
        IncidentTest.assertNull((Object)incident);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldDeleteIncidentAfterJobWasSuccessfully.bpmn"})
    public void testShouldDeleteIncidentAfterJobWasSuccessfully() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)job);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNotNull((Object)incident);
        this.runtimeService.setVariable(processInstance.getId(), "fail", (Object)new Boolean(false));
        this.managementService.setJobRetries(job.getId(), 1);
        this.executeAvailableJobs();
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertTrue((boolean)(processInstance instanceof ExecutionEntity));
        ExecutionEntity exec = (ExecutionEntity)processInstance;
        IncidentTest.assertEquals((String)"theUserTask", (String)exec.getActivityId());
        incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        IncidentTest.assertNull((Object)incident);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateIncidentOnFailedStartTimerEvent.bpmn"})
    public void testShouldCreateIncidentOnFailedStartTimerEvent() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        IncidentTest.assertEquals((long)1L, (long)jobQuery.count());
        this.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        IncidentTest.assertNotNull((Object)job);
        IncidentTest.assertEquals((int)0, (int)job.getRetries());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().configuration(job.getId()).singleResult();
        IncidentTest.assertNotNull((Object)incident);
        this.managementService.deleteJob(job.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testDoNotCreateNewIncident() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        IncidentQuery query = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId());
        Incident incident = (Incident)query.singleResult();
        IncidentTest.assertNotNull((Object)incident);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        Incident tmp = (Incident)query.singleResult();
        IncidentTest.assertEquals((String)incident.getId(), (String)tmp.getId());
        this.executeAvailableJobs();
        IncidentTest.assertEquals((long)1L, (long)query.count());
        tmp = (Incident)query.singleResult();
        IncidentTest.assertEquals((String)incident.getId(), (String)tmp.getId());
    }

    @Deployment
    public void testIncidentUpdateAfterCompaction() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        IncidentTest.assertNotNull((Object)incident);
        IncidentTest.assertNotSame((Object)processInstanceId, (Object)incident.getExecutionId());
        this.runtimeService.correlateMessage("Message");
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        IncidentTest.assertNotNull((Object)incident);
        IncidentTest.assertEquals((String)processInstanceId, (String)incident.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/incident/IncidentTest.testShouldCreateOneIncident.bpmn"})
    public void testDoNotSetNegativeRetries() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        IncidentTest.assertEquals((int)0, (int)job.getRetries());
        IncidentTest.assertEquals((long)1L, (long)this.runtimeService.createIncidentQuery().count());
        final JobEntity jobEntity = (JobEntity)job;
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                jobEntity.setRetries(-100);
                return null;
            }
        });
        IncidentTest.assertEquals((int)0, (int)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
            IncidentTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        IncidentTest.assertEquals((int)0, (int)job.getRetries());
        IncidentTest.assertEquals((long)1L, (long)this.runtimeService.createIncidentQuery().count());
        try {
            this.managementService.setJobRetries(job.getId(), -200);
            IncidentTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.managementService.setJobRetriesByJobDefinitionId(job.getJobDefinitionId(), -300);
            IncidentTest.fail((String)"Exception expected");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
    }
}

