/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.history;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricFormProperty;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.impl.cmd.SubmitStartFormCmd;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.ResourceProcessEngineTestCase;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.runtime.DummySerializable;
import org.camunda.bpm.engine.test.api.runtime.util.CustomSerializable;
import org.camunda.bpm.engine.test.api.runtime.util.FailingSerializable;
import org.camunda.bpm.engine.test.history.SerializableVariable;
import org.camunda.bpm.engine.variable.type.ValueType;
import org.camunda.bpm.engine.variable.value.ObjectValue;
import org.junit.Assert;

public class FullHistoryTest
extends ResourceProcessEngineTestCase {
    public FullHistoryTest() {
        super("org/camunda/bpm/engine/test/standalone/history/fullhistory.camunda.cfg.xml");
    }

    protected void closeDownProcessEngine() {
        this.processEngine.close();
        super.closeDownProcessEngine();
    }

    @Deployment
    public void testVariableUpdates() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("number", "one");
        variables.put("character", "a");
        variables.put("bytes", ":-(".getBytes());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveTask", variables);
        this.runtimeService.setVariable(processInstance.getId(), "number", (Object)"two");
        this.runtimeService.setVariable(processInstance.getId(), "bytes", (Object)":-)".getBytes());
        HistoricActivityInstance historicStartEvent = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("theStart").singleResult();
        FullHistoryTest.assertNotNull((Object)historicStartEvent);
        HistoricActivityInstance waitStateActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("waitState").singleResult();
        FullHistoryTest.assertNotNull((Object)waitStateActivity);
        HistoricActivityInstance serviceTaskActivity = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).activityId("serviceTask").singleResult();
        FullHistoryTest.assertNotNull((Object)serviceTaskActivity);
        List historicDetails = ((HistoricDetailQuery)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().orderByVariableName().asc()).orderByVariableRevision().asc()).list();
        FullHistoryTest.assertEquals((int)10, (int)historicDetails.size());
        HistoricVariableUpdate historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(0);
        FullHistoryTest.assertEquals((String)"bytes", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((String)":-(", (String)new String((byte[])historicVariableUpdate.getValue()));
        FullHistoryTest.assertEquals((int)0, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)historicStartEvent.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(1);
        FullHistoryTest.assertEquals((String)"bytes", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((String)":-)", (String)new String((byte[])historicVariableUpdate.getValue()));
        FullHistoryTest.assertEquals((int)1, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)waitStateActivity.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(2);
        FullHistoryTest.assertEquals((String)"character", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)"a", (Object)historicVariableUpdate.getValue());
        FullHistoryTest.assertEquals((int)0, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)historicStartEvent.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(3);
        FullHistoryTest.assertEquals((String)"number", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)"one", (Object)historicVariableUpdate.getValue());
        FullHistoryTest.assertEquals((int)0, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)historicStartEvent.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(4);
        FullHistoryTest.assertEquals((String)"number", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)"two", (Object)historicVariableUpdate.getValue());
        FullHistoryTest.assertEquals((int)1, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)waitStateActivity.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(5);
        FullHistoryTest.assertEquals((String)"zVar1", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)"Event: start", (Object)historicVariableUpdate.getValue());
        FullHistoryTest.assertEquals((int)0, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)historicStartEvent.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(6);
        FullHistoryTest.assertEquals((String)"zVar2", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)"Event: take", (Object)historicVariableUpdate.getValue());
        FullHistoryTest.assertEquals((int)0, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertNull((Object)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(7);
        FullHistoryTest.assertEquals((String)"zVar3", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)"Event: start", (Object)historicVariableUpdate.getValue());
        FullHistoryTest.assertEquals((int)0, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)serviceTaskActivity.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(8);
        FullHistoryTest.assertEquals((String)"zVar4", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)"Event: end", (Object)historicVariableUpdate.getValue());
        FullHistoryTest.assertEquals((int)0, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)serviceTaskActivity.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        historicVariableUpdate = (HistoricVariableUpdate)historicDetails.get(9);
        FullHistoryTest.assertEquals((String)"zzz", (String)historicVariableUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)123456789L, (Object)historicVariableUpdate.getValue());
        FullHistoryTest.assertEquals((int)0, (int)historicVariableUpdate.getRevision());
        FullHistoryTest.assertEquals((String)serviceTaskActivity.getId(), (String)historicVariableUpdate.getActivityInstanceId());
        this.runtimeService.signal(processInstance.getId());
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicProcessVariableQuery = (HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc();
        FullHistoryTest.assertEquals((long)8L, (long)historicProcessVariableQuery.count());
        List historicVariables = historicProcessVariableQuery.list();
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)historicVariables.get(0);
        FullHistoryTest.assertEquals((String)"bytes", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((String)":-)", (String)new String((byte[])historicVariable.getValue()));
        historicVariable = (HistoricVariableInstance)historicVariables.get(1);
        FullHistoryTest.assertEquals((String)"character", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"a", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(2);
        FullHistoryTest.assertEquals((String)"number", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"two", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(3);
        FullHistoryTest.assertEquals((String)"zVar1", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"Event: start", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(4);
        FullHistoryTest.assertEquals((String)"zVar2", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"Event: take", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(5);
        FullHistoryTest.assertEquals((String)"zVar3", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"Event: start", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(6);
        FullHistoryTest.assertEquals((String)"zVar4", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"Event: end", (Object)historicVariable.getValue());
        historicVariable = (HistoricVariableInstance)historicVariables.get(7);
        FullHistoryTest.assertEquals((String)"zzz", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)123456789L, (Object)historicVariable.getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testVariableUpdates.bpmn20.xml"})
    public void testHistoricVariableInstanceQuery() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("process", "one");
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("receiveTask", variables);
        this.runtimeService.signal(processInstance.getProcessInstanceId());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("process").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("process", (Object)"one").count());
        HashMap<String, String> variables2 = new HashMap<String, String>();
        variables2.put("process", "two");
        ProcessInstance processInstance2 = this.runtimeService.startProcessInstanceByKey("receiveTask", variables2);
        this.runtimeService.signal(processInstance2.getProcessInstanceId());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("process").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("process", (Object)"one").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("process", (Object)"two").count());
        HistoricVariableInstance historicProcessVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("process", (Object)"one").singleResult();
        FullHistoryTest.assertEquals((String)"process", (String)historicProcessVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"one", (Object)historicProcessVariable.getValue());
        FullHistoryTest.assertEquals((String)ValueType.STRING.getName(), (String)historicProcessVariable.getVariableTypeName());
        FullHistoryTest.assertEquals((String)ValueType.STRING.getName(), (String)historicProcessVariable.getTypeName());
        FullHistoryTest.assertEquals((Object)historicProcessVariable.getValue(), (Object)historicProcessVariable.getTypedValue().getValue());
        FullHistoryTest.assertEquals((String)historicProcessVariable.getTypeName(), (String)historicProcessVariable.getTypedValue().getType().getName());
        HashMap<String, Number> variables3 = new HashMap<String, Number>();
        variables3.put("long", 1000L);
        variables3.put("double", 25.43);
        ProcessInstance processInstance3 = this.runtimeService.startProcessInstanceByKey("receiveTask", variables3);
        this.runtimeService.signal(processInstance3.getProcessInstanceId());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("long").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("long", (Object)1000L).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableName("double").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricVariableInstanceQuery().variableValueEquals("double", (Object)25.43).count());
    }

    @Deployment
    public void testHistoricVariableUpdatesAllTypes() throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss SSS");
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("aVariable", "initial value");
        Date startedDate = sdf.parse("01/01/2001 01:23:45 000");
        Date updatedDate = sdf.parse("01/01/2001 01:23:46 000");
        ClockUtil.setCurrentTime((Date)startedDate);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricVariableUpdateProcess", variables);
        List details = ((HistoricDetailQuery)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).orderByVariableName().asc()).orderByTime().asc()).list();
        FullHistoryTest.assertEquals((int)9, (int)details.size());
        HistoricVariableUpdate startVarUpdate = (HistoricVariableUpdate)details.get(0);
        FullHistoryTest.assertEquals((String)"aVariable", (String)startVarUpdate.getVariableName());
        FullHistoryTest.assertEquals((Object)"initial value", (Object)startVarUpdate.getValue());
        FullHistoryTest.assertEquals((int)0, (int)startVarUpdate.getRevision());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)startVarUpdate.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)startedDate, (Object)startVarUpdate.getTime());
        HistoricVariableUpdate updatedStringVariable = (HistoricVariableUpdate)details.get(1);
        FullHistoryTest.assertEquals((String)"aVariable", (String)updatedStringVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"updated value", (Object)updatedStringVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)updatedStringVariable.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)updatedDate, (Object)updatedStringVariable.getTime());
        HistoricVariableUpdate intVariable = (HistoricVariableUpdate)details.get(2);
        FullHistoryTest.assertEquals((String)"bVariable", (String)intVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)123, (Object)intVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)intVariable.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)updatedDate, (Object)intVariable.getTime());
        HistoricVariableUpdate longVariable = (HistoricVariableUpdate)details.get(3);
        FullHistoryTest.assertEquals((String)"cVariable", (String)longVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)12345L, (Object)longVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)longVariable.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)updatedDate, (Object)longVariable.getTime());
        HistoricVariableUpdate doubleVariable = (HistoricVariableUpdate)details.get(4);
        FullHistoryTest.assertEquals((String)"dVariable", (String)doubleVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)1234.567, (Object)doubleVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)doubleVariable.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)updatedDate, (Object)doubleVariable.getTime());
        HistoricVariableUpdate shortVariable = (HistoricVariableUpdate)details.get(5);
        FullHistoryTest.assertEquals((String)"eVariable", (String)shortVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)12, (Object)shortVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)shortVariable.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)updatedDate, (Object)shortVariable.getTime());
        HistoricVariableUpdate dateVariable = (HistoricVariableUpdate)details.get(6);
        FullHistoryTest.assertEquals((String)"fVariable", (String)dateVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)sdf.parse("01/01/2001 01:23:45 678"), (Object)dateVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)dateVariable.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)updatedDate, (Object)dateVariable.getTime());
        HistoricVariableUpdate serializableVariable = (HistoricVariableUpdate)details.get(7);
        FullHistoryTest.assertEquals((String)"gVariable", (String)serializableVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)new SerializableVariable("hello hello"), (Object)serializableVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)serializableVariable.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)updatedDate, (Object)serializableVariable.getTime());
        HistoricVariableUpdate byteArrayVariable = (HistoricVariableUpdate)details.get(8);
        FullHistoryTest.assertEquals((String)"hVariable", (String)byteArrayVariable.getVariableName());
        FullHistoryTest.assertEquals((String)";-)", (String)new String((byte[])byteArrayVariable.getValue()));
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)byteArrayVariable.getProcessInstanceId());
        FullHistoryTest.assertEquals((Object)updatedDate, (Object)byteArrayVariable.getTime());
        List tasks = this.taskService.createTaskQuery().list();
        FullHistoryTest.assertEquals((int)1, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.assertProcessEnded(processInstance.getId());
        HistoricVariableInstanceQuery historicProcessVariableQuery = (HistoricVariableInstanceQuery)this.historyService.createHistoricVariableInstanceQuery().orderByVariableName().asc();
        FullHistoryTest.assertEquals((long)8L, (long)historicProcessVariableQuery.count());
        List historicVariables = historicProcessVariableQuery.list();
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)historicVariables.get(0);
        FullHistoryTest.assertEquals((String)"aVariable", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)"updated value", (Object)historicVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(1);
        FullHistoryTest.assertEquals((String)"bVariable", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)123, (Object)historicVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(2);
        FullHistoryTest.assertEquals((String)"cVariable", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)12345L, (Object)historicVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(3);
        FullHistoryTest.assertEquals((String)"dVariable", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)1234.567, (Object)historicVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(4);
        FullHistoryTest.assertEquals((String)"eVariable", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)12, (Object)historicVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(5);
        FullHistoryTest.assertEquals((String)"fVariable", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)sdf.parse("01/01/2001 01:23:45 678"), (Object)historicVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(6);
        FullHistoryTest.assertEquals((String)"gVariable", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((Object)new SerializableVariable("hello hello"), (Object)historicVariable.getValue());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicVariable.getProcessInstanceId());
        historicVariable = (HistoricVariableInstance)historicVariables.get(7);
        FullHistoryTest.assertEquals((String)"hVariable", (String)historicVariable.getVariableName());
        FullHistoryTest.assertEquals((String)";-)", (String)";-)", (String)new String((byte[])historicVariable.getValue()));
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicVariable.getProcessInstanceId());
    }

    @Deployment
    public void testHistoricFormProperties() throws Exception {
        Date startedDate = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss SSS").parse("01/01/2001 01:23:46 000");
        ClockUtil.setCurrentTime((Date)startedDate);
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("formProp1", "Activiti rocks");
        formProperties.put("formProp2", "12345");
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("historicFormPropertiesProcess").singleResult();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDef.getId(), formProperties);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        FullHistoryTest.assertNotNull((Object)task);
        List activityIds = this.runtimeService.getActiveActivityIds(task.getExecutionId());
        FullHistoryTest.assertNotNull((Object)activityIds);
        FullHistoryTest.assertEquals((int)1, (int)activityIds.size());
        String taskActivityId = (String)activityIds.get(0);
        formProperties = new HashMap();
        formProperties.put("formProp3", "Activiti still rocks!!!");
        formProperties.put("formProp4", "54321");
        this.formService.submitTaskFormData(task.getId(), formProperties);
        List props = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).orderByFormPropertyId().asc()).list();
        HistoricFormProperty historicProperty1 = (HistoricFormProperty)props.get(0);
        FullHistoryTest.assertEquals((String)"formProp1", (String)historicProperty1.getPropertyId());
        FullHistoryTest.assertEquals((String)"Activiti rocks", (String)historicProperty1.getPropertyValue());
        FullHistoryTest.assertEquals((Object)startedDate, (Object)historicProperty1.getTime());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicProperty1.getProcessInstanceId());
        FullHistoryTest.assertNull((Object)historicProperty1.getTaskId());
        FullHistoryTest.assertNotNull((Object)historicProperty1.getActivityInstanceId());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(historicProperty1.getActivityInstanceId()).singleResult();
        FullHistoryTest.assertNotNull((Object)historicActivityInstance);
        FullHistoryTest.assertEquals((String)"start", (String)historicActivityInstance.getActivityId());
        HistoricFormProperty historicProperty2 = (HistoricFormProperty)props.get(1);
        FullHistoryTest.assertEquals((String)"formProp2", (String)historicProperty2.getPropertyId());
        FullHistoryTest.assertEquals((String)"12345", (String)historicProperty2.getPropertyValue());
        FullHistoryTest.assertEquals((Object)startedDate, (Object)historicProperty2.getTime());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicProperty2.getProcessInstanceId());
        FullHistoryTest.assertNull((Object)historicProperty2.getTaskId());
        FullHistoryTest.assertNotNull((Object)historicProperty2.getActivityInstanceId());
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(historicProperty2.getActivityInstanceId()).singleResult();
        FullHistoryTest.assertNotNull((Object)historicActivityInstance);
        FullHistoryTest.assertEquals((String)"start", (String)historicActivityInstance.getActivityId());
        HistoricFormProperty historicProperty3 = (HistoricFormProperty)props.get(2);
        FullHistoryTest.assertEquals((String)"formProp3", (String)historicProperty3.getPropertyId());
        FullHistoryTest.assertEquals((String)"Activiti still rocks!!!", (String)historicProperty3.getPropertyValue());
        FullHistoryTest.assertEquals((Object)startedDate, (Object)historicProperty3.getTime());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicProperty3.getProcessInstanceId());
        String activityInstanceId = historicProperty3.getActivityInstanceId();
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(activityInstanceId).singleResult();
        FullHistoryTest.assertNotNull((Object)historicActivityInstance);
        FullHistoryTest.assertEquals((String)taskActivityId, (String)historicActivityInstance.getActivityId());
        FullHistoryTest.assertNotNull((Object)historicProperty3.getTaskId());
        HistoricFormProperty historicProperty4 = (HistoricFormProperty)props.get(3);
        FullHistoryTest.assertEquals((String)"formProp4", (String)historicProperty4.getPropertyId());
        FullHistoryTest.assertEquals((String)"54321", (String)historicProperty4.getPropertyValue());
        FullHistoryTest.assertEquals((Object)startedDate, (Object)historicProperty4.getTime());
        FullHistoryTest.assertEquals((String)processInstance.getId(), (String)historicProperty4.getProcessInstanceId());
        activityInstanceId = historicProperty4.getActivityInstanceId();
        historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(activityInstanceId).singleResult();
        FullHistoryTest.assertNotNull((Object)historicActivityInstance);
        FullHistoryTest.assertEquals((String)taskActivityId, (String)historicActivityInstance.getActivityId());
        FullHistoryTest.assertNotNull((Object)historicProperty4.getTaskId());
        FullHistoryTest.assertEquals((int)4, (int)props.size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableQuery() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", "activiti rocks!");
        variables.put("longVar", 12345L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().activityInstanceId(null).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().activityInstanceId("unexisting").count());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId("unexisting").count());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().activityInstanceId(null).processInstanceId(processInstance.getId()).count());
        List tasks = this.taskService.createTaskQuery().list();
        FullHistoryTest.assertEquals((int)1, (int)tasks.size());
        this.taskService.complete(((Task)tasks.get(0)).getId());
        this.assertProcessEnded(processInstance.getId());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().count());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableQueryExcludeTaskRelatedDetails() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", "activiti rocks!");
        variables.put("longVar", 12345L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        FullHistoryTest.assertNotNull((Object)task);
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)"It is I, le Variable");
        FullHistoryTest.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).excludeTaskDetails().count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).excludeTaskDetails().taskId(task.getId()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricFormPropertiesQuery() throws Exception {
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("stringVar", "activiti rocks!");
        formProperties.put("longVar", "12345");
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDef.getId(), formProperties);
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().formProperties().activityInstanceId(null).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formProperties().activityInstanceId("unexisting").count());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId("unexisting").count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        formProperties = new HashMap();
        formProperties.put("taskVar", "task form property");
        this.formService.submitTaskFormData(task.getId(), formProperties);
        FullHistoryTest.assertEquals((long)3L, (long)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().formProperties().processInstanceId("unexisting").count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricVariableQuerySorting() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("stringVar", "activiti rocks!");
        variables.put("longVar", 12345L);
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", variables);
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByProcessInstanceId().asc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTime().asc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableName().asc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableRevision().asc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableType().asc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByProcessInstanceId().desc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTime().desc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableName().desc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableRevision().desc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableType().desc()).count());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByProcessInstanceId().asc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTime().asc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableName().asc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableRevision().asc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableType().asc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByProcessInstanceId().desc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByTime().desc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableName().desc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableRevision().desc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().variableUpdates().orderByVariableType().desc()).list().size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricFormPropertySorting() throws Exception {
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("stringVar", "activiti rocks!");
        formProperties.put("longVar", "12345");
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("oneTaskProcess").singleResult();
        this.formService.submitStartFormData(procDef.getId(), formProperties);
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByProcessInstanceId().asc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByTime().asc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByFormPropertyId().asc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByProcessInstanceId().desc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByTime().desc()).count());
        FullHistoryTest.assertEquals((long)2L, (long)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByFormPropertyId().desc()).count());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByProcessInstanceId().asc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByTime().asc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByFormPropertyId().asc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByProcessInstanceId().desc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByTime().desc()).list().size());
        FullHistoryTest.assertEquals((int)2, (int)((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().formProperties().orderByFormPropertyId().desc()).list().size());
    }

    @Deployment
    public void testHistoricDetailQueryMixed() throws Exception {
        HashMap<String, String> formProperties = new HashMap<String, String>();
        formProperties.put("formProp1", "activiti rocks!");
        formProperties.put("formProp2", "12345");
        ProcessDefinition procDef = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey("historicDetailMixed").singleResult();
        ProcessInstance processInstance = this.formService.submitStartFormData(procDef.getId(), formProperties);
        List details = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).orderByVariableName().asc()).list();
        FullHistoryTest.assertEquals((int)4, (int)details.size());
        FullHistoryTest.assertTrue((boolean)(details.get(0) instanceof HistoricFormProperty));
        HistoricFormProperty formProp1 = (HistoricFormProperty)details.get(0);
        FullHistoryTest.assertEquals((String)"formProp1", (String)formProp1.getPropertyId());
        FullHistoryTest.assertEquals((String)"activiti rocks!", (String)formProp1.getPropertyValue());
        FullHistoryTest.assertTrue((boolean)(details.get(1) instanceof HistoricFormProperty));
        HistoricFormProperty formProp2 = (HistoricFormProperty)details.get(1);
        FullHistoryTest.assertEquals((String)"formProp2", (String)formProp2.getPropertyId());
        FullHistoryTest.assertEquals((String)"12345", (String)formProp2.getPropertyValue());
        FullHistoryTest.assertTrue((boolean)(details.get(2) instanceof HistoricVariableUpdate));
        HistoricVariableUpdate varUpdate1 = (HistoricVariableUpdate)details.get(2);
        FullHistoryTest.assertEquals((String)"variable1", (String)varUpdate1.getVariableName());
        FullHistoryTest.assertEquals((Object)"activiti rocks!", (Object)varUpdate1.getValue());
        FullHistoryTest.assertTrue((boolean)(details.get(3) instanceof HistoricVariableUpdate));
        HistoricVariableUpdate varUpdate2 = (HistoricVariableUpdate)details.get(3);
        FullHistoryTest.assertEquals((String)"variable2", (String)varUpdate2.getVariableName());
        FullHistoryTest.assertEquals((Object)12345L, (Object)varUpdate2.getValue());
    }

    public void testHistoricDetailQueryInvalidSorting() throws Exception {
        try {
            ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().asc()).list();
            FullHistoryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().desc()).list();
            FullHistoryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByProcessInstanceId().list();
            FullHistoryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByTime().list();
            FullHistoryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByVariableName().list();
            FullHistoryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByVariableRevision().list();
            FullHistoryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.historyService.createHistoricDetailQuery().orderByVariableType().list();
            FullHistoryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    public void testHistoricTaskInstanceVariableUpdates() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.runtimeService.setVariable(processInstanceId, "deadline", (Object)"yesterday");
        this.taskService.setVariableLocal(taskId, "bucket", (Object)"23c");
        this.taskService.setVariableLocal(taskId, "mop", (Object)"37i");
        this.taskService.complete(taskId);
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().count());
        List historicTaskVariableUpdates = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().taskId(taskId).variableUpdates().orderByVariableName().asc()).list();
        FullHistoryTest.assertEquals((int)2, (int)historicTaskVariableUpdates.size());
        this.historyService.deleteHistoricTaskInstance(taskId);
        historicTaskVariableUpdates = ((HistoricDetailQuery)this.historyService.createHistoricDetailQuery().taskId(taskId).variableUpdates().orderByVariableName().asc()).list();
        FullHistoryTest.assertEquals((int)0, (int)historicTaskVariableUpdates.size());
    }

    @Deployment
    public void testSetVariableOnProcessInstanceWithTimer() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("timerVariablesProcess");
        this.runtimeService.setVariable(processInstance.getId(), "myVar", (Object)123456L);
        FullHistoryTest.assertEquals((Object)123456L, (Object)this.runtimeService.getVariable(processInstance.getId(), "myVar"));
    }

    @Deployment
    public void testDeleteHistoricProcessInstance() {
        HashMap<String, Serializable> vars = new HashMap<String, Serializable>();
        vars.put("processVar", Long.valueOf(123L));
        vars.put("anotherProcessVar", new DummySerializable());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest", vars);
        FullHistoryTest.assertNotNull((Object)processInstance);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "taskVar", (Object)45678);
        this.taskService.setVariableLocal(task.getId(), "anotherTaskVar", (Object)"value");
        this.taskService.complete(task.getId());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)3L, (long)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)4L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)4L, (long)this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId()).count());
        this.historyService.deleteHistoricProcessInstance(processInstance.getId());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricVariableInstanceQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getId()).count());
        try {
            this.historyService.deleteHistoricProcessInstance("unexisting");
            FullHistoryTest.fail((String)"Exception expected when deleting process-instance that is still running");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("No historic process instance found with id: unexisting", ae.getMessage());
        }
    }

    @Deployment
    public void testDeleteRunningHistoricProcessInstance() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        FullHistoryTest.assertNotNull((Object)processInstance);
        try {
            this.historyService.deleteHistoricProcessInstance(processInstance.getId());
            FullHistoryTest.fail((String)"Exception expected when deleting process-instance that is still running");
        }
        catch (ProcessEngineException ae) {
            this.assertTextPresent("Process instance is still running, cannot delete historic process instance", ae.getMessage());
        }
    }

    @Deployment
    public void testDeleteCachedHistoricDetails() {
        final String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                HashMap<String, String> formProperties = new HashMap<String, String>();
                formProperties.put("formProp1", "value1");
                ProcessInstance processInstance = new SubmitStartFormCmd(processDefinitionId, null, formProperties).execute(commandContext);
                commandContext.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceId(processInstance.getId());
                return null;
            }
        });
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricProcessInstanceQuery().count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricDetailQuery().count());
    }

    @Deployment
    public void testHistoricFormPropertiesOnReEnteringActivity() {
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("comeBack", Boolean.TRUE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricFormPropertiesProcess", variables);
        FullHistoryTest.assertNotNull((Object)processInstance);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("formProp1", "Property value");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.formService.submitTaskFormData(task.getId(), data);
        List details = this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).list();
        FullHistoryTest.assertNotNull((Object)details);
        FullHistoryTest.assertEquals((int)1, (int)details.size());
        task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.formService.submitTaskFormData(task.getId(), data);
        details = this.historyService.createHistoricDetailQuery().formProperties().processInstanceId(processInstance.getId()).list();
        FullHistoryTest.assertNotNull((Object)details);
        FullHistoryTest.assertEquals((int)2, (int)details.size());
        Assert.assertNotSame((Object)((HistoricDetail)details.get(0)).getActivityInstanceId(), (Object)((HistoricDetail)details.get(1)).getActivityInstanceId());
        HistoricActivityInstance historicActInst1 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(((HistoricDetail)details.get(0)).getActivityInstanceId()).singleResult();
        HistoricActivityInstance historicActInst2 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(((HistoricDetail)details.get(1)).getActivityInstanceId()).singleResult();
        FullHistoryTest.assertEquals((String)historicActInst1.getActivityId(), (String)historicActInst2.getActivityId());
    }

    @Deployment
    public void testHistoricTaskInstanceQueryTaskVariableValueEquals() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 12345L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        FullHistoryTest.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().taskId(task.getId()).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("longVar", (Object)12345L).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("nullVar", null).count());
        variables.put("longVar", 67890L);
        variables.put("shortVar", (short)456);
        variables.put("integerVar", 5678);
        variables.put("stringVar", "updatedStringValue");
        variables.put("booleanVar", false);
        Calendar otherCal = Calendar.getInstance();
        otherCal.add(5, 1);
        Date otherDate = otherCal.getTime();
        variables.put("dateVar", otherDate);
        variables.put("nullVar", null);
        this.taskService.setVariablesLocal(task.getId(), variables);
        FullHistoryTest.assertEquals((long)14L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().taskId(task.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("longVar", (Object)12345L).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("shortVar", (Object)123).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("integerVar", (Object)1234).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("stringVar", (Object)"stringValue").count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("booleanVar", (Object)true).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("dateVar", (Object)date).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("longVar", (Object)67890L).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("shortVar", (Object)456).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("integerVar", (Object)5678).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("stringVar", (Object)"updatedStringValue").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("booleanVar", (Object)false).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("dateVar", (Object)otherDate).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("nullVar", null).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryTaskVariableValueEqualsOverwriteType() throws Exception {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        this.taskService.setVariableLocal(task.getId(), "var", (Object)12345L);
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().taskId(task.getId()).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)12345L).count());
        this.taskService.setVariableLocal(task.getId(), "var", (Object)12345);
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().taskId(task.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)12345L).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().taskVariableValueEquals("var", (Object)12345).count());
    }

    @Deployment
    public void testHistoricTaskInstanceQueryVariableInParallelBranch() throws Exception {
        this.runtimeService.startProcessInstanceByKey("parallelGateway");
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        this.runtimeService.setVariableLocal(task1Execution.getId(), "var", (Object)12345L);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "var", (Object)12345);
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)12345).count());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)12345L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testHistoricTaskInstanceQueryVariableInParallelBranch.bpmn20.xml"})
    public void testHistoricTaskInstanceQueryVariableOfSameTypeInParallelBranch() throws Exception {
        this.runtimeService.startProcessInstanceByKey("parallelGateway");
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task1").singleResult();
        this.runtimeService.setVariableLocal(task1Execution.getId(), "var", (Object)12345L);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("task2").singleResult();
        this.runtimeService.setVariableLocal(task2Execution.getId(), "var", (Object)45678L);
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)12345L).count());
        FullHistoryTest.assertEquals((long)2L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("var", (Object)45678L).count());
    }

    @Deployment
    public void testHistoricTaskInstanceQueryProcessVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 12345L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricTaskInstanceTest", variables);
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(processInstance.getId()).singleResult();
        FullHistoryTest.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)12345L).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("shortVar", (Object)123).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("dateVar", (Object)date).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("nullVar", null).count());
        variables.put("longVar", 67890L);
        variables.put("shortVar", (short)456);
        variables.put("integerVar", 5678);
        variables.put("stringVar", "updatedStringValue");
        variables.put("booleanVar", false);
        Calendar otherCal = Calendar.getInstance();
        otherCal.add(5, 1);
        Date otherDate = otherCal.getTime();
        variables.put("dateVar", otherDate);
        variables.put("nullVar", null);
        this.runtimeService.setVariables(processInstance.getId(), variables);
        FullHistoryTest.assertEquals((long)14L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)12345L).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("shortVar", (Object)123).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("integerVar", (Object)1234).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("stringVar", (Object)"stringValue").count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("booleanVar", (Object)true).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("dateVar", (Object)date).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)67890L).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("shortVar", (Object)456).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("integerVar", (Object)5678).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("stringVar", (Object)"updatedStringValue").count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("booleanVar", (Object)false).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("dateVar", (Object)otherDate).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("nullVar", null).count());
        this.taskService.setVariableLocal(task.getId(), "longVar", (Object)9999L);
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)9999L).count());
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricTaskInstanceQuery().processVariableValueEquals("longVar", (Object)67890L).count());
    }

    @Deployment
    public void testHistoricProcessInstanceVariableValueEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 12345L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricProcessInstanceTest", variables);
        FullHistoryTest.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testHistoricProcessInstanceVariableValueEquals.bpmn20.xml"})
    public void testHistoricProcessInstanceVariableValueNotEquals() throws Exception {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("longVar", 12345L);
        variables.put("shortVar", (short)123);
        variables.put("integerVar", 1234);
        variables.put("stringVar", "stringValue");
        variables.put("booleanVar", true);
        Date date = Calendar.getInstance().getTime();
        Calendar otherCal = Calendar.getInstance();
        otherCal.add(5, 1);
        Date otherDate = otherCal.getTime();
        variables.put("dateVar", date);
        variables.put("nullVar", null);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricProcessInstanceTest", variables);
        FullHistoryTest.assertEquals((long)7L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("longVar", (Object)12345L).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("shortVar", (Object)123).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("integerVar", (Object)1234).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("stringVar", (Object)"stringValue").count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("booleanVar", (Object)true).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("dateVar", (Object)date).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueNotEquals("nullVar", null).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testHistoricProcessInstanceVariableValueEquals.bpmn20.xml"})
    public void testHistoricProcessInstanceVariableValueLessThanAndGreaterThan() throws Exception {
        HashMap<String, Long> variables = new HashMap<String, Long>();
        variables.put("longVar", 12345L);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("HistoricProcessInstanceTest", variables);
        FullHistoryTest.assertEquals((long)1L, (long)this.historyService.createHistoricDetailQuery().variableUpdates().processInstanceId(processInstance.getId()).count());
        FullHistoryTest.assertEquals((long)0L, (long)this.historyService.createHistoricProcessInstanceQuery().variableValueGreaterThan("longVar", (Object)12345L).count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/standalone/history/FullHistoryTest.testVariableUpdatesAreLinkedToActivity.bpmn20.xml"})
    public void testVariableUpdatesLinkedToActivity() throws Exception {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("ProcessWithSubProcess");
        Task task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("test", "1");
        this.taskService.complete(task.getId(), variables);
        task = (Task)this.taskService.createTaskQuery().processInstanceId(pi.getId()).singleResult();
        variables.clear();
        variables.put("test", "2");
        this.taskService.complete(task.getId(), variables);
        this.assertProcessEnded(pi.getId());
        List updates = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        FullHistoryTest.assertEquals((int)2, (int)updates.size());
        HashMap<String, HistoricVariableUpdate> updatesMap = new HashMap<String, HistoricVariableUpdate>();
        HistoricVariableUpdate update = (HistoricVariableUpdate)updates.get(0);
        updatesMap.put((String)update.getValue(), update);
        update = (HistoricVariableUpdate)updates.get(1);
        updatesMap.put((String)update.getValue(), update);
        HistoricVariableUpdate update1 = (HistoricVariableUpdate)updatesMap.get("1");
        HistoricVariableUpdate update2 = (HistoricVariableUpdate)updatesMap.get("2");
        FullHistoryTest.assertNotNull((Object)update1.getActivityInstanceId());
        FullHistoryTest.assertNotNull((Object)update1.getExecutionId());
        HistoricActivityInstance historicActivityInstance1 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update1.getActivityInstanceId()).singleResult();
        FullHistoryTest.assertEquals((String)historicActivityInstance1.getExecutionId(), (String)update1.getExecutionId());
        FullHistoryTest.assertEquals((String)"usertask1", (String)historicActivityInstance1.getActivityId());
        FullHistoryTest.assertNotNull((Object)update2.getActivityInstanceId());
        HistoricActivityInstance historicActivityInstance2 = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityInstanceId(update2.getActivityInstanceId()).singleResult();
        FullHistoryTest.assertEquals((String)"usertask2", (String)historicActivityInstance2.getActivityId());
        FullHistoryTest.assertFalse((boolean)historicActivityInstance2.getExecutionId().equals(update2.getExecutionId()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/oneTaskProcess.bpmn20.xml"})
    public void testHistoricDetailQueryByVariableInstanceId() throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("testVar", "testValue");
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess", params);
        HistoricVariableInstance testVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("testVar").singleResult();
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        query.variableInstanceId(testVariable.getId());
        FullHistoryTest.assertEquals((long)1L, (long)query.count());
        FullHistoryTest.assertEquals((int)1, (int)query.list().size());
    }

    public void testHistoricDetailQueryByInvalidVariableInstanceId() {
        HistoricDetailQuery query = this.historyService.createHistoricDetailQuery();
        query.variableInstanceId("invalid");
        FullHistoryTest.assertEquals((long)0L, (long)query.count());
        try {
            query.variableInstanceId(null);
            FullHistoryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            query.variableInstanceId((String)null);
            FullHistoryTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    public void testHistoricDetailActivityInstanceIdForInactiveScopeExecution() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.setVariable(pi.getId(), "foo", (Object)"bar");
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        FullHistoryTest.assertNotNull((Object)historicDetail.getActivityInstanceId());
    }

    public void testHistoricDetailQueryById() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "someName";
        String variableValue = "someValue";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)variableValue);
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().singleResult();
        HistoricDetail resultById = (HistoricDetail)this.historyService.createHistoricDetailQuery().detailId(result.getId()).singleResult();
        FullHistoryTest.assertNotNull((Object)resultById);
        FullHistoryTest.assertEquals((String)result.getId(), (String)resultById.getId());
        FullHistoryTest.assertEquals((String)variableName, (String)((HistoricVariableUpdate)resultById).getVariableName());
        FullHistoryTest.assertEquals((Object)variableValue, (Object)((HistoricVariableUpdate)resultById).getValue());
        FullHistoryTest.assertEquals((String)ValueType.STRING.getName(), (String)((HistoricVariableUpdate)resultById).getVariableTypeName());
        FullHistoryTest.assertEquals((String)ValueType.STRING.getName(), (String)((HistoricVariableUpdate)resultById).getTypeName());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testHistoricDetailQueryByNonExistingId() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "someName";
        String variableValue = "someValue";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)variableValue);
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().detailId("non-existing").singleResult();
        FullHistoryTest.assertNull((Object)result);
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testBinaryFetchingEnabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableUpdates().singleResult();
        FullHistoryTest.assertNotNull((Object)((HistoricVariableUpdate)result).getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testBinaryFetchingDisabled() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "binaryVariableName";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)"some bytes".getBytes());
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().disableBinaryFetching().variableUpdates().singleResult();
        FullHistoryTest.assertNull((Object)((HistoricVariableUpdate)result).getValue());
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testDisableCustomObjectDeserialization() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        HashMap<String, Serializable> variables = new HashMap<String, Serializable>();
        variables.put("customSerializable", new CustomSerializable());
        variables.put("failingSerializable", new FailingSerializable());
        this.taskService.setVariables(newTask.getId(), variables);
        List results = this.historyService.createHistoricDetailQuery().disableBinaryFetching().disableCustomObjectDeserialization().variableUpdates().list();
        FullHistoryTest.assertEquals((int)2, (int)results.size());
        for (HistoricDetail update : results) {
            HistoricVariableUpdate variableUpdate = (HistoricVariableUpdate)update;
            FullHistoryTest.assertNull((Object)variableUpdate.getErrorMessage());
            ObjectValue typedValue = (ObjectValue)variableUpdate.getTypedValue();
            FullHistoryTest.assertNotNull((Object)typedValue);
            FullHistoryTest.assertFalse((boolean)typedValue.isDeserialized());
            try {
                typedValue.getValue();
            }
            catch (IllegalStateException e) {
                this.assertTextPresent("Object is not deserialized", e.getMessage());
            }
            FullHistoryTest.assertNotNull((Object)typedValue.getValueSerialized());
        }
        this.taskService.deleteTask(newTask.getId(), true);
    }

    public void testErrorMessage() {
        Task newTask = this.taskService.newTask();
        this.taskService.saveTask(newTask);
        String variableName = "failingSerializable";
        this.taskService.setVariable(newTask.getId(), variableName, (Object)new FailingSerializable());
        HistoricDetail result = (HistoricDetail)this.historyService.createHistoricDetailQuery().disableBinaryFetching().variableUpdates().singleResult();
        FullHistoryTest.assertNull((Object)((HistoricVariableUpdate)result).getValue());
        FullHistoryTest.assertNotNull((Object)((HistoricVariableUpdate)result).getErrorMessage());
        this.taskService.deleteTask(newTask.getId(), true);
    }
}

