/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.interceptor;

import junit.framework.TestCase;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class CommandContextInterceptorTest
extends PluggableProcessEngineTestCase {
    public void testCommandContextGetCurrentAfterException() {
        try {
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

                public Object execute(CommandContext commandContext) {
                    throw new IllegalStateException("here i come!");
                }
            });
            CommandContextInterceptorTest.fail((String)"expected exception");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CommandContextInterceptorTest.assertNull((Object)Context.getCommandContext());
    }

    public void testCommandContextNestedFailingCommands() {
        final ExceptionThrowingCmd innerCommand1 = new ExceptionThrowingCmd(new IdentifiableRuntimeException(1));
        final ExceptionThrowingCmd innerCommand2 = new ExceptionThrowingCmd(new IdentifiableRuntimeException(2));
        try {
            this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

                public Object execute(CommandContext commandContext) {
                    CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutorTxRequired();
                    commandExecutor.execute((Command)innerCommand1);
                    commandExecutor.execute((Command)innerCommand2);
                    return null;
                }
            });
            CommandContextInterceptorTest.fail((String)"Exception expected");
        }
        catch (IdentifiableRuntimeException e) {
            CommandContextInterceptorTest.assertEquals((int)1, (int)e.id);
        }
        CommandContextInterceptorTest.assertTrue((boolean)innerCommand1.executed);
        CommandContextInterceptorTest.assertFalse((boolean)innerCommand2.executed);
    }

    public void testCommandContextNestedTryCatch() {
        final ExceptionThrowingCmd innerCommand = new ExceptionThrowingCmd(new IdentifiableRuntimeException(1));
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                CommandExecutor commandExecutor = Context.getProcessEngineConfiguration().getCommandExecutorTxRequired();
                try {
                    commandExecutor.execute((Command)innerCommand);
                    TestCase.fail((String)"exception expected to pop up during execution of inner command");
                }
                catch (IdentifiableRuntimeException e) {
                    TestCase.assertNull((String)"the exception should not have been propagated to this command's context", (Object)Context.getCommandInvocationContext().getThrowable());
                }
                return null;
            }
        });
    }

    protected class IdentifiableRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        protected int id;

        public IdentifiableRuntimeException(int id) {
            this.id = id;
        }
    }

    protected class ExceptionThrowingCmd
    implements Command<Void> {
        protected boolean executed = false;
        protected RuntimeException exceptionToThrow;

        public ExceptionThrowingCmd(RuntimeException e) {
            this.exceptionToThrow = e;
        }

        public Void execute(CommandContext commandContext) {
            this.executed = true;
            throw this.exceptionToThrow;
        }
    }
}

