/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.diagram;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.impl.bpmn.diagram.ProcessDiagramCanvas;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.PvmTransition;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.Lane;
import org.camunda.bpm.engine.impl.pvm.process.LaneSet;
import org.camunda.bpm.engine.impl.pvm.process.ParticipantProcess;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;

public class ProcessDiagramGenerator {
    protected static final Map<String, ActivityDrawInstruction> activityDrawInstructions = new HashMap<String, ActivityDrawInstruction>();

    public static InputStream generatePngDiagram(ProcessDefinitionEntity processDefinition) {
        return ProcessDiagramGenerator.generateDiagram(processDefinition, "png", Collections.<String>emptyList());
    }

    public static InputStream generateJpgDiagram(ProcessDefinitionEntity processDefinition) {
        return ProcessDiagramGenerator.generateDiagram(processDefinition, "jpg", Collections.<String>emptyList());
    }

    protected static ProcessDiagramCanvas generateDiagram(ProcessDefinitionEntity processDefinition, List<String> highLightedActivities) {
        ProcessDiagramCanvas processDiagramCanvas = ProcessDiagramGenerator.initProcessDiagramCanvas(processDefinition);
        if (processDefinition.getParticipantProcess() != null) {
            ParticipantProcess pProc = processDefinition.getParticipantProcess();
            processDiagramCanvas.drawPoolOrLane(pProc.getName(), pProc.getX(), pProc.getY(), pProc.getWidth(), pProc.getHeight());
        }
        if (processDefinition.getLaneSets() != null && processDefinition.getLaneSets().size() > 0) {
            for (LaneSet laneSet : processDefinition.getLaneSets()) {
                if (laneSet.getLanes() == null || laneSet.getLanes().size() <= 0) continue;
                for (Lane lane : laneSet.getLanes()) {
                    processDiagramCanvas.drawPoolOrLane(lane.getName(), lane.getX(), lane.getY(), lane.getWidth(), lane.getHeight());
                }
            }
        }
        for (ActivityImpl activity : processDefinition.getActivities()) {
            ProcessDiagramGenerator.drawActivity(processDiagramCanvas, activity, highLightedActivities);
        }
        return processDiagramCanvas;
    }

    public static InputStream generateDiagram(ProcessDefinitionEntity processDefinition, String imageType, List<String> highLightedActivities) {
        return ProcessDiagramGenerator.generateDiagram(processDefinition, highLightedActivities).generateImage(imageType);
    }

    protected static void drawActivity(ProcessDiagramCanvas processDiagramCanvas, ActivityImpl activity, List<String> highLightedActivities) {
        String type = (String)activity.getProperty("type");
        ActivityDrawInstruction drawInstruction = activityDrawInstructions.get(type);
        if (drawInstruction != null) {
            Boolean expanded;
            drawInstruction.draw(processDiagramCanvas, activity);
            boolean multiInstanceSequential = false;
            boolean multiInstanceParallel = false;
            boolean collapsed = false;
            String multiInstance = (String)activity.getProperty("multiInstance");
            if (multiInstance != null) {
                if ("sequential".equals(multiInstance)) {
                    multiInstanceSequential = true;
                } else {
                    multiInstanceParallel = true;
                }
            }
            if ((expanded = (Boolean)activity.getProperty("isExpanded")) != null) {
                collapsed = expanded == false;
            }
            processDiagramCanvas.drawActivityMarkers(activity.getX(), activity.getY(), activity.getWidth(), activity.getHeight(), multiInstanceSequential, multiInstanceParallel, collapsed);
            if (highLightedActivities.contains(activity.getId())) {
                ProcessDiagramGenerator.drawHighLight(processDiagramCanvas, activity);
            }
        }
        for (PvmTransition sequenceFlow : activity.getOutgoingTransitions()) {
            List<Integer> waypoints = ((TransitionImpl)sequenceFlow).getWaypoints();
            for (int i = 2; i < waypoints.size(); i += 2) {
                boolean drawConditionalIndicator;
                boolean bl = drawConditionalIndicator = i == 2 && sequenceFlow.getProperty("condition") != null && !((String)activity.getProperty("type")).toLowerCase().contains("gateway");
                if (i < waypoints.size() - 2) {
                    processDiagramCanvas.drawSequenceflowWithoutArrow(waypoints.get(i - 2), waypoints.get(i - 1), waypoints.get(i), waypoints.get(i + 1), drawConditionalIndicator);
                    continue;
                }
                processDiagramCanvas.drawSequenceflow(waypoints.get(i - 2), waypoints.get(i - 1), waypoints.get(i), waypoints.get(i + 1), drawConditionalIndicator);
            }
        }
        for (ActivityImpl nestedActivity : activity.getActivities()) {
            ProcessDiagramGenerator.drawActivity(processDiagramCanvas, nestedActivity, highLightedActivities);
        }
    }

    private static void drawHighLight(ProcessDiagramCanvas processDiagramCanvas, ActivityImpl activity) {
        processDiagramCanvas.drawHighLight(activity.getX(), activity.getY(), activity.getWidth(), activity.getHeight());
    }

    protected static ProcessDiagramCanvas initProcessDiagramCanvas(ProcessDefinitionEntity processDefinition) {
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        if (processDefinition.getParticipantProcess() != null) {
            ParticipantProcess pProc = processDefinition.getParticipantProcess();
            minX = pProc.getX();
            maxX = pProc.getX() + pProc.getWidth();
            minY = pProc.getY();
            maxY = pProc.getY() + pProc.getHeight();
        }
        for (ActivityImpl activity : processDefinition.getActivities()) {
            if (activity.getX() + activity.getWidth() > maxX) {
                maxX = activity.getX() + activity.getWidth();
            }
            if (activity.getX() < minX) {
                minX = activity.getX();
            }
            if (activity.getY() + activity.getHeight() > maxY) {
                maxY = activity.getY() + activity.getHeight();
            }
            if (activity.getY() < minY) {
                minY = activity.getY();
            }
            for (PvmTransition sequenceFlow : activity.getOutgoingTransitions()) {
                List<Integer> waypoints = ((TransitionImpl)sequenceFlow).getWaypoints();
                for (int i = 0; i < waypoints.size(); i += 2) {
                    if (waypoints.get(i) > maxX) {
                        maxX = waypoints.get(i);
                    }
                    if (waypoints.get(i) < minX) {
                        minX = waypoints.get(i);
                    }
                    if (waypoints.get(i + 1) > maxY) {
                        maxY = waypoints.get(i + 1);
                    }
                    if (waypoints.get(i + 1) >= minY) continue;
                    minY = waypoints.get(i + 1);
                }
            }
        }
        if (processDefinition.getLaneSets() != null && processDefinition.getLaneSets().size() > 0) {
            for (LaneSet laneSet : processDefinition.getLaneSets()) {
                if (laneSet.getLanes() == null || laneSet.getLanes().size() <= 0) continue;
                for (Lane lane : laneSet.getLanes()) {
                    if (lane.getX() + lane.getWidth() > maxX) {
                        maxX = lane.getX() + lane.getWidth();
                    }
                    if (lane.getX() < minX) {
                        minX = lane.getX();
                    }
                    if (lane.getY() + lane.getHeight() > maxY) {
                        maxY = lane.getY() + lane.getHeight();
                    }
                    if (lane.getY() >= minY) continue;
                    minY = lane.getY();
                }
            }
        }
        if (!(processDefinition.getActivities() != null && processDefinition.getActivities().size() != 0 || processDefinition.getLaneSets() != null && processDefinition.getLaneSets().size() != 0)) {
            minX = 0;
            minY = 0;
        }
        return new ProcessDiagramCanvas(maxX + 10, maxY + 10, minX, minY);
    }

    static {
        activityDrawInstructions.put("startEvent", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawNoneStartEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("startTimerEvent", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawTimerStartEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("intermediateSignalCatch", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawCatchingSignalEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("intermediateSignalThrow", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawThrowingSignalEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("endEvent", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawNoneEndEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("errorEndEvent", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawErrorEndEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("errorStartEvent", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawErrorStartEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("task", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawTask((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("userTask", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawUserTask((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("scriptTask", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawScriptTask((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("serviceTask", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawServiceTask((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("receiveTask", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawReceiveTask((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("sendTask", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawSendTask((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("manualTask", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawManualTask((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("businessRuleTask", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawBusinessRuleTask((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("exclusiveGateway", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawExclusiveGateway(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("inclusiveGateway", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawInclusiveGateway(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("parallelGateway", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawParallelGateway(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("boundaryTimer", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawCatchingTimerEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("boundaryError", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawCatchingErroEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("boundarySignal", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawCatchingSignalEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("intermediateTimer", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawCatchingTimerEvent(activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
        activityDrawInstructions.put("subProcess", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                Boolean isExpanded = (Boolean)activityImpl.getProperty("isExpanded");
                Boolean isTriggeredByEvent = (Boolean)activityImpl.getProperty("triggeredByEvent");
                if (isTriggeredByEvent == null) {
                    isTriggeredByEvent = Boolean.TRUE;
                }
                if (isExpanded != null && !isExpanded.booleanValue()) {
                    processDiagramCreator.drawCollapsedSubProcess((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight(), isTriggeredByEvent);
                } else {
                    processDiagramCreator.drawExpandedSubProcess((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight(), isTriggeredByEvent);
                }
            }
        });
        activityDrawInstructions.put("callActivity", new ActivityDrawInstruction(){

            @Override
            public void draw(ProcessDiagramCanvas processDiagramCreator, ActivityImpl activityImpl) {
                processDiagramCreator.drawCollapsedCallActivity((String)activityImpl.getProperty("name"), activityImpl.getX(), activityImpl.getY(), activityImpl.getWidth(), activityImpl.getHeight());
            }
        });
    }

    protected static interface ActivityDrawInstruction {
        public void draw(ProcessDiagramCanvas var1, ActivityImpl var2);
    }
}

