/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.cmd;

import java.io.Serializable;
import java.util.Map;
import org.camunda.bpm.engine.exception.cmmn.CaseDefinitionNotFoundException;
import org.camunda.bpm.engine.impl.cmmn.CaseInstanceBuilderImpl;
import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.CaseInstance;

public class CreateCaseInstanceCmd
implements Command<CaseInstance>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionKey;
    protected String caseDefinitionId;
    protected Map<String, Object> variables;
    protected String businessKey;

    public CreateCaseInstanceCmd(CaseInstanceBuilderImpl builder) {
        this.caseDefinitionKey = builder.getCaseDefinitionKey();
        this.caseDefinitionId = builder.getCaseDefinitionId();
        this.businessKey = builder.getBusinessKey();
        this.variables = builder.getVariables();
    }

    @Override
    public CaseInstance execute(CommandContext commandContext) {
        DeploymentCache deploymentCache = Context.getProcessEngineConfiguration().getDeploymentCache();
        CaseDefinitionEntity caseDefinition = null;
        EnsureUtil.ensureAtLeastOneNotNull("caseDefinition and caseDefinitionKey are null", this.caseDefinitionId, this.caseDefinitionKey);
        if (this.caseDefinitionId != null) {
            caseDefinition = deploymentCache.findDeployedCaseDefinitionById(this.caseDefinitionId);
            EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "No case definition found for id = '" + this.caseDefinitionId + "'", "caseDefinition", (Object)caseDefinition);
        } else {
            caseDefinition = deploymentCache.findDeployedLatestCaseDefinitionByKey(this.caseDefinitionKey);
            EnsureUtil.ensureNotNull(CaseDefinitionNotFoundException.class, "No case definition found for key '" + this.caseDefinitionKey + "'", "caseDefinition", (Object)caseDefinition);
        }
        CaseExecutionEntity caseInstance = (CaseExecutionEntity)caseDefinition.createCaseInstance(this.businessKey);
        caseInstance.create(this.variables);
        return caseInstance;
    }
}

