/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmmn.entity.runtime;

import java.util.List;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.AbstractVariableQueryImpl;
import org.camunda.bpm.engine.impl.Page;
import org.camunda.bpm.engine.impl.QueryOperator;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionQueryProperty;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionState;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.util.EnsureUtil;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseExecutionQuery;

public class CaseExecutionQueryImpl
extends AbstractVariableQueryImpl<CaseExecutionQuery, CaseExecution>
implements CaseExecutionQuery {
    private static final long serialVersionUID = 1L;
    protected String caseDefinitionId;
    protected String caseDefinitionKey;
    protected String activityId;
    protected String caseExecutionId;
    protected String caseInstanceId;
    protected String businessKey;
    protected CaseExecutionState state;
    protected String superProcessInstanceId;
    protected String subProcessInstanceId;
    protected String superCaseInstanceId;
    protected String subCaseInstanceId;

    public CaseExecutionQueryImpl() {
    }

    public CaseExecutionQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public CaseExecutionQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public CaseExecutionQuery caseInstanceId(String caseInstanceId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseInstanceId", (Object)caseInstanceId);
        this.caseInstanceId = caseInstanceId;
        return this;
    }

    @Override
    public CaseExecutionQuery caseDefinitionId(String caseDefinitionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseDefinitionId", (Object)caseDefinitionId);
        this.caseDefinitionId = caseDefinitionId;
        return this;
    }

    @Override
    public CaseExecutionQuery caseDefinitionKey(String caseDefinitionKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseDefinitionKey", (Object)caseDefinitionKey);
        this.caseDefinitionKey = caseDefinitionKey;
        return this;
    }

    @Override
    public CaseExecutionQuery caseInstanceBusinessKey(String caseInstanceBusinessKey) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseInstanceBusinessKey", (Object)caseInstanceBusinessKey);
        this.businessKey = caseInstanceBusinessKey;
        return this;
    }

    @Override
    public CaseExecutionQuery caseExecutionId(String caseExecutionId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "caseExecutionId", (Object)caseExecutionId);
        this.caseExecutionId = caseExecutionId;
        return this;
    }

    @Override
    public CaseExecutionQuery activityId(String activityId) {
        EnsureUtil.ensureNotNull(NotValidException.class, "activityId", (Object)activityId);
        this.activityId = activityId;
        return this;
    }

    @Override
    public CaseExecutionQuery available() {
        this.state = CaseExecutionState.AVAILABLE;
        return this;
    }

    @Override
    public CaseExecutionQuery enabled() {
        this.state = CaseExecutionState.ENABLED;
        return this;
    }

    @Override
    public CaseExecutionQuery active() {
        this.state = CaseExecutionState.ACTIVE;
        return this;
    }

    @Override
    public CaseExecutionQuery disabled() {
        this.state = CaseExecutionState.DISABLED;
        return this;
    }

    @Override
    public CaseExecutionQuery caseInstanceVariableValueEquals(String name, Object value) {
        this.addVariable(name, value, QueryOperator.EQUALS, false);
        return this;
    }

    @Override
    public CaseExecutionQuery caseInstanceVariableValueNotEquals(String name, Object value) {
        this.addVariable(name, value, QueryOperator.NOT_EQUALS, false);
        return this;
    }

    @Override
    public CaseExecutionQuery caseInstanceVariableValueGreaterThan(String name, Object value) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN, false);
        return this;
    }

    @Override
    public CaseExecutionQuery caseInstanceVariableValueGreaterThanOrEqual(String name, Object value) {
        this.addVariable(name, value, QueryOperator.GREATER_THAN_OR_EQUAL, false);
        return this;
    }

    @Override
    public CaseExecutionQuery caseInstanceVariableValueLessThan(String name, Object value) {
        this.addVariable(name, value, QueryOperator.LESS_THAN, false);
        return this;
    }

    @Override
    public CaseExecutionQuery caseInstanceVariableValueLessThanOrEqual(String name, Object value) {
        this.addVariable(name, value, QueryOperator.LESS_THAN_OR_EQUAL, false);
        return this;
    }

    @Override
    public CaseExecutionQuery caseInstanceVariableValueLike(String name, String value) {
        this.addVariable(name, value, QueryOperator.LIKE, false);
        return this;
    }

    @Override
    public CaseExecutionQuery orderByCaseExecutionId() {
        this.orderBy(CaseExecutionQueryProperty.CASE_EXECUTION_ID);
        return this;
    }

    @Override
    public CaseExecutionQuery orderByCaseDefinitionKey() {
        this.orderBy(CaseExecutionQueryProperty.CASE_DEFINITION_ID);
        return this;
    }

    @Override
    public CaseExecutionQuery orderByCaseDefinitionId() {
        this.orderBy(CaseExecutionQueryProperty.CASE_DEFINITION_KEY);
        return this;
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        return commandContext.getCaseExecutionManager().findCaseExecutionCountByQueryCriteria(this);
    }

    @Override
    public List<CaseExecution> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        this.ensureVariablesInitialized();
        List<CaseExecution> result = commandContext.getCaseExecutionManager().findCaseExecutionsByQueryCriteria(this, page);
        for (CaseExecution caseExecution : result) {
            CaseExecutionEntity caseExecutionEntity = (CaseExecutionEntity)caseExecution;
            caseExecutionEntity.getActivity();
        }
        return result;
    }

    public String getCaseDefinitionId() {
        return this.caseDefinitionId;
    }

    public String getCaseDefinitionKey() {
        return this.caseDefinitionKey;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public String getCaseExecutionId() {
        return this.caseExecutionId;
    }

    public String getCaseInstanceId() {
        return this.caseInstanceId;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public CaseExecutionState getState() {
        return this.state;
    }

    public boolean isCaseInstancesOnly() {
        return false;
    }

    public String getSuperProcessInstanceId() {
        return this.superProcessInstanceId;
    }

    public String getSubProcessInstanceId() {
        return this.subProcessInstanceId;
    }

    public String getSuperCaseInstanceId() {
        return this.superCaseInstanceId;
    }

    public String getSubCaseInstanceId() {
        return this.subCaseInstanceId;
    }
}

