/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.history.producer;

import org.camunda.bpm.engine.delegate.DelegateCaseExecution;
import org.camunda.bpm.engine.impl.cmmn.entity.runtime.CaseExecutionEntity;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.event.HistoricCaseActivityInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoricCaseInstanceEventEntity;
import org.camunda.bpm.engine.impl.history.event.HistoryEvent;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.history.producer.CmmnHistoryEventProducer;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;

public class DefaultCmmnHistoryEventProducer
implements CmmnHistoryEventProducer {
    @Override
    public HistoryEvent createCaseInstanceCreateEvt(DelegateCaseExecution caseExecution) {
        ExecutionEntity superExecution;
        CaseExecutionEntity caseExecutionEntity = (CaseExecutionEntity)caseExecution;
        HistoricCaseInstanceEventEntity evt = this.newCaseInstanceEventEntity(caseExecutionEntity);
        this.initCaseInstanceEvent(evt, caseExecutionEntity, HistoryEventTypes.CASE_INSTANCE_CREATE);
        evt.setCreateTime(ClockUtil.getCurrentTime());
        evt.setCreateUserId(Context.getCommandContext().getAuthenticatedUserId());
        CmmnExecution superCaseExecution = caseExecutionEntity.getSuperCaseExecution();
        if (superCaseExecution != null) {
            evt.setSuperCaseInstanceId(superCaseExecution.getCaseInstanceId());
        }
        if ((superExecution = caseExecutionEntity.getSuperExecution()) != null) {
            evt.setSuperProcessInstanceId(superExecution.getProcessInstanceId());
        }
        return evt;
    }

    @Override
    public HistoryEvent createCaseInstanceUpdateEvt(DelegateCaseExecution caseExecution) {
        CaseExecutionEntity caseExecutionEntity = (CaseExecutionEntity)caseExecution;
        HistoricCaseInstanceEventEntity evt = this.loadCaseInstanceEventEntity(caseExecutionEntity);
        this.initCaseInstanceEvent(evt, caseExecutionEntity, HistoryEventTypes.CASE_INSTANCE_UPDATE);
        return evt;
    }

    @Override
    public HistoryEvent createCaseInstanceCloseEvt(DelegateCaseExecution caseExecution) {
        CaseExecutionEntity caseExecutionEntity = (CaseExecutionEntity)caseExecution;
        HistoricCaseInstanceEventEntity evt = this.loadCaseInstanceEventEntity(caseExecutionEntity);
        this.initCaseInstanceEvent(evt, caseExecutionEntity, HistoryEventTypes.CASE_INSTANCE_CLOSE);
        evt.setEndTime(ClockUtil.getCurrentTime());
        if (evt.getStartTime() != null) {
            evt.setDurationInMillis(evt.getEndTime().getTime() - evt.getStartTime().getTime());
        }
        return evt;
    }

    @Override
    public HistoryEvent createCaseActivityInstanceCreateEvt(DelegateCaseExecution caseExecution) {
        CaseExecutionEntity caseExecutionEntity = (CaseExecutionEntity)caseExecution;
        HistoricCaseActivityInstanceEventEntity evt = this.newCaseActivityInstanceEventEntity(caseExecutionEntity);
        this.initCaseActivityInstanceEvent(evt, caseExecutionEntity, HistoryEventTypes.CASE_ACTIVITY_INSTANCE_CREATE);
        evt.setCreateTime(ClockUtil.getCurrentTime());
        return evt;
    }

    @Override
    public HistoryEvent createCaseActivityInstanceUpdateEvt(DelegateCaseExecution caseExecution) {
        CaseExecutionEntity caseExecutionEntity = (CaseExecutionEntity)caseExecution;
        HistoricCaseActivityInstanceEventEntity evt = this.loadCaseActivityInstanceEventEntity(caseExecutionEntity);
        this.initCaseActivityInstanceEvent(evt, caseExecutionEntity, HistoryEventTypes.CASE_ACTIVITY_INSTANCE_UPDATE);
        if (caseExecutionEntity.getTask() != null) {
            evt.setTaskId(caseExecutionEntity.getTask().getId());
        }
        if (caseExecutionEntity.getSubProcessInstance() != null) {
            evt.setCalledProcessInstanceId(caseExecutionEntity.getSubProcessInstance().getId());
        }
        if (caseExecutionEntity.getSubCaseInstance() != null) {
            evt.setCalledCaseInstanceId(caseExecutionEntity.getSubCaseInstance().getId());
        }
        return evt;
    }

    @Override
    public HistoryEvent createCaseActivityInstanceEndEvt(DelegateCaseExecution caseExecution) {
        CaseExecutionEntity caseExecutionEntity = (CaseExecutionEntity)caseExecution;
        HistoricCaseActivityInstanceEventEntity evt = this.loadCaseActivityInstanceEventEntity(caseExecutionEntity);
        this.initCaseActivityInstanceEvent(evt, caseExecutionEntity, HistoryEventTypes.CASE_ACTIVITY_INSTANCE_END);
        evt.setEndTime(ClockUtil.getCurrentTime());
        if (evt.getStartTime() != null) {
            evt.setDurationInMillis(evt.getEndTime().getTime() - evt.getStartTime().getTime());
        }
        return evt;
    }

    protected HistoricCaseInstanceEventEntity newCaseInstanceEventEntity(CaseExecutionEntity caseExecutionEntity) {
        return new HistoricCaseInstanceEventEntity();
    }

    protected HistoricCaseInstanceEventEntity loadCaseInstanceEventEntity(CaseExecutionEntity caseExecutionEntity) {
        return this.newCaseInstanceEventEntity(caseExecutionEntity);
    }

    protected void initCaseInstanceEvent(HistoricCaseInstanceEventEntity evt, CaseExecutionEntity caseExecutionEntity, HistoryEventTypes eventType) {
        evt.setId(caseExecutionEntity.getCaseInstanceId());
        evt.setEventType(eventType.getEventName());
        evt.setCaseDefinitionId(caseExecutionEntity.getCaseDefinitionId());
        evt.setCaseInstanceId(caseExecutionEntity.getCaseInstanceId());
        evt.setCaseExecutionId(caseExecutionEntity.getId());
        evt.setBusinessKey(caseExecutionEntity.getBusinessKey());
        evt.setState(caseExecutionEntity.getState());
    }

    protected HistoricCaseActivityInstanceEventEntity newCaseActivityInstanceEventEntity(CaseExecutionEntity caseExecutionEntity) {
        return new HistoricCaseActivityInstanceEventEntity();
    }

    protected HistoricCaseActivityInstanceEventEntity loadCaseActivityInstanceEventEntity(CaseExecutionEntity caseExecutionEntity) {
        return this.newCaseActivityInstanceEventEntity(caseExecutionEntity);
    }

    protected void initCaseActivityInstanceEvent(HistoricCaseActivityInstanceEventEntity evt, CaseExecutionEntity caseExecutionEntity, HistoryEventTypes eventType) {
        evt.setId(caseExecutionEntity.getId());
        evt.setParentCaseActivityInstanceId(caseExecutionEntity.getParentId());
        evt.setEventType(eventType.getEventName());
        evt.setCaseDefinitionId(caseExecutionEntity.getCaseDefinitionId());
        evt.setCaseInstanceId(caseExecutionEntity.getCaseInstanceId());
        evt.setCaseExecutionId(caseExecutionEntity.getId());
        evt.setCaseActivityInstanceState(caseExecutionEntity.getState());
        evt.setCaseActivityId(caseExecutionEntity.getActivityId());
        evt.setCaseActivityName(caseExecutionEntity.getActivityName());
        evt.setCaseActivityType(caseExecutionEntity.getActivityType());
    }
}

