/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.interceptor;

import java.util.logging.Logger;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.RetryInterceptor;

public class JtaRetryInterceptor
extends RetryInterceptor {
    private final Logger log = Logger.getLogger(JtaRetryInterceptor.class.getName());
    protected final TransactionManager transactionManager;

    public JtaRetryInterceptor(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    @Override
    public <T> T execute(Command<T> command) {
        if (this.calledInsideTransaction()) {
            this.log.finest("Called inside transaction, skipping the retry interceptor.");
            return this.next.execute(command);
        }
        return super.execute(command);
    }

    protected boolean calledInsideTransaction() {
        try {
            return this.transactionManager.getStatus() != 6;
        }
        catch (SystemException e) {
            throw new ProcessEngineException("Could not determine the current status of the transaction manager: " + e.getMessage(), e);
        }
    }
}

