/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.TransitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class AsyncContinuationJobHandler
implements JobHandler {
    public static final String TYPE = "async-continuation";
    private Map<String, PvmAtomicOperation> supportedOperations = new HashMap<String, PvmAtomicOperation>();

    public AsyncContinuationJobHandler() {
        this.supportedOperations.put(PvmAtomicOperation.TRANSITION_CREATE_SCOPE.getCanonicalName(), PvmAtomicOperation.TRANSITION_CREATE_SCOPE);
        this.supportedOperations.put(PvmAtomicOperation.PROCESS_START.getCanonicalName(), PvmAtomicOperation.PROCESS_START);
        this.supportedOperations.put(PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE.getCanonicalName(), PvmAtomicOperation.TRANSITION_NOTIFY_LISTENER_TAKE);
        this.supportedOperations.put(PvmAtomicOperation.ACTIVITY_END.getCanonicalName(), PvmAtomicOperation.ACTIVITY_END);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext) {
        String operationName = null;
        String transitionId = null;
        if (configuration != null) {
            if (configuration.contains("$")) {
                String[] configParts = configuration.split("\\$");
                if (configParts.length != 2) {
                    throw new ProcessEngineException("Illegal async continuation job handler configuration: '" + configuration + "': exprecting two parts seperated by '$'.");
                }
                operationName = configParts[0];
                transitionId = configParts[1];
            } else {
                operationName = configuration;
            }
        }
        PvmAtomicOperation atomicOperation = this.findMatchingAtomicOperation(operationName);
        EnsureUtil.ensureNotNull("Cannot process job with configuration " + configuration, "atomicOperation", (Object)atomicOperation);
        if (transitionId != null) {
            ActivityImpl activity = execution.getActivity();
            TransitionImpl transition = activity.findOutgoingTransition(transitionId);
            execution.setTransition(transition);
        }
        commandContext.performOperation(atomicOperation, execution);
    }

    protected PvmAtomicOperation findMatchingAtomicOperation(String configuration) {
        if (configuration == null) {
            return PvmAtomicOperation.TRANSITION_CREATE_SCOPE;
        }
        return this.supportedOperations.get(configuration);
    }
}

