/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineServices;
import org.camunda.bpm.engine.delegate.BpmnModelExecutionContext;
import org.camunda.bpm.engine.delegate.ProcessEngineServicesAware;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionImpl;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnExecution;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.core.variable.scope.CoreVariableStore;
import org.camunda.bpm.engine.impl.core.variable.scope.SimpleVariableStore;
import org.camunda.bpm.engine.impl.pvm.PvmProcessDefinition;
import org.camunda.bpm.engine.impl.pvm.PvmProcessInstance;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.ExecutionStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.ProcessInstanceStartContext;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.FlowElement;

public class ExecutionImpl
extends PvmExecutionImpl
implements Serializable,
ActivityExecution,
PvmProcessInstance {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(ExecutionImpl.class.getName());
    private static AtomicInteger idGenerator = new AtomicInteger();
    protected ExecutionImpl processInstance;
    protected ExecutionImpl parent;
    protected List<ExecutionImpl> executions;
    protected ExecutionImpl superExecution;
    protected ExecutionImpl subProcessInstance;
    protected CaseExecutionImpl superCaseExecution;
    protected CaseExecutionImpl subCaseInstance;
    protected ExecutionImpl replacedBy;
    protected SimpleVariableStore variableStore = new SimpleVariableStore();

    public ExecutionImpl() {
    }

    public ExecutionImpl(ActivityImpl startActivity) {
        super(startActivity);
    }

    @Override
    public ExecutionImpl createExecution(boolean initializeExecutionStartContext) {
        ExecutionImpl createdExecution = this.newExecution();
        this.getExecutions().add(createdExecution);
        createdExecution.setParent(this);
        createdExecution.setProcessDefinition(this.getProcessDefinition());
        createdExecution.setProcessInstance(this.getProcessInstance());
        createdExecution.setActivity(this.getActivity());
        createdExecution.activityInstanceId = this.activityInstanceId;
        if (initializeExecutionStartContext) {
            createdExecution.setStartContext(new ExecutionStartContext());
        }
        return createdExecution;
    }

    protected ExecutionImpl newExecution() {
        return new ExecutionImpl();
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey) {
        ExecutionImpl processInstance = this.getProcessInstance();
        String caseInstanceId = processInstance.getCaseInstanceId();
        return this.createSubProcessInstance(processDefinition, businessKey, caseInstanceId);
    }

    @Override
    public PvmExecutionImpl createSubProcessInstance(PvmProcessDefinition processDefinition, String businessKey, String caseInstanceId) {
        ExecutionImpl subProcessInstance = this.newExecution();
        subProcessInstance.setSuperExecution(this);
        this.setSubProcessInstance(subProcessInstance);
        subProcessInstance.setProcessDefinition((ProcessDefinitionImpl)processDefinition);
        subProcessInstance.setProcessInstance(subProcessInstance);
        if (businessKey != null) {
            subProcessInstance.setBusinessKey(businessKey);
        }
        if (caseInstanceId != null) {
            subProcessInstance.setCaseInstanceId(caseInstanceId);
        }
        return subProcessInstance;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void interruptScope(String reason) {
    }

    @Override
    public ExecutionImpl getParent() {
        return this.parent;
    }

    @Override
    public void setParent(PvmExecutionImpl parent) {
        this.parent = (ExecutionImpl)parent;
    }

    public List<ExecutionImpl> getExecutions() {
        if (this.executions == null) {
            this.executions = new ArrayList<ExecutionImpl>();
        }
        return this.executions;
    }

    @Override
    public ExecutionImpl getSuperExecution() {
        return this.superExecution;
    }

    @Override
    public void setSuperExecution(PvmExecutionImpl superExecution) {
        this.superExecution = (ExecutionImpl)superExecution;
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
        }
    }

    @Override
    public ExecutionImpl getSubProcessInstance() {
        return this.subProcessInstance;
    }

    @Override
    public void setSubProcessInstance(PvmExecutionImpl subProcessInstance) {
        this.subProcessInstance = (ExecutionImpl)subProcessInstance;
    }

    @Override
    public CaseExecutionImpl getSuperCaseExecution() {
        return this.superCaseExecution;
    }

    @Override
    public void setSuperCaseExecution(CmmnExecution superCaseExecution) {
        this.superCaseExecution = (CaseExecutionImpl)superCaseExecution;
    }

    @Override
    public CaseExecutionImpl getSubCaseInstance() {
        return this.subCaseInstance;
    }

    @Override
    public void setSubCaseInstance(CmmnExecution subCaseInstance) {
        this.subCaseInstance = (CaseExecutionImpl)subCaseInstance;
    }

    @Override
    public CaseExecutionImpl createSubCaseInstance(CmmnCaseDefinition caseDefinition) {
        return this.createSubCaseInstance(caseDefinition, null);
    }

    @Override
    public CaseExecutionImpl createSubCaseInstance(CmmnCaseDefinition caseDefinition, String businessKey) {
        CaseExecutionImpl caseInstance = (CaseExecutionImpl)caseDefinition.createCaseInstance(businessKey);
        this.subCaseInstance.setSuperExecution(this);
        this.setSubCaseInstance(this.subCaseInstance);
        return caseInstance;
    }

    @Override
    public String getProcessDefinitionId() {
        return this.processDefinition.getId();
    }

    @Override
    public void start(Map<String, Object> variables) {
        if (this.isProcessInstanceExecution() && this.processInstanceStartContext == null) {
            this.processInstanceStartContext = new ProcessInstanceStartContext(this.processDefinition.getInitial());
        }
        super.start(variables);
    }

    @Override
    public ExecutionImpl getProcessInstance() {
        return this.processInstance;
    }

    @Override
    public String getProcessInstanceId() {
        return this.getProcessInstance().getId();
    }

    @Override
    public String getBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    @Override
    public String getProcessBusinessKey() {
        return this.getProcessInstance().getBusinessKey();
    }

    @Override
    public void setProcessInstance(PvmExecutionImpl processInstance) {
        this.processInstance = (ExecutionImpl)processInstance;
    }

    @Override
    protected String generateActivityInstanceId(String activityId) {
        int nextId = idGenerator.incrementAndGet();
        String compositeId = activityId + ":" + nextId;
        if (compositeId.length() > 64) {
            return String.valueOf(nextId);
        }
        return compositeId;
    }

    @Override
    public String toString() {
        if (this.isProcessInstanceExecution()) {
            return "ProcessInstance[" + this.getToStringIdentity() + "]";
        }
        return (this.isEventScope ? "EventScope" : "") + (this.isConcurrent ? "Concurrent" : "") + (this.isScope() ? "Scope" : "") + "Execution[" + this.getToStringIdentity() + "]";
    }

    @Override
    protected String getToStringIdentity() {
        return Integer.toString(System.identityHashCode(this));
    }

    @Override
    public String getId() {
        return String.valueOf(System.identityHashCode(this));
    }

    @Override
    protected CoreVariableStore getVariableStore() {
        return this.variableStore;
    }

    @Override
    public PvmExecutionImpl getReplacedBy() {
        return this.replacedBy;
    }

    @Override
    public void setReplacedBy(PvmExecutionImpl replacedBy) {
        this.replacedBy = (ExecutionImpl)replacedBy;
        super.setReplacedBy(replacedBy);
    }

    public void setExecutions(List<ExecutionImpl> executions) {
        this.executions = executions;
    }

    @Override
    public String getCurrentActivityName() {
        String currentActivityName = null;
        if (this.activity != null) {
            currentActivityName = (String)this.activity.getProperty("name");
        }
        return currentActivityName;
    }

    @Override
    public FlowElement getBpmnModelElementInstance() {
        throw new UnsupportedOperationException(BpmnModelExecutionContext.class.getName() + " is unsupported in transient ExecutionImpl");
    }

    @Override
    public BpmnModelInstance getBpmnModelInstance() {
        throw new UnsupportedOperationException(BpmnModelExecutionContext.class.getName() + " is unsupported in transient ExecutionImpl");
    }

    @Override
    public ProcessEngineServices getProcessEngineServices() {
        throw new UnsupportedOperationException(ProcessEngineServicesAware.class.getName() + " is unsupported in transient ExecutionImpl");
    }
}

