/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import org.camunda.bpm.engine.impl.cmmn.entity.repository.CaseDefinitionEntity;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.model.CallableElement;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.persistence.deploy.DeploymentCache;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ProcessDefinitionImpl;

public class CallableElementUtil {
    public static DeploymentCache getDeploymentCache() {
        return Context.getProcessEngineConfiguration().getDeploymentCache();
    }

    public static ProcessDefinitionImpl getProcessDefinitionToCall(AbstractVariableScope execution, CallableElement callableElement) {
        String processDefinitionKey = callableElement.getDefinitionKey(execution);
        DeploymentCache deploymentCache = CallableElementUtil.getDeploymentCache();
        ProcessDefinitionEntity processDefinition = null;
        if (callableElement.isLatestBinding()) {
            processDefinition = deploymentCache.findDeployedLatestProcessDefinitionByKey(processDefinitionKey);
        } else if (callableElement.isDeploymentBinding()) {
            String deploymentId = callableElement.getDeploymentId();
            processDefinition = deploymentCache.findDeployedProcessDefinitionByDeploymentAndKey(deploymentId, processDefinitionKey);
        } else if (callableElement.isVersionBinding()) {
            Integer version = callableElement.getVersion(execution);
            processDefinition = deploymentCache.findDeployedProcessDefinitionByKeyAndVersion(processDefinitionKey, version);
        }
        return processDefinition;
    }

    public static CmmnCaseDefinition getCaseDefinitionToCall(AbstractVariableScope execution, CallableElement callableElement) {
        String caseDefinitionKey = callableElement.getDefinitionKey(execution);
        DeploymentCache deploymentCache = CallableElementUtil.getDeploymentCache();
        CaseDefinitionEntity caseDefinition = null;
        if (callableElement.isLatestBinding()) {
            caseDefinition = deploymentCache.findDeployedLatestCaseDefinitionByKey(caseDefinitionKey);
        } else if (callableElement.isDeploymentBinding()) {
            String deploymentId = callableElement.getDeploymentId();
            caseDefinition = deploymentCache.findDeployedCaseDefinitionByDeploymentAndKey(deploymentId, caseDefinitionKey);
        } else if (callableElement.isVersionBinding()) {
            Integer version = callableElement.getVersion(execution);
            caseDefinition = deploymentCache.findDeployedCaseDefinitionByKeyAndVersion(caseDefinitionKey, version);
        }
        return caseDefinition;
    }
}

