/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.bpmn.behavior;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.BpmnError;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.FlowNodeActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.behavior.SubProcessActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.delegate.ExecutionListenerInvocation;
import org.camunda.bpm.engine.impl.bpmn.helper.ErrorPropagation;
import org.camunda.bpm.engine.impl.bpmn.helper.ScopeUtil;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.core.variable.mapping.IoMapping;
import org.camunda.bpm.engine.impl.core.variable.scope.AbstractVariableScope;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityExecution;
import org.camunda.bpm.engine.impl.pvm.delegate.CompositeActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public abstract class MultiInstanceActivityBehavior
extends FlowNodeActivityBehavior
implements CompositeActivityBehavior,
org.camunda.bpm.engine.impl.pvm.delegate.SubProcessActivityBehavior {
    protected static final Logger LOGGER = Logger.getLogger(MultiInstanceActivityBehavior.class.getName());
    protected final String NUMBER_OF_INSTANCES = "nrOfInstances";
    protected final String NUMBER_OF_ACTIVE_INSTANCES = "nrOfActiveInstances";
    protected final String NUMBER_OF_COMPLETED_INSTANCES = "nrOfCompletedInstances";
    protected final String LOOP_COUNTER = "loopCounter";
    protected ActivityImpl activity;
    protected AbstractBpmnActivityBehavior innerActivityBehavior;
    protected Expression loopCardinalityExpression;
    protected Expression completionConditionExpression;
    protected Expression collectionExpression;
    protected String collectionVariable;
    protected String collectionElementVariable;
    protected IoMapping ioMapping;

    public MultiInstanceActivityBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.activity = activity;
        this.setInnerActivityBehavior(innerActivityBehavior);
    }

    @Override
    public void execute(ActivityExecution execution) throws Exception {
        if (this.getLocalLoopVariable(execution, "loopCounter") == null) {
            try {
                if (!this.createInstancesIfPossible(execution)) {
                    super.leave(execution);
                }
            }
            catch (BpmnError error) {
                ErrorPropagation.propagateError(error, execution);
            }
            catch (Exception ex) {
                ErrorPropagation.propagateException(ex, execution);
            }
        } else {
            this.innerActivityBehavior.execute(execution);
        }
    }

    protected boolean createInstancesIfPossible(ActivityExecution execution) throws Exception {
        int nrOfInstances = this.resolveNrOfInstances(execution);
        if (nrOfInstances == 0) {
            return false;
        }
        if (nrOfInstances < 0) {
            throw new ProcessEngineException("Invalid number of instances: must be positive integer value or zero, but was " + nrOfInstances);
        }
        this.createInstances(execution, nrOfInstances);
        return true;
    }

    protected abstract void createInstances(ActivityExecution var1, int var2) throws Exception;

    @Override
    public void signal(ActivityExecution execution, String signalName, Object signalData) throws Exception {
        this.innerActivityBehavior.signal(execution, signalName, signalData);
    }

    @Override
    public void lastExecutionEnded(ActivityExecution execution) {
        ScopeUtil.createEventScopeExecution((ExecutionEntity)execution);
        this.leave(execution);
    }

    @Override
    public void completing(VariableScope execution, VariableScope subProcessInstance) throws Exception {
    }

    @Override
    public void completed(ActivityExecution execution) throws Exception {
        this.leave(execution);
    }

    protected int resolveNrOfInstances(ActivityExecution execution) {
        int nrOfInstances = -1;
        if (this.loopCardinalityExpression != null) {
            nrOfInstances = this.resolveLoopCardinality(execution);
        } else if (this.collectionExpression != null) {
            Object obj = this.collectionExpression.getValue(execution);
            if (!(obj instanceof Collection)) {
                throw new ProcessEngineException(this.collectionExpression.getExpressionText() + "' didn't resolve to a Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else if (this.collectionVariable != null) {
            Object obj = execution.getVariable(this.collectionVariable);
            if (!(obj instanceof Collection)) {
                throw new ProcessEngineException("Variable " + this.collectionVariable + "' is not a Collection");
            }
            nrOfInstances = ((Collection)obj).size();
        } else {
            throw new ProcessEngineException("Couldn't resolve collection expression nor variable reference");
        }
        return nrOfInstances;
    }

    protected void executeOriginalBehavior(ActivityExecution execution, int loopCounter) throws Exception {
        if (this.usesCollection() && this.collectionElementVariable != null) {
            Collection collection = null;
            if (this.collectionExpression != null) {
                collection = (Collection)this.collectionExpression.getValue(execution);
            } else if (this.collectionVariable != null) {
                collection = (Collection)execution.getVariable(this.collectionVariable);
            }
            Object value = this.getElementAtIndex(loopCounter, collection);
            this.setLoopVariable(execution, this.collectionElementVariable, value);
        }
        this.doExecuteOriginalBehavior(execution, loopCounter);
    }

    protected abstract void doExecuteOriginalBehavior(ActivityExecution var1, int var2) throws Exception;

    protected Object getElementAtIndex(int i, Collection<?> collection) {
        Object value = null;
        Iterator<?> it = collection.iterator();
        for (int index = 0; index <= i; ++index) {
            value = it.next();
        }
        return value;
    }

    protected boolean usesCollection() {
        return this.collectionExpression != null || this.collectionVariable != null;
    }

    public boolean isExtraScopeNeeded() {
        return this.innerActivityBehavior instanceof SubProcessActivityBehavior;
    }

    protected int resolveLoopCardinality(ActivityExecution execution) {
        Object value = this.loopCardinalityExpression.getValue(execution);
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            return Integer.valueOf((String)value);
        }
        throw new ProcessEngineException("Could not resolve loopCardinality expression '" + this.loopCardinalityExpression.getExpressionText() + "': not a number nor number String");
    }

    protected boolean completionConditionSatisfied(ActivityExecution execution) {
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue(execution);
            if (!(value instanceof Boolean)) {
                throw new ProcessEngineException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Completion condition of multi-instance satisfied: " + booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    protected void setLoopVariable(ActivityExecution execution, String variableName, Object value) {
        execution.setVariableLocal(variableName, value);
    }

    protected Integer getLoopVariable(ActivityExecution execution, String variableName) {
        Object value = execution.getVariableLocal(variableName);
        for (ActivityExecution parent = execution.getParent(); value == null && parent != null; parent = parent.getParent()) {
            value = parent.getVariableLocal(variableName);
        }
        EnsureUtil.ensureNotNull("The variable \"" + variableName + "\" could not be found in execution with id " + execution.getId(), "value", value);
        return (Integer)value;
    }

    protected Integer getLocalLoopVariable(ActivityExecution execution, String variableName) {
        return (Integer)execution.getVariableLocal(variableName);
    }

    protected void callActivityEndListeners(ActivityExecution execution) {
        List<ExecutionListener> listeners = this.activity.getExecutionListeners("end");
        for (ExecutionListener executionListener : listeners) {
            try {
                Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation(new ExecutionListenerInvocation(executionListener, execution));
            }
            catch (Exception e) {
                throw new ProcessEngineException("Couldn't execute end listener", e);
            }
        }
    }

    protected void logLoopDetails(ActivityExecution execution, String custom, int loopCounter, int nrOfCompletedInstances, int nrOfActiveInstances, int nrOfInstances) {
        if (LOGGER.isLoggable(Level.FINE)) {
            StringBuilder strb = new StringBuilder();
            strb.append("Multi-instance '" + execution.getActivity() + "' " + custom + ". ");
            strb.append("Details: loopCounter=" + loopCounter + ", ");
            strb.append("nrOrCompletedInstances=" + nrOfCompletedInstances + ", ");
            strb.append("nrOfActiveInstances=" + nrOfActiveInstances + ", ");
            strb.append("nrOfInstances=" + nrOfInstances);
            LOGGER.fine(strb.toString());
        }
    }

    public Expression getLoopCardinalityExpression() {
        return this.loopCardinalityExpression;
    }

    public void setLoopCardinalityExpression(Expression loopCardinalityExpression) {
        this.loopCardinalityExpression = loopCardinalityExpression;
    }

    public Expression getCompletionConditionExpression() {
        return this.completionConditionExpression;
    }

    public void setCompletionConditionExpression(Expression completionConditionExpression) {
        this.completionConditionExpression = completionConditionExpression;
    }

    public Expression getCollectionExpression() {
        return this.collectionExpression;
    }

    public void setCollectionExpression(Expression collectionExpression) {
        this.collectionExpression = collectionExpression;
    }

    public String getCollectionVariable() {
        return this.collectionVariable;
    }

    public void setCollectionVariable(String collectionVariable) {
        this.collectionVariable = collectionVariable;
    }

    public String getCollectionElementVariable() {
        return this.collectionElementVariable;
    }

    public void setCollectionElementVariable(String collectionElementVariable) {
        this.collectionElementVariable = collectionElementVariable;
    }

    public void setInnerActivityBehavior(AbstractBpmnActivityBehavior innerActivityBehavior) {
        this.innerActivityBehavior = innerActivityBehavior;
        this.innerActivityBehavior.setMultiInstanceActivityBehavior(this);
    }

    public void setIoMapping(IoMapping ioMapping) {
        this.ioMapping = ioMapping;
    }

    protected void executeIoMapping(AbstractVariableScope scope) {
        if (this.ioMapping != null) {
            this.ioMapping.executeInputParameters(scope);
        }
    }
}

