/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cmd;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.EventSubscriptionEntity;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class MessageEventReceivedCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final String executionId;
    protected final Map<String, Object> processVariables;
    protected final String messageName;

    public MessageEventReceivedCmd(String messageName, String executionId, Map<String, Object> processVariables) {
        this.executionId = executionId;
        this.messageName = messageName;
        this.processVariables = processVariables;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        EnsureUtil.ensureNotNull("executionId", (Object)this.executionId);
        List<EventSubscriptionEntity> eventSubscriptions = null;
        eventSubscriptions = this.messageName != null ? commandContext.getEventSubscriptionManager().findEventSubscriptionsByNameAndExecution("message", this.messageName, this.executionId) : commandContext.getEventSubscriptionManager().findEventSubscriptionsByExecutionAndType(this.executionId, "message");
        if (eventSubscriptions.isEmpty()) {
            throw new ProcessEngineException("Execution with id '" + this.executionId + "' does not have a subscription to a message event with name '" + this.messageName + "'");
        }
        EnsureUtil.ensureNumberOfElements("More than one matching message subscription found for execution " + this.executionId, "eventSubscriptions", eventSubscriptions, 1);
        EventSubscriptionEntity eventSubscriptionEntity = eventSubscriptions.get(0);
        HashMap<String, Object> payload = null;
        if (this.processVariables != null) {
            payload = new HashMap<String, Object>(this.processVariables);
        }
        eventSubscriptionEntity.eventReceived(payload, false);
        return null;
    }
}

