/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.VariableScope;
import org.camunda.bpm.engine.impl.core.model.CallableElementParameter;
import org.camunda.bpm.engine.impl.core.variable.VariableMapImpl;
import org.camunda.bpm.engine.impl.core.variable.mapping.value.ParameterValueProvider;
import org.camunda.bpm.engine.variable.VariableMap;

public class CallableElement {
    protected ParameterValueProvider definitionKeyValueProvider;
    protected CallableElementBinding binding;
    protected ParameterValueProvider versionValueProvider;
    protected ParameterValueProvider businessKeyValueProvider;
    protected List<CallableElementParameter> inputs = new ArrayList<CallableElementParameter>();
    protected List<CallableElementParameter> outputs = new ArrayList<CallableElementParameter>();
    protected String deploymentId;

    public String getDefinitionKey(VariableScope variableScope) {
        Object result = this.definitionKeyValueProvider.getValue(variableScope);
        if (result != null && !(result instanceof String)) {
            throw new ClassCastException("Cannot cast '" + result + "' to String");
        }
        return (String)result;
    }

    public ParameterValueProvider getDefinitionKeyValueProvider() {
        return this.definitionKeyValueProvider;
    }

    public void setDefinitionKeyValueProvider(ParameterValueProvider definitionKey) {
        this.definitionKeyValueProvider = definitionKey;
    }

    public CallableElementBinding getBinding() {
        return this.binding;
    }

    public void setBinding(CallableElementBinding binding) {
        this.binding = binding;
    }

    public boolean isLatestBinding() {
        CallableElementBinding binding = this.getBinding();
        return binding == null || CallableElementBinding.LATEST.equals((Object)binding);
    }

    public boolean isDeploymentBinding() {
        CallableElementBinding binding = this.getBinding();
        return CallableElementBinding.DEPLOYMENT.equals((Object)binding);
    }

    public boolean isVersionBinding() {
        CallableElementBinding binding = this.getBinding();
        return CallableElementBinding.VERSION.equals((Object)binding);
    }

    public Integer getVersion(VariableScope variableScope) {
        Object result = this.versionValueProvider.getValue(variableScope);
        if (result != null) {
            if (result instanceof String) {
                return Integer.valueOf((String)result);
            }
            if (result instanceof Integer) {
                return (Integer)result;
            }
            throw new ProcessEngineException("It is not possible to transform '" + result + "' into an integer.");
        }
        return null;
    }

    public ParameterValueProvider getVersionValueProvider() {
        return this.versionValueProvider;
    }

    public void setVersionValueProvider(ParameterValueProvider version) {
        this.versionValueProvider = version;
    }

    public String getBusinessKey(VariableScope variableScope) {
        if (this.businessKeyValueProvider == null) {
            return null;
        }
        Object result = this.businessKeyValueProvider.getValue(variableScope);
        if (result != null && !(result instanceof String)) {
            throw new ClassCastException("Cannot cast '" + result + "' to String");
        }
        return (String)result;
    }

    public ParameterValueProvider getBusinessKeyValueProvider() {
        return this.businessKeyValueProvider;
    }

    public void setBusinessKeyValueProvider(ParameterValueProvider businessKeyValueProvider) {
        this.businessKeyValueProvider = businessKeyValueProvider;
    }

    public List<CallableElementParameter> getInputs() {
        return this.inputs;
    }

    public void addInput(CallableElementParameter input) {
        this.inputs.add(input);
    }

    public void addInputs(List<CallableElementParameter> inputs) {
        this.inputs.addAll(inputs);
    }

    public VariableMap getInputVariables(VariableScope variableScope) {
        List<CallableElementParameter> inputs = this.getInputs();
        return this.getVariables(inputs, variableScope);
    }

    public List<CallableElementParameter> getOutputs() {
        return this.outputs;
    }

    public void addOutput(CallableElementParameter output) {
        this.outputs.add(output);
    }

    public void addOutputs(List<CallableElementParameter> outputs) {
        this.outputs.addAll(outputs);
    }

    public VariableMap getOutputVariables(VariableScope variableScope) {
        List<CallableElementParameter> outputs = this.getOutputs();
        return this.getVariables(outputs, variableScope);
    }

    protected VariableMap getVariables(List<CallableElementParameter> params, VariableScope variableScope) {
        VariableMapImpl result = new VariableMapImpl();
        for (CallableElementParameter param : params) {
            if (param.isAllVariables()) {
                Map<String, Object> allVariables = variableScope.getVariables();
                result.putAll(allVariables);
                continue;
            }
            String targetVariableName = param.getTarget();
            Object value = param.getSource(variableScope);
            result.put(targetVariableName, value);
        }
        return result;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public static enum CallableElementBinding {
        LATEST("latest"),
        DEPLOYMENT("deployment"),
        VERSION("version");

        private String value;

        private CallableElementBinding(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

