/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.jobexecutor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.jobexecutor.TimerEventJobHandler;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.util.EnsureUtil;

public class TimerExecuteNestedActivityJobHandler
extends TimerEventJobHandler {
    private static Logger log = Logger.getLogger(TimerExecuteNestedActivityJobHandler.class.getName());
    public static final String TYPE = "timer-transition";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void execute(String configuration, ExecutionEntity execution, CommandContext commandContext) {
        String activityId = TimerExecuteNestedActivityJobHandler.getKey(configuration);
        ActivityImpl borderEventActivity = execution.getProcessDefinition().findActivity(activityId);
        EnsureUtil.ensureNotNull("Error while firing timer: border event activity " + configuration + " not found", "borderEventActivity", (Object)borderEventActivity);
        try {
            execution.executeActivity(borderEventActivity);
        }
        catch (RuntimeException e) {
            log.log(Level.SEVERE, "exception during timer execution", e);
            throw e;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "exception during timer execution", e);
            throw new ProcessEngineException("exception during timer execution: " + e.getMessage(), e);
        }
    }
}

