/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.pvm.runtime.operation;

import java.util.List;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.PvmExecutionImpl;
import org.camunda.bpm.engine.impl.pvm.runtime.operation.PvmAtomicOperation;

public abstract class PvmAtomicOperationCreateConcurrentExecution
implements PvmAtomicOperation {
    @Override
    public void execute(PvmExecutionImpl execution) {
        PvmExecutionImpl propagatingExecution = execution;
        ActivityImpl concurrentActivity = execution.getNextActivity();
        ScopeImpl concurrencyScope = concurrentActivity.getScope();
        if (this.isLeaf(execution)) {
            if (execution.getActivity() != null && execution.isScope() && !execution.getActivity().isScope() && concurrencyScope == execution.getActivity().getParent()) {
                PvmExecutionImpl replacingExecution = execution.createExecution();
                replacingExecution.replace(execution);
                replacingExecution.setActivity(execution.getActivity());
                replacingExecution.setActive(execution.isActive());
                replacingExecution.setScope(false);
                replacingExecution.setConcurrent(true);
                execution.setActive(false);
                execution.setActivity(null);
                propagatingExecution = this.createConcurrentExecution(execution, concurrentActivity);
            } else {
                PvmExecutionImpl parent = execution.getParent();
                if (!parent.isConcurrent()) {
                    execution.setConcurrent(true);
                } else {
                    parent = parent.getParent();
                }
                propagatingExecution = this.createConcurrentExecution(parent, concurrentActivity);
            }
        } else {
            List<? extends PvmExecutionImpl> childExecutions = execution.getExecutions();
            if (childExecutions.size() == 1 && execution.getActivity() == null && !execution.isActive()) {
                PvmExecutionImpl concurrentRoot = execution;
                ScopeImpl parentScope = concurrentActivity.getParent();
                if (parentScope == concurrencyScope) {
                    PvmExecutionImpl existingChild = childExecutions.get(0);
                    existingChild.setConcurrent(true);
                } else if (!(concurrentRoot = concurrentRoot.getParent()).isConcurrent()) {
                    execution.setConcurrent(true);
                } else {
                    concurrentRoot = concurrentRoot.getParent();
                }
                propagatingExecution = this.createConcurrentExecution(concurrentRoot, concurrentActivity);
            } else {
                PvmExecutionImpl concurrentRoot = execution;
                ScopeImpl parentScope = concurrentActivity.getParent();
                if (parentScope != concurrencyScope && parentScope instanceof ActivityImpl) {
                    ActivityImpl parentActivity = (ActivityImpl)parentScope;
                    if ((execution.getActivity() != null || execution.isActive()) && parentActivity.isScope()) {
                        concurrentRoot = execution.getParent();
                        if (!concurrentRoot.isConcurrent()) {
                            execution.setConcurrent(true);
                        } else {
                            concurrentRoot = concurrentRoot.getParent();
                        }
                    }
                }
                propagatingExecution = this.createConcurrentExecution(concurrentRoot, concurrentActivity);
            }
        }
        this.concurrentExecutionCreated(propagatingExecution);
    }

    protected abstract void concurrentExecutionCreated(PvmExecutionImpl var1);

    protected PvmExecutionImpl createConcurrentExecution(PvmExecutionImpl execution, ActivityImpl concurrentActivity) {
        PvmExecutionImpl newConcurrentExecution = execution.createExecution();
        newConcurrentExecution.setActivity(concurrentActivity);
        newConcurrentExecution.setScope(false);
        newConcurrentExecution.setActive(true);
        newConcurrentExecution.setConcurrent(true);
        return newConcurrentExecution;
    }

    protected boolean isConcurrentRoot(PvmExecutionImpl execution) {
        List<? extends PvmExecutionImpl> executions = execution.getExecutions();
        if (executions == null || executions.size() == 0) {
            return false;
        }
        return executions.get(0).isConcurrent();
    }

    protected boolean isLeaf(PvmExecutionImpl execution) {
        return execution.getExecutions().isEmpty();
    }

    protected ScopeImpl getCurrentScope(PvmExecutionImpl execution) {
        ActivityImpl activity = execution.getActivity();
        if (activity == null) {
            return null;
        }
        return activity.isScope() ? activity : activity.getParent();
    }

    @Override
    public boolean isAsync(PvmExecutionImpl execution) {
        return false;
    }
}

