/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.cmmn;

import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.engine.exception.NotAllowedException;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;

public class CaseServiceProcessTaskTest
extends PluggableProcessEngineTestCase {
    protected final String DEFINITION_KEY = "oneProcessTaskCase";
    protected final String PROCESS_TASK_KEY = "PI_ProcessTask_1";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testManualStart() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).manualStart();
        processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNotNull((Object)processInstance);
        CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertTrue((boolean)processTask.isActive());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testManualStartWithVariable() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).setVariable("aVariableName", (Object)"abc").setVariable("anotherVariableName", (Object)999).manualStart();
        processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNotNull((Object)processInstance);
        CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertTrue((boolean)processTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceProcessTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceProcessTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceProcessTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceProcessTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceProcessTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testManualStartWithVariables() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(processTaskId).setVariables(variables).manualStart();
        processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNotNull((Object)processInstance);
        CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertTrue((boolean)processTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceProcessTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceProcessTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseExecutionId());
            CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceProcessTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceProcessTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceProcessTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testManualStartWithLocalVariable() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).setVariableLocal("aVariableName", (Object)"abc").setVariableLocal("anotherVariableName", (Object)999).manualStart();
        processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNotNull((Object)processInstance);
        CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertTrue((boolean)processTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceProcessTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceProcessTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceProcessTaskTest.assertEquals((String)processTaskId, (String)variable.getCaseExecutionId());
            CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceProcessTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceProcessTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceProcessTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testManualStartWithLocalVariables() {
        String caseInstanceId = this.createCaseInstance("oneProcessTaskCase").getId();
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("aVariableName", "abc");
        variables.put("anotherVariableName", 999);
        this.caseService.withCaseExecution(processTaskId).setVariablesLocal(variables).manualStart();
        processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNotNull((Object)processInstance);
        CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)processInstance.getCaseInstanceId());
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertTrue((boolean)processTask.isActive());
        List result = this.runtimeService.createVariableInstanceQuery().list();
        CaseServiceProcessTaskTest.assertFalse((boolean)result.isEmpty());
        CaseServiceProcessTaskTest.assertEquals((int)2, (int)result.size());
        for (VariableInstance variable : result) {
            CaseServiceProcessTaskTest.assertEquals((String)processTaskId, (String)variable.getCaseExecutionId());
            CaseServiceProcessTaskTest.assertEquals((String)caseInstanceId, (String)variable.getCaseInstanceId());
            if (variable.getName().equals("aVariableName")) {
                CaseServiceProcessTaskTest.assertEquals((String)"aVariableName", (String)variable.getName());
                CaseServiceProcessTaskTest.assertEquals((Object)"abc", (Object)variable.getValue());
                continue;
            }
            if (variable.getName().equals("anotherVariableName")) {
                CaseServiceProcessTaskTest.assertEquals((String)"anotherVariableName", (String)variable.getName());
                CaseServiceProcessTaskTest.assertEquals((Object)999, (Object)variable.getValue());
                continue;
            }
            CaseServiceProcessTaskTest.fail((String)("Unexpected variable: " + variable.getName()));
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn"})
    public void testReenableAnEnabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        try {
            this.caseService.withCaseExecution(processTaskId).reenable();
            CaseServiceProcessTaskTest.fail((String)"It should not be possible to re-enable an enabled process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskAndOneHumanTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testReenableADisabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).disable();
        this.caseService.withCaseExecution(processTaskId).reenable();
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertTrue((boolean)processTask.isEnabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testReenableAnActiveProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).manualStart();
        try {
            this.caseService.withCaseExecution(processTaskId).reenable();
            CaseServiceProcessTaskTest.fail((String)"It should not be possible to re-enable an active process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskAndOneHumanTaskCase.cmmn"})
    public void testDisableAnEnabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        ProcessInstance processInstance = this.queryProcessInstance();
        CaseServiceProcessTaskTest.assertNull((Object)processInstance);
        this.caseService.withCaseExecution(processTaskId).disable();
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertTrue((boolean)processTask.isDisabled());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskAndOneHumanTaskCase.cmmn"})
    public void testDisableADisabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).disable();
        try {
            this.caseService.withCaseExecution(processTaskId).disable();
            CaseServiceProcessTaskTest.fail((String)"It should not be possible to disable a already disabled process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testDisableAnActiveProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        try {
            this.caseService.withCaseExecution(processTaskId).disable();
            CaseServiceProcessTaskTest.fail((String)"It should not be possible to disable an active process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskAndOneHumanTaskCase.cmmn"})
    public void testManualStartOfADisabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).disable();
        try {
            this.caseService.withCaseExecution(processTaskId).manualStart();
            CaseServiceProcessTaskTest.fail((String)"It should not be possible to start a disabled process task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testManualStartOfAnActiveProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        try {
            this.caseService.withCaseExecution(processTaskId).manualStart();
            CaseServiceProcessTaskTest.fail((String)"It should not be possible to start an already active process task manually.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testComplete() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        try {
            this.caseService.withCaseExecution(processTaskId).complete();
            CaseServiceProcessTaskTest.fail((String)"It should not be possible to complete a process task, while the process instance is still running.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn", "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    public void testCompleteProcessInstanceShouldCompleteProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).manualStart();
        String taskId = this.queryTask().getId();
        this.taskService.complete(taskId);
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertNull((Object)processTask);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().singleResult();
        CaseServiceProcessTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceProcessTaskTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn"})
    public void testDisableShouldCompleteCaseInstance() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).disable();
        CaseExecution processTask = this.queryCaseExecutionByActivityId("PI_ProcessTask_1");
        CaseServiceProcessTaskTest.assertNull((Object)processTask);
        CaseInstance caseInstance = (CaseInstance)this.caseService.createCaseInstanceQuery().completed().singleResult();
        CaseServiceProcessTaskTest.assertNotNull((Object)caseInstance);
        CaseServiceProcessTaskTest.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn"})
    public void testCompleteAnEnabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).complete();
            CaseServiceProcessTaskTest.fail((String)"Should not be able to complete an enabled process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskAndOneHumanTaskCase.cmmn"})
    public void testCompleteADisabledProcessTask() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        this.caseService.withCaseExecution(processTaskId).disable();
        try {
            this.caseService.withCaseExecution(processTaskId).complete();
            CaseServiceProcessTaskTest.fail((String)"Should not be able to complete a disabled process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneProcessTaskCase.cmmn"})
    public void testClose() {
        this.createCaseInstance("oneProcessTaskCase");
        String processTaskId = this.queryCaseExecutionByActivityId("PI_ProcessTask_1").getId();
        try {
            this.caseService.withCaseExecution(processTaskId).close();
            CaseServiceProcessTaskTest.fail((String)"It should not be possible to close a process task.");
        }
        catch (NotAllowedException notAllowedException) {
            // empty catch block
        }
    }

    protected CaseInstance createCaseInstance(String caseDefinitionKey) {
        return this.caseService.withCaseDefinitionByKey(caseDefinitionKey).create();
    }

    protected CaseExecution queryCaseExecutionByActivityId(String activityId) {
        return (CaseExecution)this.caseService.createCaseExecutionQuery().activityId(activityId).singleResult();
    }

    protected ProcessInstance queryProcessInstance() {
        return (ProcessInstance)this.runtimeService.createProcessInstanceQuery().singleResult();
    }

    protected Task queryTask() {
        return (Task)this.taskService.createTaskQuery().singleResult();
    }
}

