/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;

public class GroupQueryTest
extends PluggableProcessEngineTestCase {
    protected void setUp() throws Exception {
        super.setUp();
        this.createGroup("muppets", "Muppet show characters", "user");
        this.createGroup("frogs", "Famous frogs", "user");
        this.createGroup("mammals", "Famous mammals from eighties", "user");
        this.createGroup("admin", "Administrators", "security");
        this.identityService.saveUser(this.identityService.newUser("kermit"));
        this.identityService.saveUser(this.identityService.newUser("fozzie"));
        this.identityService.saveUser(this.identityService.newUser("mispiggy"));
        this.identityService.createMembership("kermit", "muppets");
        this.identityService.createMembership("fozzie", "muppets");
        this.identityService.createMembership("mispiggy", "muppets");
        this.identityService.createMembership("kermit", "frogs");
        this.identityService.createMembership("fozzie", "mammals");
        this.identityService.createMembership("mispiggy", "mammals");
        this.identityService.createMembership("kermit", "admin");
    }

    private Group createGroup(String id, String name, String type) {
        Group group = this.identityService.newGroup(id);
        group.setName(name);
        group.setType(type);
        this.identityService.saveGroup(group);
        return group;
    }

    protected void tearDown() throws Exception {
        this.identityService.deleteUser("kermit");
        this.identityService.deleteUser("fozzie");
        this.identityService.deleteUser("mispiggy");
        this.identityService.deleteGroup("muppets");
        this.identityService.deleteGroup("mammals");
        this.identityService.deleteGroup("frogs");
        this.identityService.deleteGroup("admin");
        super.tearDown();
    }

    public void testQueryById() {
        GroupQuery query = this.identityService.createGroupQuery().groupId("muppets");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidId() {
        GroupQuery query = this.identityService.createGroupQuery().groupId("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupId(null).list();
            GroupQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByIdIn() {
        GroupQueryTest.assertTrue((boolean)this.identityService.createGroupQuery().groupIdIn(new String[]{"a", "b"}).list().isEmpty());
        List list = this.identityService.createGroupQuery().list();
        String[] ids = new String[list.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = ((Group)list.get(i)).getId();
        }
        List idInList = this.identityService.createGroupQuery().groupIdIn(ids).list();
        GroupQueryTest.assertEquals((int)list.size(), (int)idInList.size());
        for (Group group : idInList) {
            boolean found = false;
            for (Group otherGroup : list) {
                if (!otherGroup.getId().equals(group.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            GroupQueryTest.fail((String)("Expected to find group " + group));
        }
    }

    public void testQueryByName() {
        GroupQuery query = this.identityService.createGroupQuery().groupName("Muppet show characters");
        this.verifyQueryResults(query, 1);
        query = this.identityService.createGroupQuery().groupName("Famous frogs");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidName() {
        GroupQuery query = this.identityService.createGroupQuery().groupName("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupName(null).list();
            GroupQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByNameLike() {
        GroupQuery query = this.identityService.createGroupQuery().groupNameLike("%Famous%");
        this.verifyQueryResults(query, 2);
        query = this.identityService.createGroupQuery().groupNameLike("Famous%");
        this.verifyQueryResults(query, 2);
        query = this.identityService.createGroupQuery().groupNameLike("%show%");
        this.verifyQueryResults(query, 1);
    }

    public void testQueryByInvalidNameLike() {
        GroupQuery query = this.identityService.createGroupQuery().groupNameLike("%invalid%");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupNameLike(null).list();
            GroupQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByType() {
        GroupQuery query = this.identityService.createGroupQuery().groupType("user");
        this.verifyQueryResults(query, 3);
        query = this.identityService.createGroupQuery().groupType("admin");
        this.verifyQueryResults(query, 0);
    }

    public void testQueryByInvalidType() {
        GroupQuery query = this.identityService.createGroupQuery().groupType("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupType(null).list();
            GroupQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQueryByMember() {
        GroupQuery query = this.identityService.createGroupQuery().groupMember("fozzie");
        this.verifyQueryResults(query, 2);
        query = this.identityService.createGroupQuery().groupMember("kermit");
        this.verifyQueryResults(query, 3);
        query = (GroupQuery)query.orderByGroupId().asc();
        List groups = query.list();
        GroupQueryTest.assertEquals((int)3, (int)groups.size());
        GroupQueryTest.assertEquals((String)"admin", (String)((Group)groups.get(0)).getId());
        GroupQueryTest.assertEquals((String)"frogs", (String)((Group)groups.get(1)).getId());
        GroupQueryTest.assertEquals((String)"muppets", (String)((Group)groups.get(2)).getId());
        query = query.groupType("user");
        groups = query.list();
        GroupQueryTest.assertEquals((int)2, (int)groups.size());
        GroupQueryTest.assertEquals((String)"frogs", (String)((Group)groups.get(0)).getId());
        GroupQueryTest.assertEquals((String)"muppets", (String)((Group)groups.get(1)).getId());
    }

    public void testQueryByInvalidMember() {
        GroupQuery query = this.identityService.createGroupQuery().groupMember("invalid");
        this.verifyQueryResults(query, 0);
        try {
            this.identityService.createGroupQuery().groupMember(null).list();
            GroupQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    public void testQuerySorting() {
        GroupQueryTest.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupId().asc()).count());
        GroupQueryTest.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupName().asc()).count());
        GroupQueryTest.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupType().asc()).count());
        GroupQueryTest.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupId().desc()).count());
        GroupQueryTest.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupName().desc()).count());
        GroupQueryTest.assertEquals((long)4L, (long)((GroupQuery)this.identityService.createGroupQuery().orderByGroupType().desc()).count());
        GroupQuery query = (GroupQuery)((GroupQuery)this.identityService.createGroupQuery().orderByGroupType().asc()).orderByGroupName().desc();
        List groups = query.list();
        GroupQueryTest.assertEquals((long)4L, (long)query.count());
        GroupQueryTest.assertEquals((String)"security", (String)((Group)groups.get(0)).getType());
        GroupQueryTest.assertEquals((String)"user", (String)((Group)groups.get(1)).getType());
        GroupQueryTest.assertEquals((String)"user", (String)((Group)groups.get(2)).getType());
        GroupQueryTest.assertEquals((String)"user", (String)((Group)groups.get(3)).getType());
        GroupQueryTest.assertEquals((String)"admin", (String)((Group)groups.get(0)).getId());
        GroupQueryTest.assertEquals((String)"muppets", (String)((Group)groups.get(1)).getId());
        GroupQueryTest.assertEquals((String)"mammals", (String)((Group)groups.get(2)).getId());
        GroupQueryTest.assertEquals((String)"frogs", (String)((Group)groups.get(3)).getId());
    }

    public void testQueryInvalidSortingUsage() {
        try {
            this.identityService.createGroupQuery().orderByGroupId().list();
            GroupQueryTest.fail();
        }
        catch (ProcessEngineException e) {
            // empty catch block
        }
        try {
            this.identityService.createGroupQuery().orderByGroupId().orderByGroupName().list();
            GroupQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    private void verifyQueryResults(GroupQuery query, int countExpected) {
        GroupQueryTest.assertEquals((int)countExpected, (int)query.list().size());
        GroupQueryTest.assertEquals((long)countExpected, (long)query.count());
        if (countExpected == 1) {
            GroupQueryTest.assertNotNull((Object)query.singleResult());
        } else if (countExpected > 1) {
            this.verifySingleResultFails(query);
        } else if (countExpected == 0) {
            GroupQueryTest.assertNull((Object)query.singleResult());
        }
    }

    private void verifySingleResultFails(GroupQuery query) {
        try {
            query.singleResult();
            GroupQueryTest.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }
}

