/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.HashMap;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.test.PluggableProcessEngineTestCase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;

public class ActivateJobTest
extends PluggableProcessEngineTestCase {
    public void tearDown() throws Exception {
        TestHelper.clearOpLog((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    public void testActivationById_shouldThrowProcessEngineException() {
        try {
            this.managementService.activateJobById(null);
            ActivateJobTest.fail((String)"A ProcessEngineExcpetion was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationById_shouldActivateJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        ActivateJobTest.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobById(job.getId());
        ActivateJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        ActivateJobTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        ActivateJobTest.assertEquals((String)job.getId(), (String)activeJob.getId());
        ActivateJobTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByJobDefinitionId_shouldActivateJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        ActivateJobTest.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobByJobDefinitionId(jobDefinition.getId());
        ActivateJobTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        ActivateJobTest.assertEquals((String)job.getId(), (String)activeJob.getId());
        ActivateJobTest.assertEquals((String)jobDefinition.getId(), (String)activeJob.getJobDefinitionId());
        ActivateJobTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivateByProcessInstanceId_shouldActivateJob() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        ActivateJobTest.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobByProcessInstanceId(processInstance.getId());
        ActivateJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        ActivateJobTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job suspendedJob = (Job)jobQuery.active().singleResult();
        ActivateJobTest.assertEquals((String)job.getId(), (String)suspendedJob.getId());
        ActivateJobTest.assertEquals((String)jobDefinition.getId(), (String)suspendedJob.getJobDefinitionId());
        ActivateJobTest.assertFalse((boolean)suspendedJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionId_shouldActivateJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        ActivateJobTest.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobByProcessDefinitionId(processDefinition.getId());
        ActivateJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        ActivateJobTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        ActivateJobTest.assertEquals((String)job.getId(), (String)activeJob.getId());
        ActivateJobTest.assertFalse((boolean)activeJob.isSuspended());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn"})
    public void testActivationByProcessDefinitionKey_shouldActivateJob() {
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("fail", Boolean.TRUE);
        this.runtimeService.startProcessInstanceByKey("suspensionProcess", params);
        this.managementService.suspendJobDefinitionByProcessDefinitionKey("suspensionProcess", true);
        JobQuery jobQuery = this.managementService.createJobQuery();
        Job job = (Job)jobQuery.singleResult();
        ActivateJobTest.assertTrue((boolean)job.isSuspended());
        this.managementService.activateJobByProcessDefinitionKey(processDefinition.getKey());
        ActivateJobTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobTest.assertEquals((long)1L, (long)jobQuery.active().count());
        Job activeJob = (Job)jobQuery.active().singleResult();
        ActivateJobTest.assertEquals((String)job.getId(), (String)activeJob.getId());
        ActivateJobTest.assertFalse((boolean)activeJob.isSuspended());
    }

    public void testMultipleActivationByProcessDefinitionKey_shouldActivateJob() {
        String key = "suspensionProcess";
        int nrOfProcessDefinitions = 3;
        for (int i = 0; i < nrOfProcessDefinitions; ++i) {
            this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/mgmt/SuspensionTest.testBase.bpmn").deploy();
            HashMap<String, Boolean> params = new HashMap<String, Boolean>();
            params.put("fail", Boolean.TRUE);
            this.runtimeService.startProcessInstanceByKey(key, params);
        }
        this.managementService.suspendJobDefinitionByProcessDefinitionKey(key, true);
        this.managementService.activateJobByProcessDefinitionKey(key);
        JobQuery jobQuery = this.managementService.createJobQuery();
        ActivateJobTest.assertEquals((long)0L, (long)jobQuery.suspended().count());
        ActivateJobTest.assertEquals((long)3L, (long)jobQuery.active().count());
        for (org.camunda.bpm.engine.repository.Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
    }
}

